/*
 * Decompiled with CFR 0.152.
 */
package org.openide.loaders;

import java.util.Date;
import java.util.Enumeration;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoader;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;

class FolderComparator
extends DataFolder.SortMode {
    public static final int NONE = 0;
    public static final int NAMES = 1;
    public static final int CLASS = 2;
    public static final int FOLDER_NAMES = 3;
    public static final int LAST_MODIFIED = 4;
    public static final int SIZE = 5;
    public static final int EXTENSIONS = 6;
    public static final int NATURAL = 7;
    private int mode;

    public FolderComparator() {
        this(3);
    }

    public FolderComparator(int n) {
        this.mode = n;
    }

    @Override
    public int compare(DataObject dataObject, DataObject dataObject2) {
        return this.doCompare(dataObject, dataObject2);
    }

    int doCompare(Object object, Object object2) {
        switch (this.mode) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.compareNames(object, object2);
            }
            case 2: {
                return this.compareClass(object, object2);
            }
            case 3: {
                return this.compareFoldersFirst(object, object2);
            }
            case 4: {
                return FolderComparator.compareLastModified(object, object2);
            }
            case 5: {
                return FolderComparator.compareSize(object, object2);
            }
            case 6: {
                return this.compareExtensions(object, object2);
            }
            case 7: {
                return FolderComparator.compareNatural(object, object2);
            }
        }
        assert (false) : this.mode;
        return 0;
    }

    static FileObject findFileObject(Object object) {
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        Node node = (Node)object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    private static DataObject findDataObject(Object object) {
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        if (object instanceof FileObject) {
            try {
                return DataObject.find((FileObject)object);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                return null;
            }
        }
        Node node = (Node)object;
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject;
    }

    private int compareNames(Object object, Object object2) {
        return FolderComparator.findFileObject(object).getNameExt().compareTo(FolderComparator.findFileObject(object2).getNameExt());
    }

    private int compareFoldersFirst(Object object, Object object2) {
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        return this.compareNames(object, object2);
    }

    private int compareExtensions(Object object, Object object2) {
        String string;
        boolean bl;
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        boolean bl2 = fileObject.isFolder();
        if (bl2 != (bl = fileObject2.isFolder())) {
            return bl2 ? -1 : 1;
        }
        if (bl2) {
            return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
        }
        String string2 = fileObject.getExt();
        if (string2.equals(string = fileObject2.getExt())) {
            return fileObject.getName().compareTo(fileObject2.getName());
        }
        return string2.compareTo(string);
    }

    private int compareClass(Object object, Object object2) {
        Class<?> clazz;
        DataObject dataObject = FolderComparator.findDataObject(object);
        DataObject dataObject2 = FolderComparator.findDataObject(object2);
        Class<?> clazz2 = dataObject.getClass();
        if (clazz2 == (clazz = dataObject2.getClass())) {
            return this.compareNames(dataObject, dataObject2);
        }
        DataLoaderPool dataLoaderPool = DataLoaderPool.getDefault();
        Enumeration<DataLoader> enumeration = dataLoaderPool.allLoaders();
        while (enumeration.hasMoreElements()) {
            Class<? extends DataObject> clazz3 = enumeration.nextElement().getRepresentationClass();
            if (clazz3 == DataObject.class) continue;
            boolean bl = clazz3.isAssignableFrom(clazz2);
            boolean bl2 = clazz3.isAssignableFrom(clazz);
            if (bl && bl2) {
                return this.compareNames(dataObject, dataObject2);
            }
            if (bl) {
                return -1;
            }
            if (!bl2) continue;
            return 1;
        }
        return this.compareNames(dataObject, dataObject2);
    }

    private static int compareLastModified(Object object, Object object2) {
        Date date;
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        Date date2 = fileObject.lastModified();
        if (date2.after(date = fileObject2.lastModified())) {
            return -1;
        }
        if (date.after(date2)) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }

    private static int compareSize(Object object, Object object2) {
        long l;
        boolean bl;
        boolean bl2 = FolderComparator.findFileObject(object).isFolder();
        if (bl2 != (bl = FolderComparator.findFileObject(object2).isFolder())) {
            return bl2 ? -1 : 1;
        }
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        long l2 = fileObject.getSize();
        if (l2 > (l = fileObject2.getSize())) {
            return -1;
        }
        if (l > l2) {
            return 1;
        }
        return fileObject.getNameExt().compareTo(fileObject2.getNameExt());
    }

    private static int compareNatural(Object object, Object object2) {
        boolean bl;
        FileObject fileObject = FolderComparator.findFileObject(object);
        FileObject fileObject2 = FolderComparator.findFileObject(object2);
        boolean bl2 = fileObject.isFolder();
        if (bl2 != (bl = fileObject2.isFolder())) {
            return bl2 ? -1 : 1;
        }
        int n = FolderComparator.compareFileNameNatural(fileObject.getNameExt(), fileObject2.getNameExt());
        return n;
    }

    private static int compareFileNameNatural(String string, String string2) {
        char c;
        char c2;
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        int n = 0;
        int n2 = 0;
        while (n < string3.length() && n2 < string4.length()) {
            c2 = string3.charAt(n);
            c = string4.charAt(n2);
            ReadNumericValueResult readNumericValueResult = FolderComparator.readNumericValue(string3, n);
            ReadNumericValueResult readNumericValueResult2 = FolderComparator.readNumericValue(string4, n2);
            if (readNumericValueResult != null && readNumericValueResult2 != null) {
                if (readNumericValueResult.getValue() == readNumericValueResult2.getValue()) {
                    n = readNumericValueResult.getEndPos();
                    n2 = readNumericValueResult2.getEndPos();
                    continue;
                }
                return readNumericValueResult.getValue() - readNumericValueResult2.getValue();
            }
            if (c2 != c) {
                return c2 - c;
            }
            ++n;
            ++n2;
        }
        c2 = n < string3.length() ? (char)'\u0001' : '\u0000';
        char c3 = c = n2 < string4.length() ? (char)'\u0001' : '\u0000';
        if (c2 == '\u0000' && c == '\u0000') {
            return string.compareTo(string2);
        }
        if (c2 != '\u0000') {
            return 1;
        }
        if (c != '\u0000') {
            return -1;
        }
        assert (false) : "Invalid state in natural comparator";
        return string3.compareTo(string4);
    }

    private static ReadNumericValueResult readNumericValue(String string, int n) {
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n3 = string.length();
        for (int i = n; i < n3; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                if (bl2) {
                    return new ReadNumericValueResult(n2, i);
                }
                n2 = n2 * 10 + (c - 48);
                bl = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (!bl) continue;
                bl2 = true;
                continue;
            }
            return bl ? new ReadNumericValueResult(n2, i) : null;
        }
        return bl ? new ReadNumericValueResult(n2, n3) : null;
    }

    private static class ReadNumericValueResult {
        private final int value;
        private final int endPos;

        public ReadNumericValueResult(int n, int n2) {
            this.value = n;
            this.endPos = n2;
        }

        public int getValue() {
            return this.value;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

