/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartBar
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartBar() {
        super(false, CommandChartBar.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartBar.class.getName(), RegexLeaf.start(), new RegexLeaf("bar"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "STEREO", "(\\<\\<.+?\\>\\>)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "NAME", "\"([^\"]+)\"")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "DATA", "\\[(.*)\\]"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "COLOR", "#([0-9a-fA-F]{6}|[0-9a-fA-F]{3}|\\w+)")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABELS", "(labels)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String labelsStr;
        String stereo = arg.getLazzy("STEREO", 0);
        String name = arg.getLazzy("NAME", 0);
        String data = arg.get("DATA", 0);
        String colorStr = arg.getLazzy("COLOR", 0);
        List<Double> values = this.parseValues(data);
        if (values == null) {
            return CommandExecutionResult.error("Invalid number format in bar data");
        }
        String seriesName = name != null ? name : "bar" + diagram.getSeries().size();
        ChartSeries series = new ChartSeries(seriesName, ChartSeries.SeriesType.BAR, values);
        if (stereo != null) {
            series.setStereotype(Stereotype.build(stereo));
        }
        if (colorStr != null) {
            HColor color = diagram.getSkinParam().getIHtmlColorSet().getColor("#" + colorStr);
            series.setColor(color);
        }
        if ((labelsStr = arg.getLazzy("LABELS", 0)) != null) {
            series.setShowLabels(true);
        }
        return diagram.addSeries(series);
    }

    private List<Double> parseValues(String data) {
        String[] parts;
        ArrayList<Double> result = new ArrayList<Double>();
        if (data == null || data.trim().isEmpty()) {
            return result;
        }
        for (String part : parts = data.split(",")) {
            try {
                result.add(Double.parseDouble(part.trim()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }
}

