/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.query_dsl;

import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.query_dsl.SpanQuery;
import org.opensearch.client.opensearch._types.query_dsl.SpanQueryVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class SpanGapQuery
implements SpanQueryVariant,
PlainJsonSerializable,
ToCopyableBuilder<Builder, SpanGapQuery> {
    @Nonnull
    private final String field;
    private final int spanWidth;
    public static final JsonpDeserializer<SpanGapQuery> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SpanGapQuery::setupSpanGapQueryDeserializer);

    private SpanGapQuery(Builder builder) {
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.spanWidth = ApiTypeHelper.requireNonNull(builder.spanWidth, this, "spanWidth");
    }

    public static SpanGapQuery of(Function<Builder, ObjectBuilder<SpanGapQuery>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public SpanQuery.Kind _spanQueryKind() {
        return SpanQuery.Kind.SpanGap;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    public final int spanWidth() {
        return this.spanWidth;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey(this.field);
        generator.write(this.spanWidth);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupSpanGapQueryDeserializer(ObjectDeserializer<Builder> op) {
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            builder.field((String)name);
            builder.spanWidth(JsonpDeserializer.integerDeserializer().deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Integer.hashCode(this.spanWidth);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpanGapQuery other = (SpanGapQuery)o;
        return this.field.equals(other.field) && this.spanWidth == other.spanWidth;
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, SpanGapQuery> {
        private String field;
        private Integer spanWidth;

        public Builder() {
        }

        private Builder(SpanGapQuery o) {
            this.field = o.field;
            this.spanWidth = o.spanWidth;
        }

        private Builder(Builder o) {
            this.field = o.field;
            this.spanWidth = o.spanWidth;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder spanWidth(int value) {
            this.spanWidth = value;
            return this;
        }

        @Override
        @Nonnull
        public SpanGapQuery build() {
            this._checkSingleUse();
            return new SpanGapQuery(this);
        }
    }
}

