/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.download;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.plus.Version;
import net.osmand.plus.download.DownloadActivityType;
import net.osmand.plus.download.IndexItem;
import net.osmand.plus.helpers.FileNameTranslationHelper;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import org.apache.commons.logging.Log;

public class DownloadFileHelper {
    private static final Log log = PlatformUtil.getLog(DownloadFileHelper.class);
    private static final int BUFFER_SIZE = 32256;
    protected static final int TRIES_TO_DOWNLOAD = 15;
    protected static final long TIMEOUT_BETWEEN_DOWNLOADS = 8000L;
    private final OsmWindow ctx;
    private boolean interruptDownloading = false;

    public DownloadFileHelper(OsmWindow ctx) {
        this.ctx = ctx;
    }

    public static boolean isInterruptedException(IOException e) {
        return e != null && e.getMessage().equals("Interrupted");
    }

    public InputStream getInputStreamToDownload(final URL url, final boolean forceWifi) throws IOException {
        InputStream cis = new InputStream(){
            byte[] buffer = new byte[32256];
            int bufLen = 0;
            int bufRead = 0;
            int length = 0;
            int fileread = 0;
            int triesDownload = 15;
            boolean notFound = false;
            boolean first = true;
            private InputStream is;

            private void reconnect() throws IOException {
                while (this.triesDownload > 0) {
                    try {
                        boolean wifiConnectionBroken;
                        if (!this.first) {
                            log.info((Object)"Reconnecting");
                            try {
                                Thread.sleep(8000L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        HttpURLConnection conn = NetworkUtils.getHttpURLConnection(url);
                        conn.setRequestProperty("User-Agent", Version.getFullVersion(DownloadFileHelper.this.ctx));
                        conn.setReadTimeout(30000);
                        if (this.fileread > 0) {
                            String range = "bytes=" + this.fileread + "-" + (this.length - 1);
                            conn.setRequestProperty("Range", range);
                        }
                        conn.setConnectTimeout(30000);
                        log.info((Object)(conn.getResponseMessage() + " " + conn.getResponseCode()));
                        boolean bl = wifiConnectionBroken = forceWifi && !DownloadFileHelper.this.isWifiConnected();
                        if (conn.getResponseCode() != 404) {
                            if (conn.getResponseCode() != 206 && conn.getResponseCode() != 200 || wifiConnectionBroken) {
                                conn.disconnect();
                                --this.triesDownload;
                                continue;
                            }
                            this.is = conn.getInputStream();
                            if (this.first) {
                                this.length = conn.getContentLength();
                            }
                            this.first = false;
                            return;
                        }
                        this.notFound = true;
                        break;
                    }
                    catch (IOException e) {
                        log.error((Object)"IOException", (Throwable)e);
                        --this.triesDownload;
                    }
                }
                if (this.notFound) {
                    throw new IOException("File not found ");
                }
                if (this.length == 0) {
                    throw new IOException("File was not fully read");
                }
                if (this.triesDownload == 0 && this.length != this.fileread) {
                    throw new IOException("File was not fully read");
                }
            }

            @Override
            public synchronized void reset() throws IOException {
                this.reconnect();
            }

            @Override
            public int read(byte[] buffer, int offset, int len) throws IOException {
                if (this.bufLen == -1) {
                    return -1;
                }
                if (this.bufRead >= this.bufLen) {
                    this.refillBuffer();
                }
                if (this.bufLen == -1) {
                    return -1;
                }
                int av = this.bufLen - this.bufRead;
                int min = Math.min(len, av);
                System.arraycopy(this.buffer, this.bufRead, buffer, offset, min);
                this.bufRead += min;
                return min;
            }

            @Override
            public int read() throws IOException {
                int r = -1;
                if (this.bufLen == -1) {
                    return -1;
                }
                this.refillBuffer();
                if (this.bufRead < this.bufLen) {
                    int b;
                    return (b = this.buffer[this.bufRead++]) >= 0 ? b : b + 256;
                }
                if (this.length <= this.fileread) {
                    throw new IOException("File was not fully read");
                }
                return r;
            }

            private void refillBuffer() throws IOException {
                boolean readAgain;
                boolean bl = readAgain = this.bufRead >= this.bufLen;
                while (readAgain) {
                    if (this.is == null) {
                        this.reconnect();
                    }
                    try {
                        readAgain = false;
                        this.bufRead = 0;
                        this.bufLen = this.is.read(this.buffer);
                        if (this.bufLen == -1) continue;
                        this.fileread += this.bufLen;
                        if (!DownloadFileHelper.this.interruptDownloading) continue;
                        break;
                    }
                    catch (IOException e) {
                        if (DownloadFileHelper.this.interruptDownloading) {
                            log.error((Object)"IOException", (Throwable)e);
                        }
                        --this.triesDownload;
                        this.reconnect();
                        readAgain = true;
                    }
                }
                if (DownloadFileHelper.this.interruptDownloading) {
                    throw new IOException("Interrupted");
                }
            }

            @Override
            public void close() throws IOException {
                if (this.is != null) {
                    this.is.close();
                }
            }

            @Override
            public int available() throws IOException {
                if (this.is == null) {
                    this.reconnect();
                }
                return this.length - this.fileread;
            }
        };
        cis.reset();
        return cis;
    }

    public boolean isWifiConnected() {
        return this.ctx.getSettings().isWifiConnected();
    }

    public boolean downloadFile(IndexItem.DownloadEntry de, IProgress progress, List<File> toReIndex, DownloadFileShowWarning showWarningCallback, boolean forceWifi) throws InterruptedException {
        try {
            ArrayList<InputStream> downloadInputStreams = new ArrayList<InputStream>();
            URL url = new URL(de.urlToDownload);
            log.debug((Object)("Url downloading " + de.urlToDownload));
            downloadInputStreams.add(this.getInputStreamToDownload(url, forceWifi));
            de.fileToDownload = de.targetFile;
            if (!de.unzipFolder) {
                de.fileToDownload = new File(de.targetFile.getParentFile(), de.targetFile.getName() + ".download");
            }
            this.unzipFile(de, progress, downloadInputStreams);
            if (!de.targetFile.getAbsolutePath().equals(de.fileToDownload.getAbsolutePath())) {
                Algorithms.removeAllFiles(de.targetFile);
                boolean renamed = de.fileToDownload.renameTo(de.targetFile);
                if (!renamed) {
                    showWarningCallback.showWarning(this.ctx.getString(542) + ": old file can't be deleted");
                    return false;
                }
            }
            if (de.type == DownloadActivityType.VOICE_FILE) {
                this.copyVoiceConfig(de);
            }
            toReIndex.add(de.targetFile);
            showWarningCallback.showWarning(this.ctx.getString(756));
            return true;
        }
        catch (IOException e) {
            log.error((Object)"Exception ocurred", (Throwable)e);
            showWarningCallback.showWarning(this.ctx.getString(542) + ": " + e.getMessage());
            Algorithms.removeAllFiles(de.fileToDownload);
            return false;
        }
    }

    private void copyVoiceConfig(IndexItem.DownloadEntry de) {
        File f = this.ctx.getAppPath("/voice/" + de.baseName + "/_config.p");
        if (f.exists()) {
            try {
                FileInputStream is = new FileInputStream(this.ctx.getAppPath("voice/" + de.baseName + "/config.p"));
                int size = ((InputStream)is).available();
                byte[] buffer = new byte[size];
                ((InputStream)is).read(buffer);
                ((InputStream)is).close();
                FileOutputStream fos = new FileOutputStream(f);
                fos.write(buffer);
                fos.close();
            }
            catch (Exception ex) {
                log.debug((Object)ex.getMessage());
            }
        }
    }

    private void unzipFile(IndexItem.DownloadEntry de, IProgress progress, List<InputStream> is) throws IOException {
        CountingMultiInputStream fin = new CountingMultiInputStream(is);
        int len = fin.available();
        int mb = (int)((float)len / 1048576.0f);
        if (mb == 0) {
            mb = 1;
        }
        String taskName = this.ctx.getString(1154) + " " + FileNameTranslationHelper.getFileName(this.ctx, this.ctx.getRegions(), de.baseName);
        progress.startTask(taskName, len / 1024);
        if (!de.zipStream) {
            this.copyFile(de, progress, fin, len, fin, de.fileToDownload);
        } else if (de.urlToDownload.contains(".gz")) {
            GZIPInputStream zipIn = new GZIPInputStream(fin);
            this.copyFile(de, progress, fin, len, zipIn, de.fileToDownload);
        } else {
            if (de.unzipFolder) {
                de.fileToDownload.mkdirs();
            }
            ZipInputStream zipIn = new ZipInputStream(fin);
            ZipEntry entry = null;
            boolean first = true;
            while ((entry = zipIn.getNextEntry()) != null) {
                File fs;
                if (entry.isDirectory() || entry.getName().endsWith(".gen.log")) continue;
                if (!de.unzipFolder) {
                    if (first) {
                        fs = de.fileToDownload;
                        first = false;
                    } else {
                        int i;
                        String name = entry.getName();
                        int ind = name.lastIndexOf(95);
                        if (ind > 0 && (i = name.indexOf(46, ind)) > 0) {
                            name = name.substring(0, ind) + name.substring(i, name.length());
                        }
                        fs = new File(de.fileToDownload.getParent(), name);
                    }
                } else {
                    fs = new File(de.fileToDownload, entry.getName());
                }
                this.copyFile(de, progress, fin, len, zipIn, fs);
            }
            zipIn.close();
        }
        fin.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(IndexItem.DownloadEntry de, IProgress progress, CountingMultiInputStream countIS, int length, InputStream toRead, File targetFile) throws IOException {
        targetFile.getParentFile().mkdirs();
        try (FileOutputStream out = new FileOutputStream(targetFile);){
            int read;
            byte[] buffer = new byte[32256];
            int remaining = length;
            while ((read = toRead.read(buffer)) != -1) {
                out.write(buffer, 0, read);
                remaining -= countIS.getAndClearReadCount();
                if (progress.isInterrupted()) {
                    throw new IOException("Download interrupted");
                }
                progress.remaining(remaining / 1024);
            }
        }
        targetFile.setLastModified(de.dateModified);
    }

    public void setInterruptDownloading(boolean interruptDownloading) {
        this.interruptDownloading = interruptDownloading;
    }

    public boolean isInterruptDownloading() {
        return this.interruptDownloading;
    }

    private static class CountingMultiInputStream
    extends InputStream {
        private final InputStream[] delegate;
        private int count;
        private int currentRead = 0;

        public CountingMultiInputStream(List<InputStream> streams) {
            this.delegate = streams.toArray(new InputStream[streams.size()]);
        }

        @Override
        public int read(byte[] buffer, int offset, int length) throws IOException {
            int r = -1;
            while (r == -1 && this.currentRead < this.delegate.length) {
                r = this.delegate[this.currentRead].read(buffer, offset, length);
                if (r != -1) continue;
                this.delegate[this.currentRead].close();
                ++this.currentRead;
            }
            if (r > 0) {
                this.count += r;
            }
            return r;
        }

        @Override
        public int read() throws IOException {
            if (this.currentRead >= this.delegate.length) {
                return -1;
            }
            int r = -1;
            while (r == -1 && this.currentRead < this.delegate.length) {
                r = this.delegate[this.currentRead].read();
                if (r == -1) {
                    this.delegate[this.currentRead].close();
                    ++this.currentRead;
                    continue;
                }
                ++this.count;
            }
            return r;
        }

        @Override
        public int available() throws IOException {
            int av = 0;
            for (int i = this.currentRead; i < this.delegate.length; ++i) {
                av += this.delegate[i].available();
            }
            return av;
        }

        public int getAndClearReadCount() {
            int last = this.count;
            this.count = 0;
            return last;
        }
    }

    public static interface DownloadFileShowWarning {
        public void showWarning(String var1);
    }
}

