/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.ApiUsageLogger;
import io.opentelemetry.api.trace.PropagatedSpan;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanContextKey;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;

public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = (Span)Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ApiUsageLogger.log("context is null");
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public Span setStatus(StatusCode var1, String var2);

    public Span recordException(Throwable var1, Attributes var2);

    public void end();

    public SpanContext getSpanContext();
}

