/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Join N-D images into an (N+1)-D image.


This filter is templated over the input image type and the output
image type. The pixel type of them must be the same and the input
dimension must be less than the output dimension. When the input
images are N-dimensional, they are joined in order and the size of the
N+1'th dimension of the output is same as the number of the inputs.
The spacing and the origin (where the first input is placed) for the
N+1'th dimension is specified in this filter. The output image
information for the first N dimensions are taken from the first input.
Note that all the inputs should have the same information.


Hideaki Hiraki
 Contributed in the users list https://public.kitware.com/pipermail/insight-
users/2004-February/006542.html


See:
 itk::simple::JoinSeries for the procedural interface


C++ includes: sitkJoinSeriesImageFilter.h
*/
public class JoinSeriesImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected JoinSeriesImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.JoinSeriesImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(JoinSeriesImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(JoinSeriesImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::JoinSeriesImageFilter::~JoinSeriesImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_JoinSeriesImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::JoinSeriesImageFilter::JoinSeriesImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  JoinSeriesImageFilter() {
    this(SimpleITKJNI.new_JoinSeriesImageFilter(), true);
  }

  /**
Self&amp; itk::simple::JoinSeriesImageFilter::SetOrigin(double Origin)

Set/Get origin of the new dimension

*/
public  void setOrigin(double Origin) {
    SimpleITKJNI.JoinSeriesImageFilter_setOrigin(swigCPtr, this, Origin);
  }

  /**
double itk::simple::JoinSeriesImageFilter::GetOrigin() const

Set/Get origin of the new dimension

*/
public  double getOrigin() {
    return SimpleITKJNI.JoinSeriesImageFilter_getOrigin(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::JoinSeriesImageFilter::SetSpacing(double Spacing)

Set/Get spacing of the new dimension

*/
public  void setSpacing(double Spacing) {
    SimpleITKJNI.JoinSeriesImageFilter_setSpacing(swigCPtr, this, Spacing);
  }

  /**
double itk::simple::JoinSeriesImageFilter::GetSpacing() const

Set/Get spacing of the new dimension

*/
public  double getSpacing() {
    return SimpleITKJNI.JoinSeriesImageFilter_getSpacing(swigCPtr, this);
  }

  /**
std::string itk::simple::JoinSeriesImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.JoinSeriesImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::JoinSeriesImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.JoinSeriesImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(VectorOfImage images) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_0(swigCPtr, this, VectorOfImage.getCPtr(images), images), true);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_2(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_3(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3), true);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_4(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4), true);
  }

  /**
Image itk::simple::JoinSeriesImageFilter::Execute(const std::vector&lt; Image &gt; &amp;images)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2, Image image3, Image image4, Image image5) {
    return new Image(SimpleITKJNI.JoinSeriesImageFilter_execute__SWIG_5(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2, Image.getCPtr(image3), image3, Image.getCPtr(image4), image4, Image.getCPtr(image5), image5), true);
  }

}
