/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.ParseException;
import javafx.beans.NamedArg;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.scene.control.Spinner;
import javafx.util.StringConverter;
import javafx.util.converter.IntegerStringConverter;

public abstract class SpinnerValueFactory<T> {
    private ObjectProperty<T> value = new SimpleObjectProperty(this, "value");
    private ObjectProperty<StringConverter<T>> converter = new SimpleObjectProperty<StringConverter<T>>(this, "converter");
    private BooleanProperty wrapAround;

    public abstract void decrement(int var1);

    public abstract void increment(int var1);

    public final T getValue() {
        return this.value.get();
    }

    public final void setValue(T t) {
        this.value.set(t);
    }

    public final ObjectProperty<T> valueProperty() {
        return this.value;
    }

    public final StringConverter<T> getConverter() {
        return (StringConverter)this.converter.get();
    }

    public final void setConverter(StringConverter<T> stringConverter) {
        this.converter.set(stringConverter);
    }

    public final ObjectProperty<StringConverter<T>> converterProperty() {
        return this.converter;
    }

    public final void setWrapAround(boolean bl) {
        this.wrapAroundProperty().set(bl);
    }

    public final boolean isWrapAround() {
        return this.wrapAround == null ? false : this.wrapAround.get();
    }

    public final BooleanProperty wrapAroundProperty() {
        if (this.wrapAround == null) {
            this.wrapAround = new SimpleBooleanProperty(this, "wrapAround", false);
        }
        return this.wrapAround;
    }

    public static class DoubleSpinnerValueFactory
    extends SpinnerValueFactory<Double> {
        private DoubleProperty min = new SimpleDoubleProperty(this, "min"){

            @Override
            protected void invalidated() {
                Double d = (Double)this.getValue();
                if (d == null) {
                    return;
                }
                double d2 = this.get();
                if (d2 > this.getMax()) {
                    this.setMin(this.getMax());
                    return;
                }
                if (d < d2) {
                    this.setValue(d2);
                }
            }
        };
        private DoubleProperty max = new SimpleDoubleProperty(this, "max"){

            @Override
            protected void invalidated() {
                Double d = (Double)this.getValue();
                if (d == null) {
                    return;
                }
                double d2 = this.get();
                if (d2 < this.getMin()) {
                    this.setMax(this.getMin());
                    return;
                }
                if (d > d2) {
                    this.setValue(d2);
                }
            }
        };
        private DoubleProperty amountToStepBy = new SimpleDoubleProperty(this, "amountToStepBy");

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double d, @NamedArg(value="max") double d2) {
            this(d, d2, d);
        }

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double d, @NamedArg(value="max") double d2, @NamedArg(value="initialValue") double d3) {
            this(d, d2, d3, 1.0);
        }

        public DoubleSpinnerValueFactory(@NamedArg(value="min") double d3, @NamedArg(value="max") double d4, @NamedArg(value="initialValue") double d5, @NamedArg(value="amountToStepBy") double d6) {
            this.setMin(d3);
            this.setMax(d4);
            this.setAmountToStepBy(d6);
            this.setConverter(new StringConverter<Double>(){
                private final DecimalFormat df = new DecimalFormat("#.##");

                @Override
                public String toString(Double d) {
                    if (d == null) {
                        return "";
                    }
                    return this.df.format(d);
                }

                @Override
                public Double fromString(String string) {
                    try {
                        if (string == null) {
                            return null;
                        }
                        if ((string = string.trim()).length() < 1) {
                            return null;
                        }
                        return this.df.parse(string).doubleValue();
                    }
                    catch (ParseException parseException) {
                        throw new RuntimeException(parseException);
                    }
                }
            });
            this.valueProperty().addListener((observableValue, d, d2) -> {
                if (d2 == null) {
                    return;
                }
                if (d2 < this.getMin()) {
                    this.setValue(this.getMin());
                } else if (d2 > this.getMax()) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(d5 >= d3 && d5 <= d4 ? d5 : d3);
        }

        public final void setMin(double d) {
            this.min.set(d);
        }

        public final double getMin() {
            return this.min.get();
        }

        public final DoubleProperty minProperty() {
            return this.min;
        }

        public final void setMax(double d) {
            this.max.set(d);
        }

        public final double getMax() {
            return this.max.get();
        }

        public final DoubleProperty maxProperty() {
            return this.max;
        }

        public final void setAmountToStepBy(double d) {
            this.amountToStepBy.set(d);
        }

        public final double getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final DoubleProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int n) {
            BigDecimal bigDecimal = BigDecimal.valueOf((Double)this.getValue());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(this.getMin());
            BigDecimal bigDecimal3 = BigDecimal.valueOf(this.getMax());
            BigDecimal bigDecimal4 = BigDecimal.valueOf(this.getAmountToStepBy());
            BigDecimal bigDecimal5 = bigDecimal.subtract(bigDecimal4.multiply(BigDecimal.valueOf(n)));
            this.setValue(bigDecimal5.compareTo(bigDecimal2) >= 0 ? bigDecimal5.doubleValue() : (this.isWrapAround() ? Spinner.wrapValue(bigDecimal5, bigDecimal2, bigDecimal3).doubleValue() : this.getMin()));
        }

        @Override
        public void increment(int n) {
            BigDecimal bigDecimal = BigDecimal.valueOf((Double)this.getValue());
            BigDecimal bigDecimal2 = BigDecimal.valueOf(this.getMin());
            BigDecimal bigDecimal3 = BigDecimal.valueOf(this.getMax());
            BigDecimal bigDecimal4 = BigDecimal.valueOf(this.getAmountToStepBy());
            BigDecimal bigDecimal5 = bigDecimal.add(bigDecimal4.multiply(BigDecimal.valueOf(n)));
            this.setValue(bigDecimal5.compareTo(bigDecimal3) <= 0 ? bigDecimal5.doubleValue() : (this.isWrapAround() ? Spinner.wrapValue(bigDecimal5, bigDecimal2, bigDecimal3).doubleValue() : this.getMax()));
        }
    }

    public static class IntegerSpinnerValueFactory
    extends SpinnerValueFactory<Integer> {
        private IntegerProperty min = new SimpleIntegerProperty(this, "min"){

            @Override
            protected void invalidated() {
                Integer n = (Integer)this.getValue();
                if (n == null) {
                    return;
                }
                int n2 = this.get();
                if (n2 > this.getMax()) {
                    this.setMin(this.getMax());
                    return;
                }
                if (n < n2) {
                    this.setValue(n2);
                }
            }
        };
        private IntegerProperty max = new SimpleIntegerProperty(this, "max"){

            @Override
            protected void invalidated() {
                Integer n = (Integer)this.getValue();
                if (n == null) {
                    return;
                }
                int n2 = this.get();
                if (n2 < this.getMin()) {
                    this.setMax(this.getMin());
                    return;
                }
                if (n > n2) {
                    this.setValue(n2);
                }
            }
        };
        private IntegerProperty amountToStepBy = new SimpleIntegerProperty(this, "amountToStepBy");

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int n, @NamedArg(value="max") int n2) {
            this(n, n2, n);
        }

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int n, @NamedArg(value="max") int n2, @NamedArg(value="initialValue") int n3) {
            this(n, n2, n3, 1);
        }

        public IntegerSpinnerValueFactory(@NamedArg(value="min") int n3, @NamedArg(value="max") int n4, @NamedArg(value="initialValue") int n5, @NamedArg(value="amountToStepBy") int n6) {
            this.setMin(n3);
            this.setMax(n4);
            this.setAmountToStepBy(n6);
            this.setConverter(new IntegerStringConverter());
            this.valueProperty().addListener((observableValue, n, n2) -> {
                if (n2 < this.getMin()) {
                    this.setValue(this.getMin());
                } else if (n2 > this.getMax()) {
                    this.setValue(this.getMax());
                }
            });
            this.setValue(n5 >= n3 && n5 <= n4 ? n5 : n3);
        }

        public final void setMin(int n) {
            this.min.set(n);
        }

        public final int getMin() {
            return this.min.get();
        }

        public final IntegerProperty minProperty() {
            return this.min;
        }

        public final void setMax(int n) {
            this.max.set(n);
        }

        public final int getMax() {
            return this.max.get();
        }

        public final IntegerProperty maxProperty() {
            return this.max;
        }

        public final void setAmountToStepBy(int n) {
            this.amountToStepBy.set(n);
        }

        public final int getAmountToStepBy() {
            return this.amountToStepBy.get();
        }

        public final IntegerProperty amountToStepByProperty() {
            return this.amountToStepBy;
        }

        @Override
        public void decrement(int n) {
            int n2 = this.getMin();
            int n3 = this.getMax();
            int n4 = (Integer)this.getValue() - n * this.getAmountToStepBy();
            this.setValue(n4 >= n2 ? n4 : (this.isWrapAround() ? Spinner.wrapValue(n4, n2, n3) + 1 : n2));
        }

        @Override
        public void increment(int n) {
            int n2 = this.getMin();
            int n3 = this.getMax();
            int n4 = (Integer)this.getValue();
            int n5 = n4 + n * this.getAmountToStepBy();
            this.setValue(n5 <= n3 ? n5 : (this.isWrapAround() ? Spinner.wrapValue(n5, n2, n3) - 1 : n3));
        }
    }

    public static class ListSpinnerValueFactory<T>
    extends SpinnerValueFactory<T> {
        private int currentIndex = 0;
        private final ListChangeListener<T> itemsContentObserver = change -> this.updateCurrentIndex();
        private WeakListChangeListener<T> weakItemsContentObserver = new WeakListChangeListener<T>(this.itemsContentObserver);
        private ObjectProperty<ObservableList<T>> items;

        public ListSpinnerValueFactory(@NamedArg(value="items") ObservableList<T> observableList) {
            this.setItems(observableList);
            this.setConverter(new StringConverter<T>(){

                @Override
                public String toString(T t) {
                    if (t == null) {
                        return "";
                    }
                    return t.toString();
                }

                @Override
                public T fromString(String string) {
                    return string;
                }
            });
            this.valueProperty().addListener((observableValue, object, object2) -> {
                int n = -1;
                if (observableList.contains(object2)) {
                    n = observableList.indexOf(object2);
                } else {
                    observableList.add(object2);
                    n = observableList.indexOf(object2);
                }
                this.currentIndex = n;
            });
            this.setValue(this._getValue(this.currentIndex));
        }

        public final void setItems(ObservableList<T> observableList) {
            this.itemsProperty().set(observableList);
        }

        public final ObservableList<T> getItems() {
            return this.items == null ? null : (ObservableList)this.items.get();
        }

        public final ObjectProperty<ObservableList<T>> itemsProperty() {
            if (this.items == null) {
                this.items = new SimpleObjectProperty<ObservableList<T>>(this, "items"){
                    WeakReference<ObservableList<T>> oldItemsRef;

                    @Override
                    protected void invalidated() {
                        ObservableList observableList = this.oldItemsRef == null ? null : (ObservableList)this.oldItemsRef.get();
                        ObservableList observableList2 = this.getItems();
                        if (observableList != null) {
                            observableList.removeListener(weakItemsContentObserver);
                        }
                        if (observableList2 != null) {
                            observableList2.addListener(weakItemsContentObserver);
                        }
                        this.updateCurrentIndex();
                        this.oldItemsRef = new WeakReference(this.getItems());
                    }
                };
            }
            return this.items;
        }

        @Override
        public void decrement(int n) {
            int n2 = this.getItemsSize() - 1;
            int n3 = this.currentIndex - n;
            this.currentIndex = n3 >= 0 ? n3 : (this.isWrapAround() ? Spinner.wrapValue(n3, 0, n2 + 1) : 0);
            this.setValue(this._getValue(this.currentIndex));
        }

        @Override
        public void increment(int n) {
            int n2 = this.currentIndex + n;
            int n3 = this.getItemsSize() - 1;
            this.currentIndex = n2 <= n3 ? n2 : (this.isWrapAround() ? Spinner.wrapValue(n2, 0, n3 + 1) : n3);
            this.setValue(this._getValue(this.currentIndex));
        }

        private int getItemsSize() {
            ObservableList<T> observableList = this.getItems();
            return observableList == null ? 0 : observableList.size();
        }

        private void updateCurrentIndex() {
            int n = this.getItemsSize();
            if (this.currentIndex < 0 || this.currentIndex >= n) {
                this.currentIndex = 0;
            }
            this.setValue(this._getValue(this.currentIndex));
        }

        private T _getValue(int n) {
            ObservableList<T> observableList = this.getItems();
            return observableList == null ? null : (n >= 0 && n < observableList.size() ? observableList.get(n) : null);
        }
    }
}

