/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http.fileupload;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.tomcat.util.http.fileupload.FileItemStream;
import org.apache.tomcat.util.http.fileupload.ProgressListener;
import org.apache.tomcat.util.http.fileupload.impl.FileUploadIOException;
import org.apache.tomcat.util.http.fileupload.util.Closeable;
import org.apache.tomcat.util.http.fileupload.util.Streams;

public class MultipartStream {
    public static final byte CR = 13;
    public static final byte LF = 10;
    public static final byte DASH = 45;
    public static final int HEADER_PART_SIZE_MAX = 10240;
    protected static final int DEFAULT_BUFSIZE = 4096;
    protected static final byte[] HEADER_SEPARATOR = new byte[]{13, 10, 13, 10};
    protected static final byte[] FIELD_SEPARATOR = new byte[]{13, 10};
    protected static final byte[] STREAM_TERMINATOR = new byte[]{45, 45};
    protected static final byte[] BOUNDARY_PREFIX = new byte[]{13, 10, 45, 45};
    private final InputStream input;
    private int boundaryLength;
    private final int keepRegion;
    private final byte[] boundary;
    private final int[] boundaryTable;
    private final int bufSize;
    private final byte[] buffer;
    private int head;
    private int tail;
    private String headerEncoding;
    private final ProgressNotifier notifier;

    public MultipartStream(InputStream inputStream, byte[] byArray, int n, ProgressNotifier progressNotifier) {
        if (byArray == null) {
            throw new IllegalArgumentException("boundary may not be null");
        }
        this.boundaryLength = byArray.length + BOUNDARY_PREFIX.length;
        if (n < this.boundaryLength + 1) {
            throw new IllegalArgumentException("The buffer size specified for the MultipartStream is too small");
        }
        this.input = inputStream;
        this.bufSize = Math.max(n, this.boundaryLength * 2);
        this.buffer = new byte[this.bufSize];
        this.notifier = progressNotifier;
        this.boundary = new byte[this.boundaryLength];
        this.boundaryTable = new int[this.boundaryLength + 1];
        this.keepRegion = this.boundary.length;
        System.arraycopy(BOUNDARY_PREFIX, 0, this.boundary, 0, BOUNDARY_PREFIX.length);
        System.arraycopy(byArray, 0, this.boundary, BOUNDARY_PREFIX.length, byArray.length);
        this.computeBoundaryTable();
        this.head = 0;
        this.tail = 0;
    }

    public MultipartStream(InputStream inputStream, byte[] byArray, ProgressNotifier progressNotifier) {
        this(inputStream, byArray, 4096, progressNotifier);
    }

    public String getHeaderEncoding() {
        return this.headerEncoding;
    }

    public void setHeaderEncoding(String string) {
        this.headerEncoding = string;
    }

    public byte readByte() throws IOException {
        if (this.head == this.tail) {
            this.head = 0;
            this.tail = this.input.read(this.buffer, this.head, this.bufSize);
            if (this.tail == -1) {
                throw new IOException("No more data is available");
            }
            if (this.notifier != null) {
                this.notifier.noteBytesRead(this.tail);
            }
        }
        return this.buffer[this.head++];
    }

    public boolean readBoundary() throws FileUploadIOException, MalformedStreamException {
        boolean bl;
        block6: {
            byte[] byArray = new byte[2];
            this.head += this.boundaryLength;
            try {
                byArray[0] = this.readByte();
                if (byArray[0] == 10) {
                    return true;
                }
                byArray[1] = this.readByte();
                if (MultipartStream.arrayequals(byArray, STREAM_TERMINATOR, 2)) {
                    bl = false;
                    break block6;
                }
                if (MultipartStream.arrayequals(byArray, FIELD_SEPARATOR, 2)) {
                    bl = true;
                    break block6;
                }
                throw new MalformedStreamException("Unexpected characters follow a boundary");
            }
            catch (FileUploadIOException fileUploadIOException) {
                throw fileUploadIOException;
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
        }
        return bl;
    }

    public void setBoundary(byte[] byArray) throws IllegalBoundaryException {
        if (byArray.length != this.boundaryLength - BOUNDARY_PREFIX.length) {
            throw new IllegalBoundaryException("The length of a boundary token cannot be changed");
        }
        System.arraycopy(byArray, 0, this.boundary, BOUNDARY_PREFIX.length, byArray.length);
        this.computeBoundaryTable();
    }

    private void computeBoundaryTable() {
        int n = 2;
        int n2 = 0;
        this.boundaryTable[0] = -1;
        this.boundaryTable[1] = 0;
        while (n <= this.boundaryLength) {
            if (this.boundary[n - 1] == this.boundary[n2]) {
                this.boundaryTable[n] = n2 + 1;
                ++n2;
                ++n;
                continue;
            }
            if (n2 > 0) {
                n2 = this.boundaryTable[n2];
                continue;
            }
            this.boundaryTable[n] = 0;
            ++n;
        }
    }

    public String readHeaders() throws FileUploadIOException, MalformedStreamException {
        String string;
        int n = 0;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n < HEADER_SEPARATOR.length) {
            byte by;
            try {
                by = this.readByte();
            }
            catch (FileUploadIOException fileUploadIOException) {
                throw fileUploadIOException;
            }
            catch (IOException iOException) {
                throw new MalformedStreamException("Stream ended unexpectedly");
            }
            if (++n2 > 10240) {
                throw new MalformedStreamException(String.format("Header section has more than %s bytes (maybe it is not properly terminated)", 10240));
            }
            n = by == HEADER_SEPARATOR[n] ? ++n : 0;
            byteArrayOutputStream.write(by);
        }
        if (this.headerEncoding != null) {
            try {
                string = byteArrayOutputStream.toString(this.headerEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = byteArrayOutputStream.toString();
            }
        } else {
            string = byteArrayOutputStream.toString();
        }
        return string;
    }

    public int readBodyData(OutputStream outputStream) throws MalformedStreamException, IOException {
        return (int)Streams.copy(this.newInputStream(), outputStream, false);
    }

    public ItemInputStream newInputStream() {
        return new ItemInputStream();
    }

    public int discardBodyData() throws MalformedStreamException, IOException {
        return this.readBodyData(null);
    }

    public boolean skipPreamble() throws IOException {
        System.arraycopy(this.boundary, 2, this.boundary, 0, this.boundary.length - 2);
        this.boundaryLength = this.boundary.length - 2;
        this.computeBoundaryTable();
        try {
            this.discardBodyData();
            boolean bl = this.readBoundary();
            return bl;
        }
        catch (MalformedStreamException malformedStreamException) {
            boolean bl = false;
            return bl;
        }
        finally {
            System.arraycopy(this.boundary, 0, this.boundary, 2, this.boundary.length - 2);
            this.boundaryLength = this.boundary.length;
            this.boundary[0] = 13;
            this.boundary[1] = 10;
            this.computeBoundaryTable();
        }
    }

    public static boolean arrayequals(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    protected int findSeparator() {
        int n = 0;
        for (int i = this.head; i < this.tail; ++i) {
            while (n >= 0 && this.buffer[i] != this.boundary[n]) {
                n = this.boundaryTable[n];
            }
            if (++n != this.boundaryLength) continue;
            return i - this.boundaryLength;
        }
        return -1;
    }

    public class ItemInputStream
    extends InputStream
    implements Closeable {
        private long total;
        private int pad;
        private int pos;
        private boolean closed;
        private static final int BYTE_POSITIVE_OFFSET = 256;

        ItemInputStream() {
            this.findSeparator();
        }

        private void findSeparator() {
            this.pos = MultipartStream.this.findSeparator();
            if (this.pos == -1) {
                this.pad = MultipartStream.this.tail - MultipartStream.this.head > MultipartStream.this.keepRegion ? MultipartStream.this.keepRegion : MultipartStream.this.tail - MultipartStream.this.head;
            }
        }

        public long getBytesRead() {
            return this.total;
        }

        @Override
        public int available() throws IOException {
            if (this.pos == -1) {
                return MultipartStream.this.tail - MultipartStream.this.head - this.pad;
            }
            return this.pos - MultipartStream.this.head;
        }

        @Override
        public int read() throws IOException {
            if (this.closed) {
                throw new FileItemStream.ItemSkippedException();
            }
            if (this.available() == 0 && this.makeAvailable() == 0) {
                return -1;
            }
            ++this.total;
            byte by = MultipartStream.this.buffer[MultipartStream.this.head++];
            if (by >= 0) {
                return by;
            }
            return by + 256;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.closed) {
                throw new FileItemStream.ItemSkippedException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.available();
            if (n3 == 0 && (n3 = this.makeAvailable()) == 0) {
                return -1;
            }
            n3 = Math.min(n3, n2);
            System.arraycopy(MultipartStream.this.buffer, MultipartStream.this.head, byArray, n, n3);
            MultipartStream.this.head += n3;
            this.total += (long)n3;
            return n3;
        }

        @Override
        public void close() throws IOException {
            this.close(false);
        }

        public void close(boolean bl) throws IOException {
            if (this.closed) {
                return;
            }
            if (bl) {
                this.closed = true;
                MultipartStream.this.input.close();
            } else {
                int n;
                while ((n = this.available()) != 0 || (n = this.makeAvailable()) != 0) {
                    this.skip(n);
                }
            }
            this.closed = true;
        }

        @Override
        public long skip(long l) throws IOException {
            if (this.closed) {
                throw new FileItemStream.ItemSkippedException();
            }
            int n = this.available();
            if (n == 0 && (n = this.makeAvailable()) == 0) {
                return 0L;
            }
            long l2 = Math.min((long)n, l);
            MultipartStream.this.head = (int)((long)MultipartStream.this.head + l2);
            return l2;
        }

        private int makeAvailable() throws IOException {
            int n;
            if (this.pos != -1) {
                return 0;
            }
            this.total += (long)(MultipartStream.this.tail - MultipartStream.this.head - this.pad);
            System.arraycopy(MultipartStream.this.buffer, MultipartStream.this.tail - this.pad, MultipartStream.this.buffer, 0, this.pad);
            MultipartStream.this.head = 0;
            MultipartStream.this.tail = this.pad;
            do {
                int n2;
                if ((n2 = MultipartStream.this.input.read(MultipartStream.this.buffer, MultipartStream.this.tail, MultipartStream.this.bufSize - MultipartStream.this.tail)) == -1) {
                    throw new MalformedStreamException("Stream ended unexpectedly");
                }
                if (MultipartStream.this.notifier != null) {
                    MultipartStream.this.notifier.noteBytesRead(n2);
                }
                MultipartStream.this.tail += n2;
                this.findSeparator();
            } while ((n = this.available()) <= 0 && this.pos == -1);
            return n;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }
    }

    public static class IllegalBoundaryException
    extends IOException {
        private static final long serialVersionUID = -161533165102632918L;

        public IllegalBoundaryException() {
        }

        public IllegalBoundaryException(String string) {
            super(string);
        }
    }

    public static class MalformedStreamException
    extends IOException {
        private static final long serialVersionUID = 6466926458059796677L;

        public MalformedStreamException() {
        }

        public MalformedStreamException(String string) {
            super(string);
        }
    }

    public static class ProgressNotifier {
        private final ProgressListener listener;
        private final long contentLength;
        private long bytesRead;
        private int items;

        public ProgressNotifier(ProgressListener progressListener, long l) {
            this.listener = progressListener;
            this.contentLength = l;
        }

        void noteBytesRead(int n) {
            this.bytesRead += (long)n;
            this.notifyListener();
        }

        public void noteItem() {
            ++this.items;
            this.notifyListener();
        }

        private void notifyListener() {
            if (this.listener != null) {
                this.listener.update(this.bytesRead, this.contentLength, this.items);
            }
        }
    }
}

