/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSource;
import org.apache.tomcat.dbcp.dbcp2.datasources.InstanceKeyDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.KeyedCPDSConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.SharedPoolDataSourceFactory;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericKeyedObjectPoolConfig;

public class SharedPoolDataSource
extends InstanceKeyDataSource {
    private static final long serialVersionUID = -1458539734480586454L;
    private int maxTotal = -1;
    private transient KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool;
    private transient KeyedCPDSConnectionFactory factory;

    @Override
    public void close() throws SQLException {
        if (this.pool != null) {
            this.pool.close();
        }
        InstanceKeyDataSourceFactory.removeInstance(this.getInstanceKey());
    }

    @Override
    protected PooledConnectionManager getConnectionManager(UserPassKey userPassKey) {
        return this.factory;
    }

    public int getMaxTotal() {
        return this.maxTotal;
    }

    public int getNumActive() {
        return this.pool == null ? 0 : this.pool.getNumActive();
    }

    public int getNumIdle() {
        return this.pool == null ? 0 : this.pool.getNumIdle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PooledConnectionAndInfo getPooledConnectionAndInfo(String string, String string2) throws SQLException {
        SharedPoolDataSource sharedPoolDataSource = this;
        synchronized (sharedPoolDataSource) {
            if (this.pool == null) {
                try {
                    this.registerPool(string, string2);
                }
                catch (NamingException namingException) {
                    throw new SQLException("registerPool failed", namingException);
                }
            }
        }
        try {
            return this.pool.borrowObject(new UserPassKey(string, string2));
        }
        catch (Exception exception) {
            throw new SQLException("Could not retrieve connection info from pool", exception);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        Reference reference = new Reference(this.getClass().getName(), SharedPoolDataSourceFactory.class.getName(), null);
        reference.add(new StringRefAddr("instanceKey", this.getInstanceKey()));
        return reference;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.pool = this.readObjectImpl();
    }

    private KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> readObjectImpl() throws IOException, ClassNotFoundException {
        try {
            return ((SharedPoolDataSource)new SharedPoolDataSourceFactory().getObjectInstance((Object)this.getReference(), null, null, null)).pool;
        }
        catch (NamingException namingException) {
            throw new IOException("NamingException: " + String.valueOf(namingException));
        }
    }

    private void registerPool(String string, String string2) throws NamingException, SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = this.testCPDS(string, string2);
        this.factory = new KeyedCPDSConnectionFactory(connectionPoolDataSource, this.getValidationQuery(), this.getValidationQueryTimeoutDuration(), this.isRollbackAfterValidation());
        this.factory.setMaxConn(this.getMaxConnDuration());
        GenericKeyedObjectPoolConfig genericKeyedObjectPoolConfig = new GenericKeyedObjectPoolConfig();
        genericKeyedObjectPoolConfig.setBlockWhenExhausted(this.getDefaultBlockWhenExhausted());
        genericKeyedObjectPoolConfig.setEvictionPolicyClassName(this.getDefaultEvictionPolicyClassName());
        genericKeyedObjectPoolConfig.setLifo(this.getDefaultLifo());
        genericKeyedObjectPoolConfig.setMaxIdlePerKey(this.getDefaultMaxIdle());
        genericKeyedObjectPoolConfig.setMaxTotal(this.getMaxTotal());
        genericKeyedObjectPoolConfig.setMaxTotalPerKey(this.getDefaultMaxTotal());
        genericKeyedObjectPoolConfig.setMaxWait(this.getDefaultMaxWait());
        genericKeyedObjectPoolConfig.setMinEvictableIdleDuration(this.getDefaultMinEvictableIdleDuration());
        genericKeyedObjectPoolConfig.setMinIdlePerKey(this.getDefaultMinIdle());
        genericKeyedObjectPoolConfig.setNumTestsPerEvictionRun(this.getDefaultNumTestsPerEvictionRun());
        genericKeyedObjectPoolConfig.setSoftMinEvictableIdleDuration(this.getDefaultSoftMinEvictableIdleDuration());
        genericKeyedObjectPoolConfig.setTestOnCreate(this.getDefaultTestOnCreate());
        genericKeyedObjectPoolConfig.setTestOnBorrow(this.getDefaultTestOnBorrow());
        genericKeyedObjectPoolConfig.setTestOnReturn(this.getDefaultTestOnReturn());
        genericKeyedObjectPoolConfig.setTestWhileIdle(this.getDefaultTestWhileIdle());
        genericKeyedObjectPoolConfig.setTimeBetweenEvictionRuns(this.getDefaultDurationBetweenEvictionRuns());
        GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo> genericKeyedObjectPool = new GenericKeyedObjectPool<UserPassKey, PooledConnectionAndInfo>(this.factory, genericKeyedObjectPoolConfig);
        this.factory.setPool(genericKeyedObjectPool);
        this.pool = genericKeyedObjectPool;
    }

    public void setMaxTotal(int n) {
        this.assertInitializationAllowed();
        this.maxTotal = n;
    }

    @Override
    protected void setupDefaults(Connection connection, String string) throws SQLException {
        Boolean bl;
        int n;
        Boolean bl2 = this.isDefaultAutoCommit();
        if (bl2 != null && connection.getAutoCommit() != bl2.booleanValue()) {
            connection.setAutoCommit(bl2);
        }
        if ((n = this.getDefaultTransactionIsolation()) != -1) {
            connection.setTransactionIsolation(n);
        }
        if ((bl = this.isDefaultReadOnly()) != null && connection.isReadOnly() != bl.booleanValue()) {
            connection.setReadOnly(bl);
        }
    }

    @Override
    protected void toStringFields(StringBuilder stringBuilder) {
        super.toStringFields(stringBuilder);
        stringBuilder.append(", maxTotal=");
        stringBuilder.append(this.maxTotal);
    }
}

