/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.TextureChoiceController;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class BaseboardChoiceController
implements Controller {
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private TextureChoiceController textureController;
    private final PropertyChangeSupport propertyChangeSupport;
    private View view;
    private Boolean visible;
    private Float thickness;
    private Float height;
    private Float maxHeight;
    private Integer color;
    private BaseboardPaint paint;

    public BaseboardChoiceController(UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
    }

    public TextureChoiceController getTextureController() {
        if (this.textureController == null) {
            this.textureController = new TextureChoiceController(this.preferences.getLocalizedString(BaseboardChoiceController.class, "baseboardTextureTitle", new Object[0]), this.preferences, this.viewFactory, this.contentManager);
            this.textureController.addPropertyChangeListener(TextureChoiceController.Property.TEXTURE, new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    BaseboardChoiceController.this.setPaint(BaseboardPaint.TEXTURED);
                }
            });
        }
        return this.textureController;
    }

    @Override
    public View getView() {
        if (this.view == null) {
            this.view = this.viewFactory.createBaseboardChoiceView(this.preferences, this);
        }
        return this.view;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    public Boolean getVisible() {
        return this.visible;
    }

    public void setVisible(Boolean bl) {
        if (bl != this.visible) {
            Boolean bl2 = this.visible;
            this.visible = bl;
            this.propertyChangeSupport.firePropertyChange(Property.VISIBLE.name(), bl2, bl);
        }
    }

    public void setThickness(Float f) {
        if (f != this.thickness) {
            Float f2 = this.thickness;
            this.thickness = f;
            this.propertyChangeSupport.firePropertyChange(Property.THICKNESS.name(), f2, f);
        }
    }

    public Float getThickness() {
        return this.thickness;
    }

    public void setHeight(Float f) {
        if (f != this.height) {
            Float f2 = this.height;
            this.height = f;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f2, f);
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public void setMaxHeight(Float f) {
        if (this.maxHeight == null || f != this.maxHeight) {
            Float f2 = this.maxHeight;
            this.maxHeight = f;
            this.propertyChangeSupport.firePropertyChange(Property.MAX_HEIGHT.name(), f2, f);
        }
    }

    public Float getMaxHeight() {
        return this.maxHeight;
    }

    public void setColor(Integer n) {
        if (n != this.color) {
            Integer n2 = this.color;
            this.color = n;
            this.propertyChangeSupport.firePropertyChange(Property.COLOR.name(), n2, n);
            this.setPaint(BaseboardPaint.COLORED);
        }
    }

    public Integer getColor() {
        return this.color;
    }

    public void setPaint(BaseboardPaint baseboardPaint) {
        if (baseboardPaint != this.paint) {
            BaseboardPaint baseboardPaint2 = this.paint;
            this.paint = baseboardPaint;
            this.propertyChangeSupport.firePropertyChange(Property.PAINT.name(), (Object)baseboardPaint2, (Object)baseboardPaint);
        }
    }

    public BaseboardPaint getPaint() {
        return this.paint;
    }

    public void setBaseboard(Baseboard baseboard) {
        if (baseboard == null) {
            this.setVisible(false);
            this.setThickness(null);
            this.setHeight(null);
            this.setColor(null);
            this.getTextureController().setTexture(null);
            this.setPaint(null);
        } else {
            this.setVisible(true);
            this.setThickness(Float.valueOf(baseboard.getThickness()));
            this.setHeight(Float.valueOf(baseboard.getHeight()));
            if (baseboard.getTexture() != null) {
                this.setColor(null);
                this.getTextureController().setTexture(baseboard.getTexture());
                this.setPaint(BaseboardPaint.TEXTURED);
            } else if (baseboard.getColor() != null) {
                this.getTextureController().setTexture(null);
                this.setColor(baseboard.getColor());
            } else {
                this.setColor(null);
                this.getTextureController().setTexture(null);
                this.setPaint(BaseboardPaint.DEFAULT);
            }
        }
    }

    public static enum Property {
        VISIBLE,
        COLOR,
        PAINT,
        HEIGHT,
        MAX_HEIGHT,
        THICKNESS;

    }

    public static enum BaseboardPaint {
        DEFAULT,
        COLORED,
        TEXTURED;

    }
}

