/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomePrint;
import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.swing.InterruptedPrinterException;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.FurnitureView;
import com.eteks.sweethome3d.viewcontroller.HomeController;
import com.eteks.sweethome3d.viewcontroller.PlanView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class HomePrintableComponent
extends JComponent
implements Printable {
    private static final float HEADER_FOOTER_MARGIN = LengthUnit.centimeterToInch(0.2f) * 72.0f;
    private final Home home;
    private final HomeController controller;
    private final Font defaultFont;
    private final Font headerFooterFont;
    private int page;
    private int pageCount = -1;
    private Set<Integer> printablePages = new HashSet<Integer>();
    private int furniturePageCount;
    private int planPageCount;
    private Date printDate;
    private JLabel fixedHeaderLabel;
    private JLabel fixedFooterLabel;
    private JLabel fixedFirstPageHeaderLabel;
    private JLabel fixedFirstPageFooterLabel;

    public HomePrintableComponent(Home home, HomeController homeController, Font font) {
        this.home = home;
        this.controller = homeController;
        this.defaultFont = font;
        this.headerFooterFont = font.deriveFont(11.0f);
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(HomePrintableComponent.class.getName());
            this.fixedHeaderLabel = this.getFixedHeaderOrFooterLabel(resourceBundle, "fixedHeader");
            this.fixedFooterLabel = this.getFixedHeaderOrFooterLabel(resourceBundle, "fixedFooter");
            this.fixedFirstPageHeaderLabel = this.getFixedHeaderOrFooterLabel(resourceBundle, "fixedFirstPageHeader");
            if (this.fixedFirstPageHeaderLabel == null) {
                this.fixedFirstPageHeaderLabel = this.fixedHeaderLabel;
            }
            this.fixedFirstPageFooterLabel = this.getFixedHeaderOrFooterLabel(resourceBundle, "fixedFirstPageFooter");
            if (this.fixedFirstPageFooterLabel == null) {
                this.fixedFirstPageFooterLabel = this.fixedFooterLabel;
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    private JLabel getFixedHeaderOrFooterLabel(ResourceBundle resourceBundle, String string) {
        try {
            String string2 = "/" + HomePrintableComponent.class.getName().replace('.', '/') + ".properties";
            String string3 = HomePrintableComponent.class.getResource(string2).toString();
            string3 = string3.substring(0, string3.length() - string2.length());
            String string4 = String.format(resourceBundle.getString(string), string3);
            JLabel jLabel = new JLabel(string4, 0);
            jLabel.setFont(this.headerFooterFont);
            jLabel.setSize(jLabel.getPreferredSize());
            return jLabel;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        View view;
        Object object;
        JLabel jLabel;
        if (Thread.interrupted()) {
            throw new InterruptedPrinterException();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setFont(this.defaultFont);
        graphics2D.setColor(Color.WHITE);
        graphics2D.fill(new Rectangle2D.Double(0.0, 0.0, pageFormat.getWidth(), pageFormat.getHeight()));
        Paper paper = pageFormat.getPaper();
        try {
            String string = System.getProperty("com.eteks.sweethome3d.swing.fixedPrintMargin", null);
            if (string != null) {
                float f = LengthUnit.centimeterToInch(Float.parseFloat(string)) * 72.0f;
                Paper paper2 = pageFormat.getPaper();
                paper2.setImageableArea(f, f, paper.getWidth() - (double)(2.0f * f), paper.getHeight() - (double)(2.0f * f));
                pageFormat.setPaper(paper2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        int n2 = 1;
        HomePrint homePrint = this.home.getPrint();
        float f = (float)pageFormat.getImageableY();
        float f2 = (float)pageFormat.getImageableHeight();
        String string = null;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        String string2 = null;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.0f;
        JLabel jLabel2 = n == 0 ? this.fixedFirstPageHeaderLabel : this.fixedHeaderLabel;
        JLabel jLabel3 = jLabel = n == 0 ? this.fixedFirstPageFooterLabel : this.fixedFooterLabel;
        if (jLabel2 != null) {
            jLabel2.setSize((int)pageFormat.getImageableWidth(), jLabel2.getPreferredSize().height);
            f2 -= (float)jLabel2.getHeight() + HEADER_FOOTER_MARGIN;
            f += (float)jLabel2.getHeight() + HEADER_FOOTER_MARGIN;
            f5 = (float)pageFormat.getImageableX();
            f6 = (float)pageFormat.getImageableY();
        }
        if (jLabel != null) {
            jLabel.setSize((int)pageFormat.getImageableWidth(), jLabel.getPreferredSize().height);
            f2 -= (float)jLabel.getHeight() + HEADER_FOOTER_MARGIN;
            f9 = (float)pageFormat.getImageableX();
            f10 = (float)(pageFormat.getImageableY() + pageFormat.getImageableHeight()) - (float)jLabel.getHeight();
        }
        Rectangle rectangle = graphics2D.getClipBounds();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(this.headerFooterFont);
        AffineTransform affineTransform = graphics2D.getTransform();
        PlanView planView = this.controller.getPlanController().getView();
        final List<Level> list = homePrint != null ? homePrint.getPrintedLevels() : null;
        String string3 = "";
        if (this.home.getSelectedLevel() != null) {
            string3 = this.home.getSelectedLevel().getName();
        }
        String string4 = null;
        String string5 = null;
        if (homePrint != null || jLabel2 != null || jLabel != null) {
            if (homePrint != null) {
                float f11 = (float)(fontMetrics.getAscent() + fontMetrics.getDescent()) + HEADER_FOOTER_MARGIN;
                string4 = homePrint.getHeaderFormat();
                if (string4 != null) {
                    string = this.formatHeaderFooter(string4, pageFormat, homePrint, planView, n, string3);
                    if (string.length() > 0) {
                        f3 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string)) / 2.0f;
                        f4 = f + (float)fontMetrics.getAscent();
                        f += f11;
                        f2 -= f11;
                    } else {
                        string = null;
                    }
                }
                if ((string5 = homePrint.getFooterFormat()) != null) {
                    string2 = this.formatHeaderFooter(string5, pageFormat, homePrint, planView, n, string3);
                    if (string2.length() > 0) {
                        f7 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string2)) / 2.0f;
                        f8 = f + f2 - (float)fontMetrics.getDescent();
                        f2 -= f11;
                    } else {
                        string2 = null;
                    }
                }
            }
            object = pageFormat.getPaper();
            switch (pageFormat.getOrientation()) {
                case 1: {
                    ((Paper)object).setImageableArea(((Paper)object).getImageableX(), f, ((Paper)object).getImageableWidth(), f2);
                    break;
                }
                case 0: {
                    ((Paper)object).setImageableArea(((Paper)object).getWidth() - (double)(f2 + f), ((Paper)object).getImageableY(), f2, ((Paper)object).getImageableHeight());
                }
                case 2: {
                    ((Paper)object).setImageableArea(f, ((Paper)object).getImageableY(), f2, ((Paper)object).getImageableHeight());
                }
            }
            pageFormat.setPaper((Paper)object);
            if (rectangle == null) {
                graphics2D.clipRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            } else {
                graphics2D.clipRect(rectangle.x, (int)pageFormat.getImageableY(), rectangle.width, (int)pageFormat.getImageableHeight());
            }
        }
        if ((object = this.controller.getFurnitureController().getView()) != null && (homePrint == null || homePrint.isFurniturePrinted())) {
            FurnitureView.FurnitureFilter furnitureFilter;
            view = null;
            if (object instanceof FurnitureView && (homePrint == null || homePrint.isPlanPrinted() || homePrint.isView3DPrinted())) {
                final Level level = this.home.getSelectedLevel();
                view = (FurnitureView)object;
                furnitureFilter = view.getFurnitureFilter();
                view.setFurnitureFilter(new FurnitureView.FurnitureFilter(){
                    final /* synthetic */ HomePrintableComponent this$0;
                    {
                        this.this$0 = homePrintableComponent;
                    }

                    @Override
                    public boolean include(Home home, HomePieceOfFurniture homePieceOfFurniture) {
                        return !(furnitureFilter != null && !furnitureFilter.include(home, homePieceOfFurniture) || !(list == null ? homePieceOfFurniture.isAtLevel(level) : list.contains(homePieceOfFurniture.getLevel())) || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable());
                    }
                });
            } else {
                furnitureFilter = null;
            }
            n2 = ((Printable)object).print(graphics2D, pageFormat, n);
            if (view != null) {
                view.setFurnitureFilter(furnitureFilter);
            }
            if (n2 == 0) {
                if (!this.printablePages.contains(n)) {
                    this.printablePages.add(n);
                    ++this.furniturePageCount;
                }
                if (list != null) {
                    String string6 = string3 = list.size() == 1 ? list.get(0).getName() : "";
                    if (string4 != null && (string = this.formatHeaderFooter(string4, pageFormat, homePrint, planView, n, string3)).length() > 0) {
                        f3 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string)) / 2.0f;
                    }
                    if (string5 != null && (string2 = this.formatHeaderFooter(string5, pageFormat, homePrint, planView, n, string3)).length() > 0) {
                        f7 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string2)) / 2.0f;
                    }
                }
            }
        }
        if (n2 == 1 && planView != null && (homePrint == null || homePrint.isPlanPrinted()) && (n2 = ((Printable)((Object)planView)).print(graphics2D, pageFormat, n - this.furniturePageCount)) == 0) {
            if (!this.printablePages.contains(n)) {
                this.printablePages.add(n);
                ++this.planPageCount;
            }
            if (list != null) {
                String string7 = this.home.getPrint().getPlanScale() == null ? list.get(n - this.furniturePageCount).getName() : (string3 = list.size() == 1 ? list.get(0).getName() : "");
                if (string4 != null && (string = this.formatHeaderFooter(string4, pageFormat, homePrint, planView, n, string3)).length() > 0) {
                    f3 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string)) / 2.0f;
                }
                if (string5 != null && (string2 = this.formatHeaderFooter(string5, pageFormat, homePrint, planView, n, string3)).length() > 0) {
                    f7 = ((float)pageFormat.getWidth() - (float)fontMetrics.stringWidth(string2)) / 2.0f;
                }
            }
        }
        view = this.controller.getHomeController3D().getView();
        if (n2 == 1 && view != null && (homePrint == null || homePrint.isView3DPrinted()) && (n2 = ((Printable)((Object)view)).print(graphics2D, pageFormat, n - this.planPageCount - this.furniturePageCount)) == 0 && !this.printablePages.contains(n)) {
            this.printablePages.add(n);
        }
        if (n2 == 0) {
            graphics2D.setTransform(affineTransform);
            graphics2D.setClip(rectangle);
            graphics2D.setFont(this.headerFooterFont);
            graphics2D.setColor(Color.BLACK);
            if (jLabel2 != null) {
                graphics2D.translate(f5, f6);
                jLabel2.print(graphics2D);
                graphics2D.translate(-f5, -f6);
            }
            if (string != null) {
                graphics2D.drawString(string, f3, f4);
            }
            if (string2 != null) {
                graphics2D.drawString(string2, f7, f8);
            }
            if (jLabel != null) {
                graphics2D.translate(f9, f10);
                jLabel.print(graphics2D);
                graphics2D.translate(-f9, -f10);
            }
        }
        pageFormat.setPaper(paper);
        return n2;
    }

    @Override
    public Dimension getPreferredSize() {
        PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
        double d = Math.max(pageFormat.getWidth(), pageFormat.getHeight());
        Insets insets = this.getInsets();
        int n = Math.round(400.0f * SwingTools.getResolutionScale());
        return new Dimension((int)(pageFormat.getWidth() / d * (double)n) + insets.left + insets.right, (int)(pageFormat.getHeight() / d * (double)n) + insets.top + insets.bottom);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
            Insets insets = this.getInsets();
            double d = (double)(this.getWidth() - insets.left - insets.right) / pageFormat.getWidth();
            graphics2D.scale(d, d);
            this.print(graphics2D, pageFormat, this.page);
            graphics2D.dispose();
        }
        catch (PrinterException printerException) {
            throw new RuntimeException(printerException);
        }
    }

    private String formatHeaderFooter(String string, PageFormat pageFormat, HomePrint homePrint, PlanView planView, int n, String string2) {
        String string3;
        int n2 = n + 1;
        int n3 = this.getPageCount();
        String string4 = "?";
        if (homePrint.getPlanScale() != null) {
            string4 = "1/" + Math.round(1.0f / homePrint.getPlanScale().floatValue());
        } else {
            float f = planView.getPrintPreferredScale(LengthUnit.inchToCentimeter((float)pageFormat.getImageableWidth() / 72.0f), LengthUnit.inchToCentimeter((float)pageFormat.getImageableHeight() / 72.0f));
            string4 = "1/" + Math.round(1.0f / f);
        }
        if (n == 0) {
            this.printDate = new Date();
        }
        if ((string3 = this.home.getName()) == null) {
            string3 = "";
        }
        String string5 = this.controller.getContentManager().getPresentationName(string3, ContentManager.ContentType.SWEET_HOME_3D);
        Object[] objectArray = new Object[]{n2, n3, string4, this.printDate, string5, string3, string2};
        return Variable.getMessageFormat(string).format(objectArray).trim();
    }

    public void setPage(int n) {
        if (this.page != n) {
            this.page = n;
            this.repaint();
        }
    }

    public int getPage() {
        return this.page;
    }

    public int getPageCount() {
        if (this.pageCount == -1) {
            PageFormat pageFormat = HomePrintableComponent.getPageFormat(this.home.getPrint());
            BufferedImage bufferedImage = new BufferedImage(1, 1, 1);
            Graphics graphics = bufferedImage.getGraphics();
            this.pageCount = 0;
            try {
                while (this.print(graphics, pageFormat, this.pageCount) == 0) {
                    ++this.pageCount;
                }
            }
            catch (PrinterException printerException) {
                throw new RuntimeException(printerException);
            }
            graphics.dispose();
        }
        return this.pageCount;
    }

    public static PageFormat getPageFormat(HomePrint homePrint) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (homePrint == null) {
            return printerJob.defaultPage();
        }
        PageFormat pageFormat = new PageFormat();
        switch (homePrint.getPaperOrientation()) {
            case PORTRAIT: {
                pageFormat.setOrientation(1);
                break;
            }
            case LANDSCAPE: {
                pageFormat.setOrientation(0);
                break;
            }
            case REVERSE_LANDSCAPE: {
                pageFormat.setOrientation(2);
            }
        }
        Paper paper = new Paper();
        paper.setSize(homePrint.getPaperWidth(), homePrint.getPaperHeight());
        paper.setImageableArea(homePrint.getPaperLeftMargin(), homePrint.getPaperTopMargin(), homePrint.getPaperWidth() - homePrint.getPaperLeftMargin() - homePrint.getPaperRightMargin(), homePrint.getPaperHeight() - homePrint.getPaperTopMargin() - homePrint.getPaperBottomMargin());
        pageFormat.setPaper(paper);
        pageFormat = printerJob.validatePage(pageFormat);
        return pageFormat;
    }

    public static enum Variable {
        PAGE_NUMBER("$pageNumber", "{0, number, integer}"),
        PAGE_COUNT("$pageCount", "{1, number, integer}"),
        PLAN_SCALE("$planScale", "{2}"),
        DATE("$date", "{3, date}"),
        TIME("$time", "{3, time}"),
        HOME_PRESENTATION_NAME("$name", "{4}"),
        HOME_NAME("$file", "{5}"),
        LEVEL_NAME("$level", "{6}");

        private final String userCode;
        private final String formatCode;

        private Variable(String string2, String string3) {
            this.userCode = string2;
            this.formatCode = string3;
        }

        public String getUserCode() {
            return this.userCode;
        }

        public String getFormatCode() {
            return this.formatCode;
        }

        public static MessageFormat getMessageFormat(String string) {
            string = string.replace("$$", "|#&%<>/!");
            string = string.replace("'", "''");
            string = string.replace("{", "'{'");
            for (Variable variable : Variable.values()) {
                string = string.replace(variable.getUserCode(), variable.getFormatCode());
            }
            string = string.replace("|#&%<>/!", "$");
            return new MessageFormat(string);
        }
    }
}

