/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkBinaryMorphologicalClosingImageFilter_h
#define sitkBinaryMorphologicalClosingImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class BinaryMorphologicalClosingImageFilter
\brief binary morphological closing of an image.

This filter removes small (i.e., smaller than the structuring element) holes and tube like structures in the interior or at the boundaries of the image. The morphological closing of an image "f" is defined as: Closing(f) = Erosion(Dilation(f)).

The structuring element is assumed to be composed of binary values (zero or one). Only elements of the structuring element having values > 0 are candidates for affecting the center pixel.

This code was contributed in the Insight Journal paper: "Binary morphological closing and opening image filters" by Lehmann G. https://doi.org/10.54294/bcwtvq 

\author Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA de Jouy-en-Josas, France.


\see MorphologyImageFilter , GrayscaleDilateImageFilter , GrayscaleErodeImageFilter
\sa itk::simple::BinaryMorphologicalClosing for the procedural interface
\sa itk::BinaryMorphologicalClosingImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT BinaryMorphologicalClosingImageFilter : public ImageFilter {
    public:
      using Self = BinaryMorphologicalClosingImageFilter;

      /** Destructor */
      virtual ~BinaryMorphologicalClosingImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      BinaryMorphologicalClosingImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = IntegerPixelIDTypeList;
\

      /**
       * Set the radius of the kernel structuring element.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius ( std::vector<unsigned int> KernelRadius ) { this->m_KernelRadius = std::move(KernelRadius); return *this; }

      /** Set the values of the KernelRadius vector all to value */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelRadius( unsigned int value ) { this->m_KernelRadius = std::vector<unsigned int>(3, value); return *this; }

      /**
       * Get the radius of the kernel structuring element.
       */
      std::vector<unsigned int> GetKernelRadius() const { return this->m_KernelRadius; }\

      /**
       * Set the kernel or structuring element used for the morphology.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetKernelType ( KernelEnum KernelType ) { this->m_KernelType = KernelType; return *this; }

      /**
       * Get the kernel or structuring element used for the morphology.
       */
      KernelEnum GetKernelType() const { return this->m_KernelType; }\

      /**
       * Set the value in the image to consider as "foreground". Defaults to maximum value of InputPixelType.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetForegroundValue ( double ForegroundValue ) { this->m_ForegroundValue = ForegroundValue; return *this; }

      /**
       * Get the value in the image considered as "foreground". Defaults to maximum value of InputPixelType.
       */
      double GetForegroundValue() const { return this->m_ForegroundValue; }\

      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
      SITK_RETURN_SELF_TYPE_HEADER SetSafeBorder ( bool SafeBorder ) { this->m_SafeBorder = SafeBorder; return *this; }

      /** Set the value of SafeBorder to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOn() { return this->SetSafeBorder(true); }
      SITK_RETURN_SELF_TYPE_HEADER SafeBorderOff() { return this->SetSafeBorder(false); }

      /**
       * A safe border is added to input image to avoid borders effects and remove it once the closing is done
       */
      bool GetSafeBorder() const { return this->m_SafeBorder; }

      /** Name of this class */
      std::string GetName() const { return std::string ("BinaryMorphologicalClosingImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      /*  */
      std::vector<unsigned int>  m_KernelRadius{std::vector<uint32_t>(3, 1)};

      KernelEnum  m_KernelType{itk::simple::sitkBall};

      double  m_ForegroundValue{1.0};

      /*  */
      bool  m_SafeBorder{true};


    };

    /**\
     * \brief binary morphological closing of an image.
     *
     * This function directly calls the execute method of BinaryMorphologicalClosingImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::BinaryMorphologicalClosingImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image BinaryMorphologicalClosing ( const Image& image1, std::vector<unsigned int> kernelRadius = std::vector<uint32_t>(3, 1), KernelEnum kernelType = itk::simple::sitkBall, double foregroundValue = 1.0, bool safeBorder = true );

     /** @} */
}
#endif
