\name{BinaryMedianImageFilter}
\alias{BinaryMedianImageFilter}
\title{BinaryMedianImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
Applies a version of the median filter optimized for binary images.
BinaryMedianImageFilter}
\details{
This filter was contributed by Bjorn Hanch Sollie after identifying
that the generic Median filter performed unnecessary operations when
the input image is binary.
This filter computes an image where a given pixel is the median value
of the pixels in a neighborhood about the corresponding input pixel.
For the case of binary images the median can be obtained by simply
counting the neighbors that are foreground.
A median filter is one of the family of nonlinear filters. It is used
to smooth an image without being biased by outliers or shot noise.
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
BinaryMedian for the procedural interface
itk::BinaryMedianImageFilter for the Doxygen on the original ITK class.
BinaryMedianImageFilter}
%C++ includes: sitkBinaryMedianImageFilter.h
\section{Methods}{
\describe{
\item{ BinaryMedianImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{double GetBackgroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{double GetForegroundValue() const:}{
Get the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{std::string GetName() const:}{
Name of this class
}
\item{std::vector< unsigned int > GetRadius() const:}{
Get the radius of the neighborhood used to compute the median
}
\item{Self SetBackgroundValue(double BackgroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetForegroundValue(double ForegroundValue):}{
Set the value associated with the Foreground (or the object) on the
binary input image and the Background .
}
\item{Self SetRadius(std::vector< unsigned int > Radius):}{
Set the radius of the neighborhood used to compute the median.
}
\item{Self SetRadius(unsigned int value):}{
Set the values of the Radius vector all to value
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{ ~BinaryMedianImageFilter():}{
Destructor
}
}
}
