/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import org.scilab.forge.jlatexmath.Atom;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.HorizontalRule;
import org.scilab.forge.jlatexmath.InvalidUnitException;
import org.scilab.forge.jlatexmath.SpaceAtom;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.VerticalBox;

public class FractionAtom
extends Atom {
    private boolean noDefault = false;
    private int unit;
    private int numAlign = 2;
    private int denomAlign = 2;
    private Atom numerator;
    private Atom denominator;
    private float thickness;
    private float defFactor;
    private boolean defFactorSet = false;

    public FractionAtom(Atom num, Atom den) {
        this(num, den, true);
    }

    public FractionAtom(Atom num, Atom den, boolean rule) {
        this(num, den, !rule, 2, 0.0f);
    }

    public FractionAtom(Atom num, Atom den, boolean noDef, int unit, float t) throws InvalidUnitException {
        SpaceAtom.checkUnit(unit);
        this.numerator = num;
        this.denominator = den;
        this.noDefault = noDef;
        this.thickness = t;
        this.unit = unit;
        this.type = 7;
    }

    public FractionAtom(Atom num, Atom den, boolean rule, int numAlign, int denomAlign) {
        this(num, den, rule);
        this.numAlign = this.checkAlignment(numAlign);
        this.denomAlign = this.checkAlignment(denomAlign);
    }

    public FractionAtom(Atom num, Atom den, float defFactor, int numAlign, int denomAlign) {
        this(num, den, true, numAlign, denomAlign);
        this.defFactor = defFactor;
        this.defFactorSet = true;
    }

    public FractionAtom(Atom num, Atom den, int unit, float t, int numAlign, int denomAlign) {
        this(num, den, unit, t);
        this.numAlign = this.checkAlignment(numAlign);
        this.denomAlign = this.checkAlignment(denomAlign);
    }

    public FractionAtom(Atom num, Atom den, int unit, float t) {
        this(num, den, true, unit, t);
    }

    private int checkAlignment(int align) {
        if (align == 0 || align == 1) {
            return align;
        }
        return 2;
    }

    public Box createBox(TeXEnvironment env) {
        float shiftDown;
        float shiftUp;
        Box denom;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        float drt = tf.getDefaultRuleThickness(style);
        this.thickness = this.noDefault ? (this.thickness *= SpaceAtom.getFactor(this.unit, env)) : (this.defFactorSet ? this.defFactor * drt : drt);
        Box num = this.numerator == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.numerator.createBox(env.numStyle());
        Box box = denom = this.denominator == null ? new StrutBox(0.0f, 0.0f, 0.0f, 0.0f) : this.denominator.createBox(env.denomStyle());
        if (num.getWidth() < denom.getWidth()) {
            num = new HorizontalBox(num, denom.getWidth(), this.numAlign);
        } else {
            denom = new HorizontalBox(denom, num.getWidth(), this.denomAlign);
        }
        if (style < 2) {
            shiftUp = tf.getNum1(style);
            shiftDown = tf.getDenom1(style);
        } else {
            shiftDown = tf.getDenom2(style);
            shiftUp = this.thickness > 0.0f ? tf.getNum2(style) : tf.getNum3(style);
        }
        VerticalBox vBox = new VerticalBox();
        vBox.add(num);
        float axis = tf.getAxisHeight(style);
        if (this.thickness > 0.0f) {
            float clr = style < 2 ? 3.0f * this.thickness : this.thickness;
            float delta = this.thickness / 2.0f;
            float kern1 = shiftUp - num.getDepth() - (axis + delta);
            float kern2 = axis - delta - (denom.getHeight() - shiftDown);
            float delta1 = clr - kern1;
            float delta2 = clr - kern2;
            if (delta1 > 0.0f) {
                shiftUp += delta1;
                kern1 += delta1;
            }
            if (delta2 > 0.0f) {
                shiftDown += delta2;
                kern2 += delta2;
            }
            vBox.add(new StrutBox(0.0f, kern1, 0.0f, 0.0f));
            vBox.add(new HorizontalRule(this.thickness, num.getWidth(), 0.0f));
            vBox.add(new StrutBox(0.0f, kern2, 0.0f, 0.0f));
        } else {
            float kern;
            float clr = style < 2 ? 7.0f * drt : 3.0f * drt;
            float delta = (clr - (kern = shiftUp - num.getDepth() - (denom.getHeight() - shiftDown))) / 2.0f;
            if (delta > 0.0f) {
                shiftUp += delta;
                shiftDown += delta;
                kern += 2.0f * delta;
            }
            vBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
        }
        vBox.add(denom);
        vBox.setHeight(shiftUp + num.getHeight());
        vBox.setDepth(shiftDown + denom.getDepth());
        float f = new SpaceAtom(0, 0.12f, 0.0f, 0.0f).createBox(env).getWidth();
        return new HorizontalBox(vBox, vBox.getWidth() + 2.0f * f, 2);
    }
}

