<?php

namespace App\Classes\LDAP;

use Illuminate\Support\Facades\Auth;
use LdapRecord\Query\Collection;

/**
 * Export Class
 *
 * This abstract classes provides all the common methods and variables for the
 * export classes.
 */
abstract class Export
{
	// Line Break
	protected string $br = "\r\n";

	// Item(s) being Exported
	protected Collection $items;

	// Type of export
	protected const type = 'Unknown';

	public function __construct(Collection $items)
	{
		$this->items = $items;
	}

	abstract public function __toString(): string;

	protected function header(): string
	{
		$output = '';

		$output .= sprintf('# %s %s',__(static::type.' for'),($x=$this->items->first())).$this->br;
		$output .= sprintf('# %s: %s (%s)',
			__('Server'),
			$x->getConnection()->getConfiguration()->get('name'),
			$x->getConnection()->getLdapConnection()->getHost()).$this->br;
		//$output .= sprintf('# %s: %s',__('Search Scope'),$this->scope).$this->br;
		//$output .= sprintf('# %s: %s',__('Search Filter'),$this->entry->dn).$this->br;
		$output .= sprintf('# %s: %s',__('Total Entries'),$this->items->count()).$this->br;
		$output .= '#'.$this->br;
		$output .= sprintf('# %s %s (%s) on %s',__('Generated by'),config('app.name'),request()->root(),date('F j, Y g:i a')).$this->br;
		$output .= sprintf('# %s %s',__('Exported by'),Auth::user() ?: 'Anonymous').$this->br;
		$output .= sprintf('# %s: %s',__('Version'),config('app.version')).$this->br;

		$output .= $this->br;

		return $output;
	}
}