/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RuleResultMetadata {
    protected final Map<CountCategory, Integer> counts = new HashMap<CountCategory, Integer>();

    public RuleResultMetadata() {
    }

    public RuleResultMetadata(CountCategory category, int value) {
        this.putCount(category, value);
    }

    public boolean hasCount(CountCategory category) {
        return this.counts.containsKey((Object)category);
    }

    public int getCount(CountCategory category) {
        return this.counts.get((Object)category);
    }

    public Map<CountCategory, Integer> getCounts() {
        return Collections.unmodifiableMap(this.counts);
    }

    public void putCount(CountCategory category, int value) {
        if (value < 0) {
            throw new IllegalArgumentException("Count value must be greater than or equals to zero");
        }
        this.counts.put(category, value);
    }

    public void merge(RuleResultMetadata metadata) {
        this.counts.putAll(metadata.getCounts());
    }

    public String toString() {
        return String.format("counts=%s", this.counts);
    }

    public static enum CountCategory {
        Length,
        LowerCase,
        UpperCase,
        Digit,
        Special,
        Whitespace,
        Allowed,
        Illegal,
        Pwned;


        @Deprecated
        public static boolean exists(String name) {
            for (CountCategory cc : CountCategory.values()) {
                if (!cc.name().equals(name)) continue;
                return true;
            }
            return false;
        }
    }
}

