/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.http;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.common.Strings;
import org.opensearch.security.auth.HTTPAuthenticator;
import org.opensearch.security.filter.SecurityRequest;
import org.opensearch.security.filter.SecurityResponse;
import org.opensearch.security.support.WildcardMatcher;
import org.opensearch.security.user.AuthCredentials;

public class HTTPClientCertAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    public static final String OPENDISTRO_SECURITY_SSL_SKIP_USERS = "skip_users";
    protected final Settings settings;
    private final WildcardMatcher skipUsersMatcher;

    public HTTPClientCertAuthenticator(Settings settings, Path configPath) {
        this.settings = settings;
        this.skipUsersMatcher = WildcardMatcher.from(settings.getAsList(OPENDISTRO_SECURITY_SSL_SKIP_USERS));
    }

    @Override
    public AuthCredentials extractCredentials(SecurityRequest request, ThreadContext threadContext) {
        String principal = (String)threadContext.getTransient("_opendistro_security_ssl_principal");
        if (!Strings.isNullOrEmpty((String)principal)) {
            String usernameAttribute = this.settings.get("username_attribute");
            String rolesAttribute = this.settings.get("roles_attribute");
            if (this.skipUsersMatcher.test(principal)) {
                this.log.debug("Skipped user client cert  authentication of user {} as its in skip_users list ", (Object)principal);
                return null;
            }
            try {
                List<String> roles;
                List<String> usernames;
                LdapName rfc2253dn = new LdapName(principal);
                String username = principal.trim();
                String[] backendRoles = null;
                if (usernameAttribute != null && usernameAttribute.length() > 0 && !(usernames = this.getDnAttribute(rfc2253dn, usernameAttribute)).isEmpty()) {
                    username = usernames.get(0);
                }
                if (rolesAttribute != null && rolesAttribute.length() > 0 && !(roles = this.getDnAttribute(rfc2253dn, rolesAttribute)).isEmpty()) {
                    backendRoles = roles.toArray(new String[0]);
                }
                return new AuthCredentials(username, backendRoles).markComplete();
            }
            catch (InvalidNameException e) {
                this.log.error("Client cert had no properly formed DN (was: {})", (Object)principal);
                return null;
            }
        }
        this.log.trace("No CLIENT CERT, send 401");
        return null;
    }

    @Override
    public Optional<SecurityResponse> reRequestAuthentication(SecurityRequest response, AuthCredentials creds) {
        return Optional.empty();
    }

    @Override
    public String getType() {
        return "clientcert";
    }

    private List<String> getDnAttribute(LdapName rfc2253dn, String attribute) {
        ArrayList<String> attrValues = new ArrayList<String>(rfc2253dn.size());
        ArrayList<Rdn> reverseRdn = new ArrayList<Rdn>(rfc2253dn.getRdns());
        Collections.reverse(reverseRdn);
        for (Rdn rdn : reverseRdn) {
            if (!rdn.getType().equalsIgnoreCase(attribute)) continue;
            attrValues.add(rdn.getValue().toString());
        }
        return Collections.unmodifiableList(attrValues);
    }
}

