/*
 * Decompiled with CFR 0.152.
 */
package com.nulabinc.zxcvbn.io;

import com.nulabinc.zxcvbn.io.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public final class ClasspathResource
implements Resource {
    private final String path;

    public ClasspathResource(String path) {
        this.path = path;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        InputStream in = this.getResourceAsStreamWithFallback(this.path);
        if (in == null) {
            throw new FileNotFoundException("Could not get resource as stream");
        }
        return in;
    }

    private InputStream getResourceAsStreamWithFallback(String path) {
        ClassLoader cl2;
        InputStream in = this.getClass().getResourceAsStream(path);
        if (in != null) {
            return in;
        }
        try {
            cl2 = Thread.currentThread().getContextClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable cl2) {
            // empty catch block
        }
        try {
            cl2 = this.getClass().getClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable cl3) {
            // empty catch block
        }
        try {
            cl2 = ClassLoader.getSystemClassLoader();
            in = this.getResourceAsStream(cl2, path);
            if (in != null) {
                return in;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private InputStream getResourceAsStream(ClassLoader cl, String path) {
        try {
            InputStream in;
            if (cl != null && (in = cl.getResourceAsStream(path)) != null) {
                return in;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }
}

