/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals;

import java.util.Objects;
import org.opensearch.performanceanalyzer.commons.stats.eval.Statistics;
import org.opensearch.performanceanalyzer.commons.stats.eval.impl.vals.Value;
import org.opensearch.performanceanalyzer.commons.stats.format.Formatter;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;

public class AggregateValue
extends Value {
    private Statistics aggregationType;

    public AggregateValue(Number value, Statistics type) {
        super(value);
        this.aggregationType = type;
    }

    @Override
    public void format(Formatter formatter, MeasurementSet measurementSet, Statistics stats) {
        formatter.formatAggregatedValue(measurementSet, stats, this.value);
    }

    public Statistics getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AggregateValue that = (AggregateValue)o;
        return this.aggregationType == that.aggregationType;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.aggregationType});
    }

    @Override
    public String toString() {
        return "AggregateValue{aggregationType=" + String.valueOf((Object)this.aggregationType) + ", value=" + String.valueOf(this.value) + "}";
    }
}

