/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.util.Arrays;

public class WrappedByteArrayOutputStream
extends OutputStream {
    private byte[] buf;
    private int start;
    private int offset;
    private boolean copied = false;

    public void setBuffer(byte[] byArray) {
        this.setBuffer(byArray, 0);
    }

    public void setBuffer(byte[] byArray, int n) {
        this.buf = byArray;
        this.start = n;
        this.offset = n;
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        System.arraycopy(byArray, 0, this.buf, this.offset, byArray.length);
        this.offset += byArray.length;
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        System.arraycopy(byArray, n, this.buf, this.offset, n2);
        this.offset += n2;
    }

    @Override
    public void write(int n) throws IOException {
        this.buf[this.offset++] = 0;
    }

    public int size() {
        return this.offset - this.start;
    }

    public byte[] getBuffer() {
        return this.buf;
    }

    public void moveOffset(int n) {
        this.offset += n;
        if (this.offset < this.start || this.offset > this.buf.length) {
            throw new IllegalStateException("offset outside of buffer range");
        }
    }

    public byte[] toTrimmedByteArray() {
        if (this.size() != this.buf.length) {
            byte[] byArray = new byte[this.size()];
            System.arraycopy(this.buf, this.start, byArray, 0, byArray.length);
            this.copied = true;
            return byArray;
        }
        return this.buf;
    }

    public void erase() {
        if (this.copied) {
            Arrays.clear(this.buf);
            this.copied = false;
        }
    }

    public int getOffset() {
        return this.offset;
    }
}

