/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.dynamodb.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.dynamodb.model.VirtualPart;

public class VirtualField {
    private final String name;
    private final List<VirtualPart> parts;

    protected VirtualField(BuilderImpl builder) {
        this.name = builder.name();
        this.parts = builder.parts();
    }

    public String name() {
        return this.name;
    }

    public List<VirtualPart> parts() {
        return this.parts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected String name;
        protected List<VirtualPart> parts;

        protected BuilderImpl() {
        }

        protected BuilderImpl(VirtualField model) {
            this.name = model.name();
            this.parts = model.parts();
        }

        @Override
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Builder parts(List<VirtualPart> parts) {
            this.parts = parts;
            return this;
        }

        @Override
        public List<VirtualPart> parts() {
            return this.parts;
        }

        @Override
        public VirtualField build() {
            if (Objects.isNull(this.name())) {
                throw new IllegalArgumentException("Missing value for required field `name`");
            }
            if (Objects.isNull(this.parts())) {
                throw new IllegalArgumentException("Missing value for required field `parts`");
            }
            if (Objects.nonNull(this.parts()) && this.parts().size() < 1) {
                throw new IllegalArgumentException("The size of `parts` must be greater than or equal to 1");
            }
            return new VirtualField(this);
        }
    }

    public static interface Builder {
        public Builder name(String var1);

        public String name();

        public Builder parts(List<VirtualPart> var1);

        public List<VirtualPart> parts();

        public VirtualField build();
    }
}

