/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.nodes.stats;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.nodes.stats.CacheIndicesStats;
import org.opensearch.client.opensearch.nodes.stats.CacheShardStats;
import org.opensearch.client.opensearch.nodes.stats.CacheStatsBase;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class CacheStats
extends CacheStatsBase
implements ToCopyableBuilder<Builder, CacheStats> {
    @Nonnull
    private final Map<String, CacheIndicesStats> indices;
    @Nonnull
    private final Map<String, CacheShardStats> shards;
    @Nullable
    private final String storeName;
    public static final JsonpDeserializer<CacheStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CacheStats::setupCacheStatsDeserializer);

    private CacheStats(Builder builder) {
        super(builder);
        this.indices = ApiTypeHelper.unmodifiable(builder.indices);
        this.shards = ApiTypeHelper.unmodifiable(builder.shards);
        this.storeName = builder.storeName;
    }

    public static CacheStats of(Function<Builder, ObjectBuilder<CacheStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, CacheIndicesStats> indices() {
        return this.indices;
    }

    @Nonnull
    public final Map<String, CacheShardStats> shards() {
        return this.shards;
    }

    @Nullable
    public final String storeName() {
        return this.storeName;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartObject();
            for (Map.Entry<String, CacheIndicesStats> entry : this.indices.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.shards)) {
            generator.writeKey("shards");
            generator.writeStartObject();
            for (Map.Entry<String, CacheStatsBase> entry : this.shards.entrySet()) {
                generator.writeKey(entry.getKey());
                ((CacheShardStats)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.storeName != null) {
            generator.writeKey("store_name");
            generator.write(this.storeName);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupCacheStatsDeserializer(ObjectDeserializer<Builder> op) {
        CacheStats.setupCacheStatsBaseDeserializer(op);
        op.add(Builder::indices, JsonpDeserializer.stringMapDeserializer(CacheIndicesStats._DESERIALIZER), "indices");
        op.add(Builder::shards, JsonpDeserializer.stringMapDeserializer(CacheShardStats._DESERIALIZER), "shards");
        op.add(Builder::storeName, JsonpDeserializer.stringDeserializer(), "store_name");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.indices);
        result = 31 * result + Objects.hashCode(this.shards);
        result = 31 * result + Objects.hashCode(this.storeName);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheStats other = (CacheStats)o;
        return Objects.equals(this.indices, other.indices) && Objects.equals(this.shards, other.shards) && Objects.equals(this.storeName, other.storeName);
    }

    public static class Builder
    extends CacheStatsBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, CacheStats> {
        @Nullable
        private Map<String, CacheIndicesStats> indices;
        @Nullable
        private Map<String, CacheShardStats> shards;
        @Nullable
        private String storeName;

        public Builder() {
        }

        private Builder(CacheStats o) {
            super(o);
            this.indices = Builder._mapCopy(o.indices);
            this.shards = Builder._mapCopy(o.shards);
            this.storeName = o.storeName;
        }

        private Builder(Builder o) {
            super(o);
            this.indices = Builder._mapCopy(o.indices);
            this.shards = Builder._mapCopy(o.shards);
            this.storeName = o.storeName;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder indices(Map<String, CacheIndicesStats> map) {
            this.indices = Builder._mapPutAll(this.indices, map);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, CacheIndicesStats value) {
            this.indices = Builder._mapPut(this.indices, key, value);
            return this;
        }

        @Nonnull
        public final Builder indices(String key, Function<CacheIndicesStats.Builder, ObjectBuilder<CacheIndicesStats>> fn) {
            return this.indices(key, fn.apply(new CacheIndicesStats.Builder()).build());
        }

        @Nonnull
        public final Builder shards(Map<String, CacheShardStats> map) {
            this.shards = Builder._mapPutAll(this.shards, map);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, CacheShardStats value) {
            this.shards = Builder._mapPut(this.shards, key, value);
            return this;
        }

        @Nonnull
        public final Builder shards(String key, Function<CacheShardStats.Builder, ObjectBuilder<CacheShardStats>> fn) {
            return this.shards(key, fn.apply(new CacheShardStats.Builder()).build());
        }

        @Nonnull
        public final Builder storeName(@Nullable String value) {
            this.storeName = value;
            return this;
        }

        @Override
        @Nonnull
        public CacheStats build() {
            this._checkSingleUse();
            return new CacheStats(this);
        }
    }
}

