/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices.analyze;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.analyze.AnalyzerDetail;
import org.opensearch.client.opensearch.indices.analyze.CharFilterDetail;
import org.opensearch.client.opensearch.indices.analyze.TokenDetail;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class AnalyzeDetail
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, AnalyzeDetail> {
    @Nullable
    private final AnalyzerDetail analyzer;
    @Nonnull
    private final List<CharFilterDetail> charfilters;
    private final boolean customAnalyzer;
    @Nonnull
    private final List<TokenDetail> tokenfilters;
    @Nullable
    private final TokenDetail tokenizer;
    public static final JsonpDeserializer<AnalyzeDetail> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AnalyzeDetail::setupAnalyzeDetailDeserializer);

    private AnalyzeDetail(Builder builder) {
        this.analyzer = builder.analyzer;
        this.charfilters = ApiTypeHelper.unmodifiable(builder.charfilters);
        this.customAnalyzer = ApiTypeHelper.requireNonNull(builder.customAnalyzer, this, "customAnalyzer");
        this.tokenfilters = ApiTypeHelper.unmodifiable(builder.tokenfilters);
        this.tokenizer = builder.tokenizer;
    }

    public static AnalyzeDetail of(Function<Builder, ObjectBuilder<AnalyzeDetail>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final AnalyzerDetail analyzer() {
        return this.analyzer;
    }

    @Nonnull
    public final List<CharFilterDetail> charfilters() {
        return this.charfilters;
    }

    public final boolean customAnalyzer() {
        return this.customAnalyzer;
    }

    @Nonnull
    public final List<TokenDetail> tokenfilters() {
        return this.tokenfilters;
    }

    @Nullable
    public final TokenDetail tokenizer() {
        return this.tokenizer;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.analyzer != null) {
            generator.writeKey("analyzer");
            this.analyzer.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.charfilters)) {
            generator.writeKey("charfilters");
            generator.writeStartArray();
            for (CharFilterDetail charFilterDetail : this.charfilters) {
                charFilterDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("custom_analyzer");
        generator.write(this.customAnalyzer);
        if (ApiTypeHelper.isDefined(this.tokenfilters)) {
            generator.writeKey("tokenfilters");
            generator.writeStartArray();
            for (TokenDetail tokenDetail : this.tokenfilters) {
                tokenDetail.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.tokenizer != null) {
            generator.writeKey("tokenizer");
            this.tokenizer.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupAnalyzeDetailDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::analyzer, AnalyzerDetail._DESERIALIZER, "analyzer");
        op.add(Builder::charfilters, JsonpDeserializer.arrayDeserializer(CharFilterDetail._DESERIALIZER), "charfilters");
        op.add(Builder::customAnalyzer, JsonpDeserializer.booleanDeserializer(), "custom_analyzer");
        op.add(Builder::tokenfilters, JsonpDeserializer.arrayDeserializer(TokenDetail._DESERIALIZER), "tokenfilters");
        op.add(Builder::tokenizer, TokenDetail._DESERIALIZER, "tokenizer");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.analyzer);
        result = 31 * result + Objects.hashCode(this.charfilters);
        result = 31 * result + Boolean.hashCode(this.customAnalyzer);
        result = 31 * result + Objects.hashCode(this.tokenfilters);
        result = 31 * result + Objects.hashCode(this.tokenizer);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyzeDetail other = (AnalyzeDetail)o;
        return Objects.equals(this.analyzer, other.analyzer) && Objects.equals(this.charfilters, other.charfilters) && this.customAnalyzer == other.customAnalyzer && Objects.equals(this.tokenfilters, other.tokenfilters) && Objects.equals(this.tokenizer, other.tokenizer);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, AnalyzeDetail> {
        @Nullable
        private AnalyzerDetail analyzer;
        @Nullable
        private List<CharFilterDetail> charfilters;
        private Boolean customAnalyzer;
        @Nullable
        private List<TokenDetail> tokenfilters;
        @Nullable
        private TokenDetail tokenizer;

        public Builder() {
        }

        private Builder(AnalyzeDetail o) {
            this.analyzer = o.analyzer;
            this.charfilters = Builder._listCopy(o.charfilters);
            this.customAnalyzer = o.customAnalyzer;
            this.tokenfilters = Builder._listCopy(o.tokenfilters);
            this.tokenizer = o.tokenizer;
        }

        private Builder(Builder o) {
            this.analyzer = o.analyzer;
            this.charfilters = Builder._listCopy(o.charfilters);
            this.customAnalyzer = o.customAnalyzer;
            this.tokenfilters = Builder._listCopy(o.tokenfilters);
            this.tokenizer = o.tokenizer;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder analyzer(@Nullable AnalyzerDetail value) {
            this.analyzer = value;
            return this;
        }

        @Nonnull
        public final Builder analyzer(Function<AnalyzerDetail.Builder, ObjectBuilder<AnalyzerDetail>> fn) {
            return this.analyzer(fn.apply(new AnalyzerDetail.Builder()).build());
        }

        @Nonnull
        public final Builder charfilters(List<CharFilterDetail> list) {
            this.charfilters = Builder._listAddAll(this.charfilters, list);
            return this;
        }

        @Nonnull
        public final Builder charfilters(CharFilterDetail value, CharFilterDetail ... values) {
            this.charfilters = Builder._listAdd(this.charfilters, value, values);
            return this;
        }

        @Nonnull
        public final Builder charfilters(Function<CharFilterDetail.Builder, ObjectBuilder<CharFilterDetail>> fn) {
            return this.charfilters(fn.apply(new CharFilterDetail.Builder()).build(), new CharFilterDetail[0]);
        }

        @Nonnull
        public final Builder customAnalyzer(boolean value) {
            this.customAnalyzer = value;
            return this;
        }

        @Nonnull
        public final Builder tokenfilters(List<TokenDetail> list) {
            this.tokenfilters = Builder._listAddAll(this.tokenfilters, list);
            return this;
        }

        @Nonnull
        public final Builder tokenfilters(TokenDetail value, TokenDetail ... values) {
            this.tokenfilters = Builder._listAdd(this.tokenfilters, value, values);
            return this;
        }

        @Nonnull
        public final Builder tokenfilters(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenfilters(fn.apply(new TokenDetail.Builder()).build(), new TokenDetail[0]);
        }

        @Nonnull
        public final Builder tokenizer(@Nullable TokenDetail value) {
            this.tokenizer = value;
            return this;
        }

        @Nonnull
        public final Builder tokenizer(Function<TokenDetail.Builder, ObjectBuilder<TokenDetail>> fn) {
            return this.tokenizer(fn.apply(new TokenDetail.Builder()).build());
        }

        @Override
        @Nonnull
        public AnalyzeDetail build() {
            this._checkSingleUse();
            return new AnalyzeDetail(this);
        }
    }
}

