/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.rank_eval;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.core.rank_eval.DocumentRating;
import org.opensearch.client.opensearch.core.rank_eval.RankEvalQuery;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class RankEvalRequestItem
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, RankEvalRequestItem> {
    @Nonnull
    private final String id;
    @Nonnull
    private final Map<String, JsonData> params;
    @Nonnull
    private final List<DocumentRating> ratings;
    @Nullable
    private final RankEvalQuery request;
    @Nullable
    private final String templateId;
    public static final JsonpDeserializer<RankEvalRequestItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RankEvalRequestItem::setupRankEvalRequestItemDeserializer);

    private RankEvalRequestItem(Builder builder) {
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
        this.params = ApiTypeHelper.unmodifiable(builder.params);
        this.ratings = ApiTypeHelper.unmodifiableRequired(builder.ratings, (Object)this, "ratings");
        this.request = builder.request;
        this.templateId = builder.templateId;
    }

    public static RankEvalRequestItem of(Function<Builder, ObjectBuilder<RankEvalRequestItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Nonnull
    public final Map<String, JsonData> params() {
        return this.params;
    }

    @Nonnull
    public final List<DocumentRating> ratings() {
        return this.ratings;
    }

    @Nullable
    public final RankEvalQuery request() {
        return this.request;
    }

    @Nullable
    public final String templateId() {
        return this.templateId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("id");
        generator.write(this.id);
        if (ApiTypeHelper.isDefined(this.params)) {
            generator.writeKey("params");
            generator.writeStartObject();
            for (Map.Entry entry : this.params.entrySet()) {
                generator.writeKey((String)entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("ratings");
        generator.writeStartArray();
        for (DocumentRating documentRating : this.ratings) {
            documentRating.serialize(generator, mapper);
        }
        generator.writeEnd();
        if (this.request != null) {
            generator.writeKey("request");
            this.request.serialize(generator, mapper);
        }
        if (this.templateId != null) {
            generator.writeKey("template_id");
            generator.write(this.templateId);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupRankEvalRequestItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.add(Builder::params, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "params");
        op.add(Builder::ratings, JsonpDeserializer.arrayDeserializer(DocumentRating._DESERIALIZER), "ratings");
        op.add(Builder::request, RankEvalQuery._DESERIALIZER, "request");
        op.add(Builder::templateId, JsonpDeserializer.stringDeserializer(), "template_id");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + Objects.hashCode(this.params);
        result = 31 * result + this.ratings.hashCode();
        result = 31 * result + Objects.hashCode(this.request);
        result = 31 * result + Objects.hashCode(this.templateId);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RankEvalRequestItem other = (RankEvalRequestItem)o;
        return this.id.equals(other.id) && Objects.equals(this.params, other.params) && this.ratings.equals(other.ratings) && Objects.equals(this.request, other.request) && Objects.equals(this.templateId, other.templateId);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, RankEvalRequestItem> {
        private String id;
        @Nullable
        private Map<String, JsonData> params;
        private List<DocumentRating> ratings;
        @Nullable
        private RankEvalQuery request;
        @Nullable
        private String templateId;

        public Builder() {
        }

        private Builder(RankEvalRequestItem o) {
            this.id = o.id;
            this.params = Builder._mapCopy(o.params);
            this.ratings = Builder._listCopy(o.ratings);
            this.request = o.request;
            this.templateId = o.templateId;
        }

        private Builder(Builder o) {
            this.id = o.id;
            this.params = Builder._mapCopy(o.params);
            this.ratings = Builder._listCopy(o.ratings);
            this.request = o.request;
            this.templateId = o.templateId;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Nonnull
        public final Builder params(Map<String, JsonData> map) {
            this.params = Builder._mapPutAll(this.params, map);
            return this;
        }

        @Nonnull
        public final Builder params(String key, JsonData value) {
            this.params = Builder._mapPut(this.params, key, value);
            return this;
        }

        @Nonnull
        public final Builder ratings(List<DocumentRating> list) {
            this.ratings = Builder._listAddAll(this.ratings, list);
            return this;
        }

        @Nonnull
        public final Builder ratings(DocumentRating value, DocumentRating ... values) {
            this.ratings = Builder._listAdd(this.ratings, value, values);
            return this;
        }

        @Nonnull
        public final Builder ratings(Function<DocumentRating.Builder, ObjectBuilder<DocumentRating>> fn) {
            return this.ratings(fn.apply(new DocumentRating.Builder()).build(), new DocumentRating[0]);
        }

        @Nonnull
        public final Builder request(@Nullable RankEvalQuery value) {
            this.request = value;
            return this;
        }

        @Nonnull
        public final Builder request(Function<RankEvalQuery.Builder, ObjectBuilder<RankEvalQuery>> fn) {
            return this.request(fn.apply(new RankEvalQuery.Builder()).build());
        }

        @Nonnull
        public final Builder templateId(@Nullable String value) {
            this.templateId = value;
            return this;
        }

        @Override
        @Nonnull
        public RankEvalRequestItem build() {
            this._checkSingleUse();
            return new RankEvalRequestItem(this);
        }
    }
}

