/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.core.msearch;

import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.JsonpSerializer;
import org.opensearch.client.json.UnionDeserializer;
import org.opensearch.client.opensearch._types.ErrorResponse;
import org.opensearch.client.opensearch.core.msearch.MultiSearchItem;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.TaggedUnion;
import org.opensearch.client.util.TaggedUnionUtils;

public class MultiSearchResponseItem<TDocument>
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    private final JsonpSerializer<TDocument> tDocumentSerializer = null;

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private MultiSearchResponseItem(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    private MultiSearchResponseItem(Builder<TDocument> builder) {
        this._kind = ApiTypeHelper.requireNonNull(((Builder)builder)._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(((Builder)builder)._value, builder, "<variant value>");
    }

    public static <TDocument> MultiSearchResponseItem<TDocument> of(Function<Builder<TDocument>, ObjectBuilder<MultiSearchResponseItem<TDocument>>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isResult() {
        return this._kind == Kind.Result;
    }

    public MultiSearchItem<TDocument> result() {
        return (MultiSearchItem)TaggedUnionUtils.get(this, Kind.Result);
    }

    public boolean isFailure() {
        return this._kind == Kind.Failure;
    }

    public ErrorResponse failure() {
        return (ErrorResponse)TaggedUnionUtils.get(this, Kind.Failure);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
    }

    public static <TDocument> JsonpDeserializer<MultiSearchResponseItem<TDocument>> createMultiSearchResponseItemDeserializer(JsonpDeserializer<TDocument> tDocumentDeserializer) {
        return new UnionDeserializer.Builder<MultiSearchResponseItem, Kind, Object>(MultiSearchResponseItem::new, false).addMember(Kind.Result, MultiSearchItem.createMultiSearchItemDeserializer(tDocumentDeserializer)).addMember(Kind.Failure, ErrorResponse._DESERIALIZER).build();
    }

    public static class Builder<TDocument>
    extends ObjectBuilderBase
    implements ObjectBuilder<MultiSearchResponseItem<TDocument>> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<MultiSearchResponseItem<TDocument>> result(MultiSearchItem<TDocument> v) {
            this._kind = Kind.Result;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MultiSearchResponseItem<TDocument>> result(Function<MultiSearchItem.Builder<TDocument>, ObjectBuilder<MultiSearchItem<TDocument>>> fn) {
            return this.result(fn.apply(new MultiSearchItem.Builder()).build());
        }

        public ObjectBuilder<MultiSearchResponseItem<TDocument>> failure(ErrorResponse v) {
            this._kind = Kind.Failure;
            this._value = v;
            return this;
        }

        public ObjectBuilder<MultiSearchResponseItem<TDocument>> failure(Function<ErrorResponse.Builder, ObjectBuilder<ErrorResponse>> fn) {
            return this.failure(fn.apply(new ErrorResponse.Builder()).build());
        }

        @Override
        public MultiSearchResponseItem<TDocument> build() {
            this._checkSingleUse();
            return new MultiSearchResponseItem(this);
        }
    }

    public static enum Kind {
        Result,
        Failure;

    }
}

