/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class StemmerOverrideTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, StemmerOverrideTokenFilter> {
    @Nonnull
    private final List<String> rules;
    @Nullable
    private final String rulesPath;
    public static final JsonpDeserializer<StemmerOverrideTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, StemmerOverrideTokenFilter::setupStemmerOverrideTokenFilterDeserializer);

    private StemmerOverrideTokenFilter(Builder builder) {
        super(builder);
        this.rules = ApiTypeHelper.unmodifiable(builder.rules);
        this.rulesPath = builder.rulesPath;
    }

    public static StemmerOverrideTokenFilter of(Function<Builder, ObjectBuilder<StemmerOverrideTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.StemmerOverride;
    }

    @Nonnull
    public final List<String> rules() {
        return this.rules;
    }

    @Nullable
    public final String rulesPath() {
        return this.rulesPath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "stemmer_override");
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.rules)) {
            generator.writeKey("rules");
            generator.writeStartArray();
            for (String item0 : this.rules) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.rulesPath != null) {
            generator.writeKey("rules_path");
            generator.write(this.rulesPath);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupStemmerOverrideTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        StemmerOverrideTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::rules, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "rules");
        op.add(Builder::rulesPath, JsonpDeserializer.stringDeserializer(), "rules_path");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.rules);
        result = 31 * result + Objects.hashCode(this.rulesPath);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StemmerOverrideTokenFilter other = (StemmerOverrideTokenFilter)o;
        return Objects.equals(this.rules, other.rules) && Objects.equals(this.rulesPath, other.rulesPath);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, StemmerOverrideTokenFilter> {
        @Nullable
        private List<String> rules;
        @Nullable
        private String rulesPath;

        public Builder() {
        }

        private Builder(StemmerOverrideTokenFilter o) {
            super(o);
            this.rules = Builder._listCopy(o.rules);
            this.rulesPath = o.rulesPath;
        }

        private Builder(Builder o) {
            super(o);
            this.rules = Builder._listCopy(o.rules);
            this.rulesPath = o.rulesPath;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder rules(List<String> list) {
            this.rules = Builder._listAddAll(this.rules, list);
            return this;
        }

        @Nonnull
        public final Builder rules(String value, String ... values) {
            this.rules = Builder._listAdd(this.rules, value, values);
            return this;
        }

        @Nonnull
        public final Builder rulesPath(@Nullable String value) {
            this.rulesPath = value;
            return this;
        }

        @Override
        @Nonnull
        public StemmerOverrideTokenFilter build() {
            this._checkSingleUse();
            return new StemmerOverrideTokenFilter(this);
        }
    }
}

