/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.IcuTransformDirection;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IcuTransformTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, IcuTransformTokenFilter> {
    @Nullable
    private final IcuTransformDirection dir;
    @Nonnull
    private final String id;
    public static final JsonpDeserializer<IcuTransformTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IcuTransformTokenFilter::setupIcuTransformTokenFilterDeserializer);

    private IcuTransformTokenFilter(Builder builder) {
        super(builder);
        this.dir = builder.dir;
        this.id = ApiTypeHelper.requireNonNull(builder.id, this, "id");
    }

    public static IcuTransformTokenFilter of(Function<Builder, ObjectBuilder<IcuTransformTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.IcuTransform;
    }

    @Nullable
    public final IcuTransformDirection dir() {
        return this.dir;
    }

    @Nonnull
    public final String id() {
        return this.id;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "icu_transform");
        super.serializeInternal(generator, mapper);
        if (this.dir != null) {
            generator.writeKey("dir");
            this.dir.serialize(generator, mapper);
        }
        generator.writeKey("id");
        generator.write(this.id);
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIcuTransformTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        IcuTransformTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::dir, IcuTransformDirection._DESERIALIZER, "dir");
        op.add(Builder::id, JsonpDeserializer.stringDeserializer(), "id");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.dir);
        result = 31 * result + this.id.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IcuTransformTokenFilter other = (IcuTransformTokenFilter)o;
        return Objects.equals(this.dir, other.dir) && this.id.equals(other.id);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, IcuTransformTokenFilter> {
        @Nullable
        private IcuTransformDirection dir;
        private String id;

        public Builder() {
        }

        private Builder(IcuTransformTokenFilter o) {
            super(o);
            this.dir = o.dir;
            this.id = o.id;
        }

        private Builder(Builder o) {
            super(o);
            this.dir = o.dir;
            this.id = o.id;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder dir(@Nullable IcuTransformDirection value) {
            this.dir = value;
            return this;
        }

        @Nonnull
        public final Builder id(String value) {
            this.id = value;
            return this;
        }

        @Override
        @Nonnull
        public IcuTransformTokenFilter build() {
            this._checkSingleUse();
            return new IcuTransformTokenFilter(this);
        }
    }
}

