/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.quantizer;

import lombok.Generated;

final class BitPacker {
    static void quantizeAndPackBits(float[] vector, float[][] thresholds, int bitsPerCoordinate, byte[] packedBits) {
        int vectorLength = vector.length;
        for (int i = 0; i < bitsPerCoordinate; ++i) {
            for (int j = 0; j < vectorLength; ++j) {
                if (!(vector[j] > thresholds[i][j])) continue;
                int bitPosition = i * vectorLength + j;
                int byteIndex = bitPosition >> 3;
                int bitIndex = 7 - (bitPosition & 7);
                int n = byteIndex;
                packedBits[n] = (byte)(packedBits[n] | 1 << bitIndex);
            }
        }
    }

    static void quantizeAndPackBits(float[] vector, float[] thresholds, byte[] packedBits) {
        BitPacker.quantizeAndPackBits(vector, new float[][]{thresholds}, 1, packedBits);
    }

    @Generated
    private BitPacker() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

