/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.Closeable;
import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.ByteBuffersIndexOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RandomAccessInput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.packed.DirectMonotonicReader;
import org.apache.lucene.util.packed.DirectMonotonicWriter;
import org.opensearch.common.lucene.store.ByteArrayIndexInput;

public final class MonotonicIntegerSequenceEncoder {
    private static final int DIRECT_MONOTONIC_BLOCK_SHIFT = 16;

    public static DirectMonotonicReader encode(int numElements, IndexInput input) throws IOException {
        ByteBuffersDataOutput dataOutput = new ByteBuffersDataOutput();
        ByteBuffersIndexOutput dataIndexOutput = new ByteBuffersIndexOutput(dataOutput, "MonotonicSequenceEncoder", "MonotonicSequenceEncoderData");
        ByteBuffersDataOutput metaOutput = new ByteBuffersDataOutput();
        ByteBuffersIndexOutput metaIndexOutput = new ByteBuffersIndexOutput(metaOutput, "MonotonicSequenceEncoder", "MonotonicSequenceEncoderMeta");
        DirectMonotonicWriter encoder = DirectMonotonicWriter.getInstance((IndexOutput)metaIndexOutput, (IndexOutput)dataIndexOutput, (long)numElements, (int)16);
        boolean isIdenticalMapping = true;
        for (long i = 0L; i < (long)numElements; ++i) {
            long value = Math.toIntExact(input.readLong());
            if (value != i) {
                isIdenticalMapping = false;
            }
            encoder.add(value);
        }
        encoder.finish();
        IOUtils.close((Closeable[])new Closeable[]{dataIndexOutput, metaIndexOutput});
        if (isIdenticalMapping) {
            return null;
        }
        byte[] metaBytes = metaOutput.toArrayCopy();
        ByteArrayIndexInput metaInput = new ByteArrayIndexInput("MonotonicSequenceEncoder", metaBytes);
        byte[] dataBytes = dataOutput.toArrayCopy();
        ByteArrayIndexInput dataInput = new ByteArrayIndexInput("MonotonicSequenceEncoder", dataBytes);
        DirectMonotonicReader.Meta encodingMeta = DirectMonotonicReader.loadMeta((IndexInput)metaInput, (long)numElements, (int)16);
        return DirectMonotonicReader.getInstance((DirectMonotonicReader.Meta)encodingMeta, (RandomAccessInput)dataInput);
    }

    @Generated
    private MonotonicIntegerSequenceEncoder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

