/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSW;
import org.opensearch.knn.memoryoptsearch.faiss.FaissHNSWIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIdMapIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndex;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndexFloatFlat;
import org.opensearch.knn.memoryoptsearch.faiss.FaissIndexScalarQuantizedFlat;
import org.opensearch.knn.memoryoptsearch.faiss.UnsupportedFaissIndexException;
import org.opensearch.knn.memoryoptsearch.faiss.binary.FaissBinaryHnswIndex;
import org.opensearch.knn.memoryoptsearch.faiss.binary.FaissIndexBinaryFlat;
import org.opensearch.knn.memoryoptsearch.faiss.cagra.FaissHNSWCagraBinaryIndex;
import org.opensearch.knn.memoryoptsearch.faiss.cagra.FaissHNSWCagraIndex;

public final class IndexTypeToFaissIndexMapping {
    private static final Map<String, Function<String, FaissIndex>> INDEX_TYPE_TO_FAISS_INDEX;

    public static FaissIndex getFaissIndex(String indexType) {
        Function<String, FaissIndex> faissIndexSupplier = INDEX_TYPE_TO_FAISS_INDEX.get(indexType);
        if (faissIndexSupplier != null) {
            return faissIndexSupplier.apply(indexType);
        }
        throw new UnsupportedFaissIndexException("Index type [" + indexType + "] is not supported.");
    }

    @Generated
    private IndexTypeToFaissIndexMapping() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        HashMap<String, Function<String, FaissIndex>> mapping = new HashMap<String, Function<String, FaissIndex>>();
        mapping.put("IxMp", FaissIdMapIndex::new);
        mapping.put("IHNf", FaissHNSWIndex::new);
        mapping.put("IHNs", FaissHNSWIndex::new);
        mapping.put("IxF2", FaissIndexFloatFlat::new);
        mapping.put("IxFI", FaissIndexFloatFlat::new);
        mapping.put("IxSQ", indexType -> new FaissIndexScalarQuantizedFlat());
        mapping.put("IHNc", FaissHNSWCagraIndex::new);
        mapping.put("IHc2", FaissHNSWCagraIndex::new);
        mapping.put("IBxF", indexType -> new FaissIndexBinaryFlat());
        mapping.put("IBHf", indexType -> new FaissBinaryHnswIndex((String)indexType, new FaissHNSW()));
        mapping.put("IBMp", FaissIdMapIndex::new);
        mapping.put("IBHc", indexType -> new FaissHNSWCagraBinaryIndex());
        INDEX_TYPE_TO_FAISS_INDEX = Collections.unmodifiableMap(mapping);
    }
}

