/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.iterators;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.util.BitSet;
import org.opensearch.common.Nullable;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.query.iterators.ByteVectorIdsKNNIterator;
import org.opensearch.knn.index.vectorvalues.KNNByteVectorValues;

public class NestedByteVectorIdsKNNIterator
extends ByteVectorIdsKNNIterator {
    private final BitSet parentBitSet;

    public NestedByteVectorIdsKNNIterator(@Nullable DocIdSetIterator filterIdsIterator, float[] queryVector, KNNByteVectorValues byteVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        super(filterIdsIterator, queryVector, byteVectorValues, spaceType);
        this.parentBitSet = parentBitSet;
    }

    public NestedByteVectorIdsKNNIterator(float[] queryVector, KNNByteVectorValues binaryVectorValues, SpaceType spaceType, BitSet parentBitSet) throws IOException {
        super(null, queryVector, binaryVectorValues, spaceType);
        this.parentBitSet = parentBitSet;
    }

    @Override
    public int nextDoc() throws IOException {
        if (this.docId == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        this.currentScore = Float.NEGATIVE_INFINITY;
        int currentParent = this.parentBitSet.nextSetBit(this.docId);
        int bestChild = -1;
        while (this.docId != Integer.MAX_VALUE && this.docId < currentParent) {
            float score = this.computeScore();
            if (score > this.currentScore) {
                bestChild = this.docId;
                this.currentScore = score;
            }
            this.docId = this.getNextDocId();
        }
        return bestChild;
    }
}

