/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec;

import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import org.apache.lucene.codecs.StoredFieldsReader;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.util.IOUtils;
import org.opensearch.index.fieldvisitor.FieldsVisitor;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.DerivedSourceVectorInjector;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.KNN9120DerivedSourceReaders;
import org.opensearch.knn.index.codec.backward_codecs.KNN9120Codec.KNN9120DerivedSourceStoredFieldVisitor;

public class KNN9120DerivedSourceStoredFieldsReader
extends StoredFieldsReader {
    private final StoredFieldsReader delegate;
    private final List<FieldInfo> derivedVectorFields;
    private final KNN9120DerivedSourceReaders derivedSourceReaders;
    private final SegmentReadState segmentReadState;
    private final boolean shouldInject;
    private final DerivedSourceVectorInjector derivedSourceVectorInjector;

    public KNN9120DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<FieldInfo> derivedVectorFields, KNN9120DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState) throws IOException {
        this(delegate, derivedVectorFields, derivedSourceReaders, segmentReadState, true);
    }

    private KNN9120DerivedSourceStoredFieldsReader(StoredFieldsReader delegate, List<FieldInfo> derivedVectorFields, KNN9120DerivedSourceReaders derivedSourceReaders, SegmentReadState segmentReadState, boolean shouldInject) throws IOException {
        this.delegate = delegate;
        this.derivedVectorFields = derivedVectorFields;
        this.derivedSourceReaders = derivedSourceReaders;
        this.segmentReadState = segmentReadState;
        this.shouldInject = shouldInject;
        this.derivedSourceVectorInjector = this.createDerivedSourceVectorInjector();
    }

    private DerivedSourceVectorInjector createDerivedSourceVectorInjector() throws IOException {
        return new DerivedSourceVectorInjector(this.derivedSourceReaders, this.segmentReadState, this.derivedVectorFields);
    }

    public void document(int docId, StoredFieldVisitor storedFieldVisitor) throws IOException {
        boolean isVisitorNeedFields = true;
        if (storedFieldVisitor instanceof FieldsVisitor) {
            isVisitorNeedFields = this.derivedSourceVectorInjector.shouldInject(((FieldsVisitor)storedFieldVisitor).includes(), ((FieldsVisitor)storedFieldVisitor).excludes());
        }
        if (this.shouldInject && isVisitorNeedFields) {
            this.delegate.document(docId, (StoredFieldVisitor)new KNN9120DerivedSourceStoredFieldVisitor(storedFieldVisitor, docId, this.derivedSourceVectorInjector));
            return;
        }
        this.delegate.document(docId, storedFieldVisitor);
    }

    public StoredFieldsReader clone() {
        try {
            return new KNN9120DerivedSourceStoredFieldsReader(this.delegate.clone(), this.derivedVectorFields, this.derivedSourceReaders.cloneWithMerge(), this.segmentReadState, this.shouldInject);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void checkIntegrity() throws IOException {
        this.delegate.checkIntegrity();
    }

    public void close() throws IOException {
        IOUtils.close((Closeable[])new Closeable[]{this.delegate, this.derivedSourceReaders});
    }

    public static boolean doesMergeContainLegacySegments(MergeState mergeState) {
        for (int i = 0; i < mergeState.storedFieldsReaders.length; ++i) {
            if (!(mergeState.storedFieldsReaders[i] instanceof KNN9120DerivedSourceStoredFieldsReader) || !KNN9120DerivedSourceStoredFieldsReader.doesSegmentContainLegacyFields(mergeState.fieldInfos[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean doesSegmentContainLegacyFields(FieldInfos fieldInfos) {
        for (FieldInfo fieldInfo : fieldInfos) {
            if (!"true".equals(fieldInfo.attributes().get("knn-derived-source-enabled"))) continue;
            return true;
        }
        return false;
    }
}

