/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge;

import java.lang.invoke.LambdaMetafactory;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.action.admin.indices.stats.IndicesStatsRequest;
import org.opensearch.action.admin.indices.stats.IndicesStatsResponse;
import org.opensearch.action.admin.indices.stats.ShardStats;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.support.DefaultShardOperationFailedException;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.indexmanagement.indexstatemanagement.action.ForceMergeAction;
import org.opensearch.indexmanagement.indexstatemanagement.step.forcemerge.WaitForForceMergeStep;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Step;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ActionProperties;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.ManagedIndexMetaData;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepContext;
import org.opensearch.indexmanagement.spi.indexstatemanagement.model.StepMetaData;
import org.opensearch.transport.client.IndicesAdminClient;
import org.opensearch.transport.client.OpenSearchClient;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u000f\u001a\u00020\u0000H\u0096@\u00a2\u0006\u0002\u0010\u0010J\u0017\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J(\u0010\u0016\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0082@\u00a2\u0006\u0002\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step;", "action", "Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;", "<init>", "(Lorg/opensearch/indexmanagement/indexstatemanagement/action/ForceMergeAction;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stepStatus", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Step$StepStatus;", "info", "", "", "", "execute", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getMaxNumSegments", "", "context", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;", "(Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;)Ljava/lang/Integer;", "getShardsStillMergingSegments", "indexName", "maxNumSegments", "(Ljava/lang/String;ILorg/opensearch/indexmanagement/spi/indexstatemanagement/model/StepContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getActionStartTime", "Ljava/time/Instant;", "getUpdatedManagedIndexMetadata", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/model/ManagedIndexMetaData;", "currentMetadata", "isIdempotent", "", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nWaitForForceMergeStep.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WaitForForceMergeStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,179:1\n12797#2,3:180\n11228#2:183\n11563#2,3:184\n*S KotlinDebug\n*F\n+ 1 WaitForForceMergeStep.kt\norg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep\n*L\n106#1:180,3\n123#1:183\n123#1:184,3\n*E\n"})
public final class WaitForForceMergeStep
extends Step {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ForceMergeAction action;
    private final Logger logger;
    @NotNull
    private Step.StepStatus stepStatus;
    @Nullable
    private Map<String, ? extends Object> info;
    @NotNull
    public static final String name = "wait_for_force_merge";
    public static final long FORCE_MERGE_TIMEOUT_IN_SECONDS = 43200L;

    public WaitForForceMergeStep(@NotNull ForceMergeAction action) {
        Intrinsics.checkNotNullParameter((Object)((Object)action), (String)"action");
        super(name, false);
        this.action = action;
        this.logger = LogManager.getLogger(((Object)((Object)this)).getClass());
        this.stepStatus = Step.StepStatus.STARTING;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object execute(@NotNull Continuation<? super WaitForForceMergeStep> $completion) {
        if (!($completion instanceof execute.1)) ** GOTO lbl-1000
        var10_2 = $completion;
        if ((var10_2.label & -2147483648) != 0) {
            var10_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForForceMergeStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.execute((Continuation<? super WaitForForceMergeStep>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var11_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = this.getContext();
                if (v0 == null) {
                    return this;
                }
                context = v0;
                indexName = context.getMetadata().getIndex();
                v1 = this.getMaxNumSegments(context);
                if (v1 == null) {
                    return this;
                }
                maxNumSegments = v1;
                $continuation.L$0 = context;
                $continuation.L$1 = indexName;
                $continuation.I$0 = maxNumSegments;
                $continuation.label = 1;
                v2 = this.getShardsStillMergingSegments(indexName, maxNumSegments, context, (Continuation<? super Integer>)$continuation);
                if (v2 == var11_4) {
                    return var11_4;
                }
                ** GOTO lbl35
            }
            case 1: {
                maxNumSegments = $continuation.I$0;
                indexName = (String)$continuation.L$1;
                context = (StepContext)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl35:
                // 2 sources

                v3 = shardsStillMergingSegments = (Integer)v2;
                if (v3 == null) {
                    return this;
                }
                v3.intValue();
                if (shardsStillMergingSegments == 0) {
                    message = WaitForForceMergeStep.Companion.getSuccessMessage(indexName);
                    this.logger.info(message);
                    this.stepStatus = Step.StepStatus.COMPLETED;
                    this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)message));
                } else {
                    v4 = Duration.between(this.getActionStartTime(context), Instant.now());
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"between(...)");
                    timeWaitingForForceMerge = v4;
                    v5 = this.action.getConfigTimeout();
                    v6 = v5 != null && (v5 = v5.getTimeout()) != null ? v5.getSeconds() : (timeoutInSeconds = 43200L);
                    if (timeWaitingForForceMerge.getSeconds() > timeoutInSeconds) {
                        this.logger.error("Force merge on [" + indexName + "] timed out with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.FAILED;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getFailedTimedOutMessage(indexName)));
                    } else {
                        this.logger.debug("Force merge still running on [" + indexName + "] with [" + shardsStillMergingSegments + "] shards containing unmerged segments");
                        this.stepStatus = Step.StepStatus.CONDITION_NOT_MET;
                        this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)WaitForForceMergeStep.Companion.getWaitingMessage(indexName)));
                    }
                }
                return this;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Integer getMaxNumSegments(StepContext context) {
        ActionProperties actionProperties;
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        ActionMetaData actionMetaData = managedIndexMetaData.getActionMetaData();
        ActionProperties actionProperties2 = actionProperties = actionMetaData != null ? actionMetaData.getActionProperties() : null;
        if ((actionProperties2 != null ? actionProperties2.getMaxNumSegments() : null) == null) {
            this.stepStatus = Step.StepStatus.FAILED;
            this.info = MapsKt.mapOf((Pair)TuplesKt.to((Object)"message", (Object)("Unable to retrieve [" + ActionProperties.Properties.MAX_NUM_SEGMENTS.getKey() + "] from ActionProperties=" + actionProperties)));
            return null;
        }
        return actionProperties.getMaxNumSegments();
    }

    /*
     * Unable to fully structure code
     */
    private final Object getShardsStillMergingSegments(String indexName, int maxNumSegments, StepContext context, Continuation<? super Integer> $completion) {
        if (!($completion instanceof getShardsStillMergingSegments.1)) ** GOTO lbl-1000
        var25_5 = $completion;
        if ((var25_5.label & -2147483648) != 0) {
            var25_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ WaitForForceMergeStep this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return WaitForForceMergeStep.access$getShardsStillMergingSegments(this.this$0, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var26_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var6_8 = new String[]{indexName};
                statsRequest = (IndicesStatsRequest)new IndicesStatsRequest().indices(var6_8);
                $continuation.L$0 = indexName;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)context);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)statsRequest);
                $continuation.I$0 = maxNumSegments;
                $continuation.label = 1;
                v0 = OpenSearchExtensionsKt.suspendUntil((OpenSearchClient)context.getClient().admin().indices(), (Function2)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, getShardsStillMergingSegments$lambda$0(org.opensearch.action.admin.indices.stats.IndicesStatsRequest org.opensearch.transport.client.IndicesAdminClient org.opensearch.core.action.ActionListener ), (Lorg/opensearch/transport/client/IndicesAdminClient;Lorg/opensearch/core/action/ActionListener;)Lkotlin/Unit;)((IndicesStatsRequest)statsRequest), $continuation);
                ** if (v0 != var26_7) goto lbl24
lbl23:
                // 1 sources

                return var26_7;
lbl24:
                // 1 sources

                ** GOTO lbl34
            }
            case 1: {
                maxNumSegments = $continuation.I$0;
                statsRequest = (IndicesStatsRequest)$continuation.L$2;
                context = (StepContext)$continuation.L$1;
                indexName = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl34:
                    // 2 sources

                    if ((statsResponse = (IndicesStatsResponse)v0).getStatus() == RestStatus.OK) {
                        v1 = statsResponse.getShards();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getShards(...)");
                        $this$count$iv = v1;
                        $i$f$count = false;
                        count$iv = 0;
                        for (Object element$iv : $this$count$iv) {
                            it = (ShardStats)element$iv;
                            $i$a$-count-WaitForForceMergeStep$getShardsStillMergingSegments$2 = false;
                            v2 = it.getStats().segments;
                            v3 = count = v2 != null ? Boxing.boxLong((long)v2.getCount()) : null;
                            if (count == null) {
                                this.logger.warn(indexName + " wait for force merge had null segments");
                                v4 = false;
                            } else {
                                v4 = count > (long)maxNumSegments;
                            }
                            if (!v4) continue;
                            ++count$iv;
                        }
                        return Boxing.boxInt((int)count$iv);
                    }
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.warn(message + " - " + statsResponse.getStatus());
                    this.stepStatus = Step.StepStatus.FAILED;
                    $i$f$count = new Pair[2];
                    $i$f$count[0] = TuplesKt.to((Object)"message", (Object)message);
                    v5 = statsResponse.getShardFailures();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"getShardFailures(...)");
                    count$iv = v5;
                    var22_32 = "shard_failures";
                    var21_33 = 1;
                    var20_34 = $i$f$count;
                    var19_35 = this;
                    $i$f$map = false;
                    var11_23 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(((void)$this$map$iv).length);
                    $i$f$mapTo = false;
                    for (void item$iv$iv : $this$mapTo$iv$iv) {
                        var17_37 = (DefaultShardOperationFailedException)item$iv$iv;
                        var23_39 = destination$iv$iv;
                        $i$a$-map-WaitForForceMergeStep$getShardsStillMergingSegments$3 = false;
                        Intrinsics.checkNotNull((Object)it);
                        var23_39.add(OpenSearchExtensionsKt.getUsefulCauseString((DefaultShardOperationFailedException)it));
                    }
                    var23_39 = (List)destination$iv$iv;
                    var20_34[var21_33] = TuplesKt.to((Object)var22_32, (Object)var23_39);
                    var19_35.info = MapsKt.mapOf((Pair[])$i$f$count);
                }
                catch (Exception e) {
                    message = WaitForForceMergeStep.Companion.getFailedSegmentCheckMessage(indexName);
                    this.logger.error(message, (Throwable)e);
                    this.stepStatus = Step.StepStatus.FAILED;
                    $i$f$count = new Pair[]{TuplesKt.to((Object)"message", (Object)message)};
                    mutableInfo = MapsKt.mutableMapOf((Pair[])$i$f$count);
                    errorMessage = e.getMessage();
                    if (errorMessage != null) {
                        mutableInfo.put("cause", errorMessage);
                    }
                    this.info = MapsKt.toMap((Map)mutableInfo);
                }
                return null;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Instant getActionStartTime(StepContext context) {
        ManagedIndexMetaData managedIndexMetaData = context.getMetadata();
        Object object = managedIndexMetaData.getActionMetaData();
        if (object == null || (object = object.getStartTime()) == null) {
            Instant instant = Instant.now();
            Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
            return instant;
        }
        long startTime = (Long)object;
        Instant instant = Instant.ofEpochMilli(startTime);
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochMilli(...)");
        return instant;
    }

    @NotNull
    public ManagedIndexMetaData getUpdatedManagedIndexMetadata(@NotNull ManagedIndexMetaData currentMetadata) {
        ActionMetaData actionMetaData;
        ActionMetaData currentActionMetaData;
        Intrinsics.checkNotNullParameter((Object)currentMetadata, (String)"currentMetadata");
        ActionMetaData actionMetaData2 = currentActionMetaData = currentMetadata.getActionMetaData();
        if (actionMetaData2 != null) {
            ActionMetaData it = actionMetaData2;
            boolean bl = false;
            actionMetaData = this.stepStatus != Step.StepStatus.COMPLETED ? it : ActionMetaData.copy$default((ActionMetaData)currentActionMetaData, null, null, (int)0, (boolean)false, (int)0, null, null, (int)63, null);
        } else {
            actionMetaData = null;
        }
        ActionMetaData updatedActionMetaData = actionMetaData;
        StepMetaData stepMetaData = new StepMetaData(this.getName(), this.getStepStartTime(currentMetadata).toEpochMilli(), this.stepStatus);
        Map<String, ? extends Object> map = this.info;
        return ManagedIndexMetaData.copy$default((ManagedIndexMetaData)currentMetadata, null, null, null, null, null, null, null, null, null, null, (ActionMetaData)updatedActionMetaData, (StepMetaData)stepMetaData, null, map, null, (long)0L, (long)0L, null, (int)250623, null);
    }

    public boolean isIdempotent() {
        return true;
    }

    private static final Unit getShardsStillMergingSegments$lambda$0(IndicesStatsRequest $statsRequest, IndicesAdminClient $this$suspendUntil, ActionListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $this$suspendUntil.stats($statsRequest, it);
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Object access$getShardsStillMergingSegments(WaitForForceMergeStep $this, String indexName, int maxNumSegments, StepContext context, Continuation $completion) {
        return $this.getShardsStillMergingSegments(indexName, maxNumSegments, context, (Continuation<? super Integer>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\n\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005J\u000e\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/step/forcemerge/WaitForForceMergeStep$Companion;", "", "<init>", "()V", "name", "", "FORCE_MERGE_TIMEOUT_IN_SECONDS", "", "getFailedTimedOutMessage", "index", "getFailedSegmentCheckMessage", "getWaitingMessage", "getSuccessMessage", "opensearch-index-management"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getFailedTimedOutMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Force merge timed out [index=" + index2 + "]";
        }

        @NotNull
        public final String getFailedSegmentCheckMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Failed to check segments when waiting for force merge to complete [index=" + index2 + "]";
        }

        @NotNull
        public final String getWaitingMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Waiting for force merge to complete [index=" + index2 + "]";
        }

        @NotNull
        public final String getSuccessMessage(@NotNull String index2) {
            Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
            return "Successfully confirmed segments force merged [index=" + index2 + "]";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

