"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MOCK_DATA = void 0;
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const mockChime = {
  name: 'Chime test channel',
  description: 'test description',
  config_type: 'chime',
  is_enabled: true,
  chime: {
    url: 'https://hooks.chime.aws/incomingwebhooks/sample_chime_url?token=123456'
  },
  config_id: 'test-chime',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSlack = {
  name: 'Slack test channel',
  description: 'test description',
  config_type: 'slack',
  is_enabled: false,
  slack: {
    url: 'https://hooks.slack.com/services/A123456/B1234567/A1B2C3D4E5F6G7H8I9J0K1L2'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockEmail = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1l8hq3kB0XwiBlEbanSo', 'dz8etXkBCzVy9Vy-0sgh', 'eD8ktXkBCzVy9Vy-A8j-', '1V8gq3kB0XwiBlEbAXSI', 'dD_8tHkBCzVy9Vy-5si0', '52XGr3kBqFjWrmvL43mv'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1l8hq3kB0XwiBlEbanSo': 'name1',
      'dz8etXkBCzVy9Vy-0sgh': 'name2',
      'eD8ktXkBCzVy9Vy-A8j-': 'name3',
      '1V8gq3kB0XwiBlEbAXSI': 'name4',
      'dD_8tHkBCzVy9Vy-5si0': 'name5',
      '52XGr3kBqFjWrmvL43mv': 'name6'
    },
    invalid_ids: [],
    sender_type: 'smtp_account'
  },
  config_id: 'DMG3zXkBPa6YFxmVfNmm',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockEmailWithSES = {
  name: 'Email test channel',
  description: 'test description',
  config_type: 'email',
  is_enabled: true,
  email: {
    email_account_id: 'dj8etXkBCzVy9Vy-nsiL',
    recipient_list: [{
      recipient: 'custom@email.com'
    }, {
      recipient: 'email@test.com'
    }, {
      recipient: 'test@email.com'
    }],
    email_group_id_list: ['1y8ud3xO0KjvOyRonaFb', 'qm8rgKxOPmIl9Il-0ftu', 'rQ8xgKxOPmIl9Il-N8w-', '1I8td3xO0KjvOyRoNKFV', 'qQ_8gUxOPmIl9Il-5fv0', '52KTe3xOdSwJeziY43zi'],
    email_account_name: 'name1',
    email_group_id_map: {
      '1y8ud3xO0KjvOyRonaFb': 'name1',
      'qm8rgKxOPmIl9Il-0ftu': 'name2',
      'rQ8xgKxOPmIl9Il-N8w-': 'name3',
      '1I8td3xO0KjvOyRoNKFV': 'name4',
      'qQ_8gUxOPmIl9Il-5fv0': 'name5',
      '52KTe3xOdSwJeziY43zi': 'name6'
    },
    invalid_ids: ['52KTe3xOdSwJeziY43zi'],
    sender_type: 'ses_account'
  },
  config_id: 'QZT3mKxOCn6LSkzIsAzz',
  created_time_ms: 1622654024861,
  last_updated_time_ms: 1622656665674
};
const mockWebhook = {
  name: 'Webhook test channel',
  description: 'test description',
  config_type: 'webhook',
  is_enabled: true,
  webhook: {
    url: 'https://host:23/path?key1=%23%404&key2=&key3=value3',
    header_params: {
      key1: 'value1',
      key2: 'value2',
      key3: '',
      key4: 'value4',
      key5: 'value5',
      key6: 'value6'
    },
    method: 'POST'
  },
  config_id: '7mUjsHkBqFjWrmvLc3nl',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSNS = {
  name: 'SNS test channel',
  description: 'test description',
  config_type: 'sns',
  is_enabled: true,
  sns: {
    topic_arn: 'arn:aws:sns:us-west-2:012345678912:notifications-test',
    role_arn: 'arn:aws:iam::012345678912:role/NotificationsSNSRole'
  },
  config_id: 'erCDYHsBUMRLC5PZXfPN',
  created_time_ms: 1622157784037,
  last_updated_time_ms: 1622581084050
};
const mockSender = {
  name: 'test-sender',
  description: 'test description',
  config_id: '72UysHkBqFjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  smtp_account: {
    host: 'example.com',
    port: '23',
    method: 'start_tls',
    from_address: 'sample@email.com'
  }
};
const mockMicrosoftTeams = {
  name: 'Microsoft Teams test channel',
  description: 'test description',
  config_type: 'microsoft_teams',
  is_enabled: false,
  microsoft_teams: {
    url: 'https://hooks.chime.aws/incomingwebhooks/sample_chime_url?token=123456'
  },
  config_id: 'test-slack',
  created_time_ms: 1622670451891,
  last_updated_time_ms: 1622670451891
};
const mockSESSender = {
  name: 'test-ses-sender',
  description: 'test description',
  config_id: '72HlfUxOdSwJeziYSKxO',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  ses_account: {
    from_address: 'sample@email.com',
    region: 'us-west-2',
    role_arn: 'arn:aws:iam::012345678912:role/TestNotificationsSESRole'
  }
};
const mockRecipientGroup = {
  name: 'Test recipient group',
  description: 'test description',
  config_id: '72UysHkBqVjWrmvLFXkB',
  created_time_ms: 1622158742784,
  last_updated_time_ms: 1622158742784,
  email_group: {
    recipient_list: [{
      recipient: 'test1@email.com'
    }, {
      recipient: 'test2@email.com'
    }, {
      recipient: 'test3@email.com'
    }, {
      recipient: 'test4@email.com'
    }, {
      recipient: 'test5@email.com'
    }, {
      recipient: 'test6@email.com'
    }]
  }
};
const MOCK_DATA = exports.MOCK_DATA = {
  channels: {
    items: [mockChime, mockSlack, mockEmail, mockEmailWithSES, mockWebhook, mockSNS, mockMicrosoftTeams],
    total: 7
  },
  chime: mockChime,
  slack: mockSlack,
  email: mockEmail,
  emailWithSES: mockEmailWithSES,
  webhook: mockWebhook,
  sns: mockSNS,
  microsoftTeams: mockMicrosoftTeams,
  sender: mockSender,
  sesSender: mockSESSender,
  senders: {
    items: [mockSender],
    total: 1
  },
  sesSenders: {
    items: [mockSESSender],
    total: 1
  },
  recipientGroup: mockRecipientGroup,
  recipientGroups: {
    items: [mockRecipientGroup],
    total: 1
  }
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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