/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.state.tree;

import com.amazon.randomcutforest.state.IContextualStateMapper;
import com.amazon.randomcutforest.state.tree.AbstractNodeStoreMapper;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeContext;
import com.amazon.randomcutforest.state.tree.CompactRandomCutTreeState;
import com.amazon.randomcutforest.tree.AbstractNodeStore;
import com.amazon.randomcutforest.tree.RandomCutTree;

public class RandomCutTreeMapper
implements IContextualStateMapper<RandomCutTree, CompactRandomCutTreeState, CompactRandomCutTreeContext> {
    @Override
    public RandomCutTree toModel(CompactRandomCutTreeState state, CompactRandomCutTreeContext context, long seed) {
        int dimension = state.getDimensions() != 0 ? state.getDimensions() : context.getPointStore().getDimensions();
        context.setDimension(dimension);
        AbstractNodeStoreMapper nodeStoreMapper = new AbstractNodeStoreMapper();
        nodeStoreMapper.setRoot(state.getRoot());
        AbstractNodeStore nodeStore = (AbstractNodeStore)nodeStoreMapper.toModel(state.getNodeStoreState(), context);
        int newRoot = nodeStore.isLeaf(state.getRoot()) ? nodeStore.getCapacity() : state.getRoot();
        RandomCutTree tree = ((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)((RandomCutTree.Builder)new RandomCutTree.Builder().dimension(dimension)).storeSequenceIndexesEnabled(state.isStoreSequenceIndexesEnabled())).capacity(state.getMaxSize())).setRoot(newRoot)).randomSeed(state.getSeed())).pointStoreView(context.getPointStore())).nodeStore(nodeStore)).centerOfMassEnabled(state.isCenterOfMassEnabled())).outputAfter(state.getOutputAfter())).build();
        return tree;
    }

    @Override
    public CompactRandomCutTreeState toState(RandomCutTree model) {
        CompactRandomCutTreeState state = new CompactRandomCutTreeState();
        state.setVersion("3.0");
        int root = model.getRoot();
        AbstractNodeStoreMapper nodeStoreMapper = new AbstractNodeStoreMapper();
        nodeStoreMapper.setRoot(root);
        state.setNodeStoreState(nodeStoreMapper.toState(model.getNodeStore()));
        if (root != AbstractNodeStore.Null && root < model.getNumberOfLeaves() - 1) {
            root = 0;
        }
        state.setRoot(root);
        state.setMaxSize(model.getNumberOfLeaves());
        state.setPartialTreeState(true);
        state.setStoreSequenceIndexesEnabled(model.isStoreSequenceIndexesEnabled());
        state.setCenterOfMassEnabled(model.isCenterOfMassEnabled());
        state.setBoundingBoxCacheFraction(model.getBoundingBoxCacheFraction());
        state.setOutputAfter(model.getOutputAfter());
        state.setSeed(model.getRandomSeed());
        state.setDimensions(model.getDimension());
        return state;
    }
}

