/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.util.Arrays;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.AccessorPrototype;
import oracle.jdbc.driver.ByteArray;
import oracle.jdbc.driver.LobCommonAccessor;

abstract class LobCommonAccessorPrototype
extends AccessorPrototype {
    long[] prefetchedDataOffset;
    int[] prefetchedDataLength;
    long[] prefetchedLength;
    int[] prefetchedChunkSize;
    boolean isDMLReturnedParam = false;
    int lobPrefetchSizeForThisColumn = -1;

    protected LobCommonAccessorPrototype(int numRows, LobCommonAccessor acc, ByteArray stmtRowData) {
        super(numRows, acc, stmtRowData);
        this.prefetchedDataOffset = Arrays.copyOfRange(acc.prefetchedDataOffset, 0, numRows);
        this.prefetchedDataLength = Arrays.copyOfRange(acc.prefetchedDataLength, 0, numRows);
        this.prefetchedLength = Arrays.copyOfRange(acc.prefetchedLength, 0, numRows);
        this.prefetchedChunkSize = Arrays.copyOfRange(acc.prefetchedChunkSize, 0, numRows);
        this.isDMLReturnedParam = acc.isDMLReturnedParam;
        this.lobPrefetchSizeForThisColumn = acc.lobPrefetchSizeForThisColumn;
    }

    @Override
    protected void initializeRowData(Accessor acc) {
        super.initializeRowData(acc);
        if (acc instanceof LobCommonAccessor) {
            LobCommonAccessor lobAccessor = (LobCommonAccessor)acc;
            lobAccessor.isDMLReturnedParam = this.isDMLReturnedParam;
            lobAccessor.lobPrefetchSizeForThisColumn = this.lobPrefetchSizeForThisColumn;
            lobAccessor.prefetchedDataOffset = this.prefetchedDataOffset;
            lobAccessor.prefetchedDataLength = this.prefetchedDataLength;
            lobAccessor.prefetchedLength = this.prefetchedLength;
            lobAccessor.prefetchedChunkSize = this.prefetchedChunkSize;
        }
    }
}

