/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.pipeline.metadata;

import java.io.File;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeysKt;
import org.jetbrains.kotlin.cli.metadata.MetadataUtilsKt;
import org.jetbrains.kotlin.cli.pipeline.CheckCompilationErrors;
import org.jetbrains.kotlin.cli.pipeline.PerformanceNotifications;
import org.jetbrains.kotlin.cli.pipeline.PipelinePhase;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataInMemorySerializationArtifact;
import org.jetbrains.kotlin.cli.pipeline.metadata.MetadataSerializationArtifact;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataKlibFileWriterPhase;", "Lorg/jetbrains/kotlin/cli/pipeline/PipelinePhase;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataInMemorySerializationArtifact;", "Lorg/jetbrains/kotlin/cli/pipeline/metadata/MetadataSerializationArtifact;", "<init>", "()V", "executePhase", "input", "cli"})
public final class MetadataKlibFileWriterPhase
extends PipelinePhase<MetadataInMemorySerializationArtifact, MetadataSerializationArtifact> {
    @NotNull
    public static final MetadataKlibFileWriterPhase INSTANCE = new MetadataKlibFileWriterPhase();

    private MetadataKlibFileWriterPhase() {
        Function3[] function3Array = new Function3[]{PerformanceNotifications.KlibWritingFinished.INSTANCE, CheckCompilationErrors.CheckDiagnosticCollector.INSTANCE};
        super("MetadataKlibFileWriterPhase", SetsKt.setOf(PerformanceNotifications.KlibWritingStarted.INSTANCE), SetsKt.setOf(function3Array));
    }

    @Override
    @NotNull
    public MetadataSerializationArtifact executePhase(@NotNull MetadataInMemorySerializationArtifact input) {
        Intrinsics.checkNotNullParameter(input, "input");
        File file = CLIConfigurationKeysKt.getMetadataDestinationDirectory(input.getConfiguration());
        Intrinsics.checkNotNull(file);
        File destDir = file;
        MetadataUtilsKt.buildKotlinMetadataLibrary(input.getConfiguration(), input.getMetadata(), destDir);
        CompilerConfiguration compilerConfiguration = input.getConfiguration();
        String string = destDir.getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue(string, "getCanonicalPath(...)");
        return new MetadataSerializationArtifact(null, compilerConfiguration, string);
    }
}

