/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.keycloak.metrics;

import org.jboss.aerogear.keycloak.metrics.PrometheusExporter;
import org.jboss.logging.Logger;
import org.keycloak.events.Event;
import org.keycloak.events.EventListenerProvider;
import org.keycloak.events.admin.AdminEvent;
import org.keycloak.models.RealmProvider;

public class MetricsEventListener
implements EventListenerProvider {
    public static final String ID = "metrics-listener";
    private static final Logger logger = Logger.getLogger(MetricsEventListener.class);
    private final RealmProvider realmProvider;

    public MetricsEventListener(RealmProvider realmProvider) {
        this.realmProvider = realmProvider;
    }

    public void onEvent(Event event) {
        this.logEventDetails(event);
        switch (event.getType()) {
            case LOGIN: {
                PrometheusExporter.instance().recordLogin(event, this.realmProvider);
                break;
            }
            case CLIENT_LOGIN: {
                PrometheusExporter.instance().recordClientLogin(event, this.realmProvider);
                break;
            }
            case REGISTER: {
                PrometheusExporter.instance().recordRegistration(event, this.realmProvider);
                break;
            }
            case REFRESH_TOKEN: {
                PrometheusExporter.instance().recordRefreshToken(event, this.realmProvider);
                break;
            }
            case CODE_TO_TOKEN: {
                PrometheusExporter.instance().recordCodeToToken(event, this.realmProvider);
                break;
            }
            case REGISTER_ERROR: {
                PrometheusExporter.instance().recordRegistrationError(event, this.realmProvider);
                break;
            }
            case LOGIN_ERROR: {
                PrometheusExporter.instance().recordLoginError(event, this.realmProvider);
                break;
            }
            case CLIENT_LOGIN_ERROR: {
                PrometheusExporter.instance().recordClientLoginError(event, this.realmProvider);
                break;
            }
            case REFRESH_TOKEN_ERROR: {
                PrometheusExporter.instance().recordRefreshTokenError(event, this.realmProvider);
                break;
            }
            case CODE_TO_TOKEN_ERROR: {
                PrometheusExporter.instance().recordCodeToTokenError(event, this.realmProvider);
                break;
            }
            default: {
                PrometheusExporter.instance().recordGenericEvent(event, this.realmProvider);
            }
        }
    }

    public void onEvent(AdminEvent event, boolean includeRepresentation) {
        this.logAdminEventDetails(event);
        PrometheusExporter.instance().recordGenericAdminEvent(event, this.realmProvider);
    }

    private void logEventDetails(Event event) {
        logger.debugf("Received user event of type %s in realm %s", (Object)event.getType().name(), (Object)event.getRealmId());
    }

    private void logAdminEventDetails(AdminEvent event) {
        logger.debugf("Received admin event of type %s (%s) in realm %s", (Object)event.getOperationType().name(), (Object)event.getResourceType().name(), (Object)event.getRealmId());
    }

    public void close() {
    }
}

