/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.runtime.filters.accesslog;

import io.quarkus.vertx.http.runtime.attribute.ExchangeAttribute;
import io.quarkus.vertx.http.runtime.attribute.ExchangeAttributeParser;
import io.quarkus.vertx.http.runtime.attribute.SubstituteEmptyWrapper;
import io.quarkus.vertx.http.runtime.filters.OriginalRequestContext;
import io.quarkus.vertx.http.runtime.filters.QuarkusRequestWrapper;
import io.quarkus.vertx.http.runtime.filters.accesslog.AccessLogReceiver;
import io.vertx.core.Handler;
import io.vertx.ext.web.RoutingContext;
import java.util.Collections;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AccessLogHandler
implements Handler<RoutingContext> {
    private final AccessLogReceiver accessLogReceiver;
    private final String formatString;
    private final boolean consolidateReroutedRequests;
    private final ExchangeAttribute tokens;
    private final Pattern excludePattern;

    public AccessLogHandler(AccessLogReceiver accessLogReceiver, String formatString, boolean consolidateReroutedRequests, ClassLoader classLoader, Optional<String> excludePattern) {
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.consolidateReroutedRequests = consolidateReroutedRequests;
        this.tokens = new ExchangeAttributeParser(classLoader, Collections.singletonList(new SubstituteEmptyWrapper("-"))).parse(this.formatString);
        this.excludePattern = excludePattern.isPresent() ? Pattern.compile(excludePattern.get()) : null;
    }

    public AccessLogHandler(AccessLogReceiver accessLogReceiver, String formatString, boolean consolidateReroutedRequests, ExchangeAttribute attribute) {
        this.accessLogReceiver = accessLogReceiver;
        this.formatString = AccessLogHandler.handleCommonNames(formatString);
        this.consolidateReroutedRequests = consolidateReroutedRequests;
        this.tokens = attribute;
        this.excludePattern = null;
    }

    private static String handleCommonNames(String formatString) {
        switch (formatString) {
            case "common": {
                return "%h %l %u %t \"%r\" %s %b";
            }
            case "combined": {
                return "%h %l %u %t \"%r\" %s %b \"%{i,Referer}\" \"%{i,User-Agent}\"";
            }
            case "long": {
                return new StringJoiner(System.lineSeparator(), System.lineSeparator(), "").add("%r").add("%{ALL_REQUEST_HEADERS}").toString();
            }
        }
        return formatString;
    }

    public void handle(final RoutingContext rc) {
        Matcher m;
        if (this.excludePattern != null && (m = this.excludePattern.matcher(rc.request().path())).matches()) {
            rc.next();
            return;
        }
        if (this.consolidateReroutedRequests && rc.get("originalRequestContext", null) != null) {
            rc.next();
            return;
        }
        QuarkusRequestWrapper.get(rc.request()).addRequestDoneHandler(new Handler<Void>(){

            public void handle(Void event) {
                AccessLogHandler.this.accessLogReceiver.logMessage(AccessLogHandler.this.tokens.readAttribute(rc));
            }
        });
        if (this.consolidateReroutedRequests) {
            rc.put("originalRequestContext", (Object)new OriginalRequestContext(rc));
        }
        rc.next();
    }

    public String toString() {
        return "AccessLogHandler{formatString='" + this.formatString + "'}";
    }
}

