/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import jakarta.persistence.AccessType;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.property.access.internal.PropertyAccessEnhancedImpl;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;

public class PropertyAccessStrategyEnhancedImpl
implements PropertyAccessStrategy {
    private final @Nullable AccessType classAccessType;
    public static PropertyAccessStrategy STANDARD = new PropertyAccessStrategyEnhancedImpl(null);
    public static PropertyAccessStrategy FIELD = new PropertyAccessStrategyEnhancedImpl(AccessType.FIELD);
    public static PropertyAccessStrategy PROPERTY = new PropertyAccessStrategyEnhancedImpl(AccessType.PROPERTY);

    public static PropertyAccessStrategy with(AccessType getterAccessType) {
        PropertyAccessStrategy propertyAccessStrategy;
        if (getterAccessType == null) {
            propertyAccessStrategy = STANDARD;
        } else {
            switch (getterAccessType) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case FIELD: {
                    propertyAccessStrategy = FIELD;
                    break;
                }
                case PROPERTY: {
                    propertyAccessStrategy = PROPERTY;
                }
            }
        }
        return propertyAccessStrategy;
    }

    public PropertyAccessStrategyEnhancedImpl(@Nullable AccessType classAccessType) {
        this.classAccessType = classAccessType;
    }

    @Override
    public PropertyAccess buildPropertyAccess(Class<?> containerJavaType, String propertyName, boolean setterRequired) {
        return new PropertyAccessEnhancedImpl(this, containerJavaType, propertyName, this.classAccessType);
    }
}

