/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.jpa.entities;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.Id;
import jakarta.persistence.IdClass;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.io.Serializable;
import org.keycloak.models.jpa.entities.UserEntity;

@NamedQueries(value={@NamedQuery(name="deleteUserRequiredActionsByRealm", query="delete from UserRequiredActionEntity action where action.user IN (select u from UserEntity u where u.realmId=:realmId)"), @NamedQuery(name="deleteUserRequiredActionsByRealmAndLink", query="delete from UserRequiredActionEntity action where action.user IN (select u from UserEntity u where u.realmId=:realmId and u.federationLink=:link)")})
@Entity
@Table(name="USER_REQUIRED_ACTION")
@IdClass(value=Key.class)
public class UserRequiredActionEntity {
    @Id
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="USER_ID")
    protected UserEntity user;
    @Id
    @Column(name="REQUIRED_ACTION")
    protected String action;

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public UserEntity getUser() {
        return this.user;
    }

    public void setUser(UserEntity user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!(o instanceof UserRequiredActionEntity)) {
            return false;
        }
        UserRequiredActionEntity key = (UserRequiredActionEntity)o;
        if (this.action != key.action) {
            return false;
        }
        return !(this.user != null ? !this.user.getId().equals(key.user != null ? key.user.getId() : null) : key.user != null);
    }

    public int hashCode() {
        int result = this.user != null ? this.user.getId().hashCode() : 0;
        result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
        return result;
    }

    public static class Key
    implements Serializable {
        protected UserEntity user;
        protected String action;

        public Key() {
        }

        public Key(UserEntity user, String action) {
            this.user = user;
            this.action = action;
        }

        public UserEntity getUser() {
            return this.user;
        }

        public String getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.action != key.action) {
                return false;
            }
            return !(this.user != null ? !this.user.getId().equals(key.user != null ? key.user.getId() : null) : key.user != null);
        }

        public int hashCode() {
            int result = this.user != null ? this.user.getId().hashCode() : 0;
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            return result;
        }
    }
}

