/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.openstreetmap.josm.data.coor.ILatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxImageCorrelationSettings;
import org.openstreetmap.josm.data.gpx.GpxImageDatumSettings;
import org.openstreetmap.josm.data.gpx.GpxImageDirectionPositionSettings;
import org.openstreetmap.josm.data.gpx.GpxImageEntry;
import org.openstreetmap.josm.data.gpx.IGpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.TimeSource;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class GpxImageCorrelation {
    private GpxImageCorrelation() {
    }

    public static int matchGpxTrack(List<? extends GpxImageEntry> images, GpxData selectedGpx, GpxImageCorrelationSettings settings) {
        int trkTime;
        int trkDist;
        int trkTagTime;
        int segTime;
        int segDist;
        int segTagTime;
        boolean trkInt;
        boolean trkTag;
        boolean segInt;
        boolean segTag;
        int ret = 0;
        if (Logging.isDebugEnabled()) {
            Logging.debug("Correlating {0} images to {1} GPX track segments using {2}", images.size(), selectedGpx.getTrackSegsCount(), settings);
        }
        if (settings.isForceTags()) {
            segTag = true;
            segInt = true;
            trkTag = true;
            trkInt = true;
            segTagTime = Integer.MAX_VALUE;
            segDist = Integer.MAX_VALUE;
            segTime = Integer.MAX_VALUE;
            trkTagTime = Integer.MAX_VALUE;
            trkDist = Integer.MAX_VALUE;
            trkTime = Integer.MAX_VALUE;
        } else {
            trkInt = Config.getPref().getBoolean("geoimage.trk.int", false);
            trkTime = Config.getPref().getBoolean("geoimage.trk.int.time", false) ? Config.getPref().getInt("geoimage.trk.int.time.val", 60) : Integer.MAX_VALUE;
            trkDist = Config.getPref().getBoolean("geoimage.trk.int.dist", false) ? Config.getPref().getInt("geoimage.trk.int.dist.val", 50) : Integer.MAX_VALUE;
            trkTag = Config.getPref().getBoolean("geoimage.trk.tag", true);
            trkTagTime = Config.getPref().getBoolean("geoimage.trk.tag.time", true) ? Config.getPref().getInt("geoimage.trk.tag.time.val", 2) : Integer.MAX_VALUE;
            segInt = Config.getPref().getBoolean("geoimage.seg.int", true);
            segTime = Config.getPref().getBoolean("geoimage.seg.int.time", true) ? Config.getPref().getInt("geoimage.seg.int.time.val", 60) : Integer.MAX_VALUE;
            segDist = Config.getPref().getBoolean("geoimage.seg.int.dist", true) ? Config.getPref().getInt("geoimage.seg.int.dist.val", 50) : Integer.MAX_VALUE;
            segTag = Config.getPref().getBoolean("geoimage.seg.tag", true);
            segTagTime = Config.getPref().getBoolean("geoimage.seg.tag.time", true) ? Config.getPref().getInt("geoimage.seg.tag.time.val", 2) : Integer.MAX_VALUE;
        }
        GpxImageDirectionPositionSettings dirpos = settings.getDirectionPositionSettings();
        GpxImageDatumSettings datumSettings = settings.getDatumSettings();
        long offset = settings.getOffset();
        TimeSource imgTimeSource = settings.getImgTimeSource();
        boolean isFirst = true;
        long prevWpTime = 0L;
        ILatLon prevWp = null;
        for (List<List<WayPoint>> segs : GpxImageCorrelation.loadTracks(selectedGpx.getTracks())) {
            boolean firstSegment = true;
            block1: for (List<WayPoint> wps : segs) {
                int size = wps.size();
                for (int i = 0; i < size; ++i) {
                    WayPoint curWp = wps.get(i);
                    if (!curWp.hasDate()) {
                        if (i <= 0 || !wps.get(i - 1).hasDate()) continue;
                        long prevWpTimeNoOffset = wps.get(i - 1).getTimeInMillis();
                        double totalDist = 0.0;
                        ArrayList<Pair<Double, WayPoint>> nextWps = new ArrayList<Pair<Double, WayPoint>>();
                        for (int j = i; j < size; ++j) {
                            nextWps.add(new Pair<Double, WayPoint>(totalDist += wps.get(j - 1).greatCircleDistance(wps.get(j)), wps.get(j)));
                            if (!wps.get(j).hasDate()) continue;
                            long timeDiff = wps.get(j).getTimeInMillis() - prevWpTimeNoOffset;
                            for (Pair pair : nextWps) {
                                ((WayPoint)pair.b).setTimeInMillis((long)((double)prevWpTimeNoOffset + (double)timeDiff * ((Double)pair.a / totalDist)));
                            }
                            break;
                        }
                        if (!curWp.hasDate()) continue block1;
                    }
                    long curWpTime = curWp.getTimeInMillis() + offset;
                    boolean interpolate = true;
                    int tagTime = 0;
                    if (i == 0) {
                        if (firstSegment) {
                            firstSegment = false;
                            if (!trkInt || isFirst || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(trkTime) || prevWp.greatCircleDistance(curWp) > (double)trkDist) {
                                isFirst = false;
                                interpolate = false;
                                if (trkTag) {
                                    tagTime = trkTagTime;
                                }
                            }
                        } else if (!segInt || prevWp == null || Math.abs(curWpTime - prevWpTime) > TimeUnit.MINUTES.toMillis(segTime) || prevWp.greatCircleDistance(curWp) > (double)segDist) {
                            interpolate = false;
                            if (segTag) {
                                tagTime = segTagTime;
                            }
                        }
                    }
                    WayPoint nextWp = i < size - 1 ? wps.get(i + 1) : null;
                    ret += GpxImageCorrelation.matchPoints(images, (WayPoint)prevWp, prevWpTime, curWp, curWpTime, imgTimeSource, offset, interpolate, tagTime, nextWp, dirpos, datumSettings);
                    prevWp = curWp;
                    prevWpTime = curWpTime;
                }
            }
        }
        if (trkTag && prevWp != null) {
            ret += GpxImageCorrelation.matchPoints(images, prevWp, prevWpTime, prevWp, prevWpTime, imgTimeSource, offset, false, trkTagTime, null, dirpos, datumSettings);
        }
        Logging.debug("Correlated {0} total points", ret);
        return ret;
    }

    static List<List<List<WayPoint>>> loadTracks(Collection<IGpxTrack> tracks) {
        ArrayList<List<List<WayPoint>>> trks = new ArrayList<List<List<WayPoint>>>();
        for (IGpxTrack trk : tracks) {
            ArrayList segs = new ArrayList();
            for (IGpxTrackSegment seg : trk.getSegments()) {
                int wp;
                ArrayList<WayPoint> wps = new ArrayList<WayPoint>(seg.getWayPoints());
                if (wps.isEmpty()) continue;
                for (wp = 0; wp < wps.size() && !((WayPoint)wps.get(wp)).hasDate(); ++wp) {
                }
                if (wp == 0) {
                    segs.add(wps);
                    continue;
                }
                if (wp >= wps.size()) continue;
                segs.add(wps.subList(wp, wps.size()));
            }
            if (segs.isEmpty()) continue;
            segs.sort((o1, o2) -> {
                if (o1.isEmpty() || o2.isEmpty()) {
                    return 0;
                }
                return ((WayPoint)o1.get(0)).compareTo((WayPoint)o2.get(0));
            });
            trks.add(segs);
        }
        trks.sort((o1, o2) -> {
            if (o1.isEmpty() || ((List)o1.get(0)).isEmpty() || o2.isEmpty() || ((List)o2.get(0)).isEmpty()) {
                return 0;
            }
            return ((WayPoint)((List)o1.get(0)).get(0)).compareTo((WayPoint)((List)o2.get(0)).get(0));
        });
        return trks;
    }

    static Double getElevation(WayPoint wp) {
        String value;
        if (wp != null && !Utils.isEmpty(value = wp.getString("ele"))) {
            try {
                return Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                Logging.warn(e);
            }
        }
        return null;
    }

    static Double getHPosErr(WayPoint wp) {
        if (wp != null) {
            Double hposerr;
            if (wp.attr.get("stdhdev") instanceof Float) {
                Float hposerr2 = (Float)wp.attr.get("stdhdev");
                if (hposerr2 != null) {
                    return hposerr2.doubleValue();
                }
            } else if (wp.attr.get("stdhdev") instanceof Double && (hposerr = (Double)wp.attr.get("stdhdev")) != null) {
                return hposerr;
            }
        }
        return null;
    }

    static Double getGpsDop(WayPoint wp) {
        if (wp != null) {
            if (wp.attr.get("pdop") != null) {
                if (wp.attr.get("pdop") instanceof Float) {
                    Float pdopvalue = (Float)wp.attr.get("pdop");
                    return pdopvalue.doubleValue();
                }
                if (wp.attr.get("pdop") instanceof Double) {
                    return (Double)wp.attr.get("pdop");
                }
            } else if (wp.attr.get("hdop") != null) {
                if (wp.attr.get("hdop") instanceof Float) {
                    Float hdopvalue = (Float)wp.attr.get("hdop");
                    return hdopvalue.doubleValue();
                }
                if (wp.attr.get("hdop") instanceof Double) {
                    return (Double)wp.attr.get("hdop");
                }
            }
        }
        return null;
    }

    static Double getGpsTrack(WayPoint wp) {
        if (wp != null) {
            String trackvalue = wp.getString("course");
            Logging.debug("track angle value: {0}", trackvalue);
            if (!Utils.isEmpty(trackvalue)) {
                try {
                    return Double.valueOf(trackvalue);
                }
                catch (NumberFormatException e) {
                    Logging.warn(e);
                }
            }
        }
        return null;
    }

    static String getGpsProcMethod(String prevGpsFixMode, String curGpsFixMode, List<String> positioningModes) {
        Object gpsProcMethod = null;
        Integer lowestProcIndex = null;
        int lowestGnssModeIdx = 3;
        try {
            lowestProcIndex = Math.min(positioningModes.indexOf(prevGpsFixMode), positioningModes.indexOf(curGpsFixMode));
            if (lowestProcIndex < 0) {
                return null;
            }
            gpsProcMethod = "GNSS " + positioningModes.get(lowestProcIndex).toUpperCase(Locale.ENGLISH) + " CORRELATION";
            gpsProcMethod = lowestProcIndex < lowestGnssModeIdx ? positioningModes.get(lowestProcIndex).toUpperCase(Locale.ENGLISH) + " CORRELATION" : "GNSS " + positioningModes.get(lowestProcIndex).toUpperCase(Locale.ENGLISH) + " CORRELATION";
            gpsProcMethod = ((String)gpsProcMethod).replace("FLOAT RTK", "RTK_FLOAT");
            gpsProcMethod = ((String)gpsProcMethod).replace(" RTK ", " RTK_FIX ");
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            Logging.warn(ex);
        }
        return gpsProcMethod;
    }

    static Integer getGps2d3dMode(String prevGpsFixMode, String curGpsFixMode, List<String> positioningModes) {
        Integer lowestMode = null;
        lowestMode = Math.min(positioningModes.indexOf(prevGpsFixMode), positioningModes.indexOf(curGpsFixMode));
        if (lowestMode > 3) {
            return 3;
        }
        if (lowestMode > 2) {
            return 2;
        }
        return null;
    }

    private static int matchPoints(List<? extends GpxImageEntry> images, WayPoint prevWp, long prevWpTime, WayPoint curWp, long curWpTime, TimeSource imgTimeSource, long offset, boolean interpolate, int tagTime, WayPoint nextWp, GpxImageDirectionPositionSettings dirpos, GpxImageDatumSettings datumSettings) {
        boolean isLast = nextWp == null;
        int i = isLast ? images.size() - 1 : GpxImageCorrelation.getLastIndexOfListBefore(images, curWpTime, imgTimeSource);
        if (Logging.isDebugEnabled()) {
            Logging.debug("Correlating images for i={1} - curWp={2}/{3} - prevWp={4}/{5} - nextWp={6} - tagTime={7} - interpolate={8}", i, curWp, curWpTime, prevWp, prevWpTime, nextWp, tagTime, interpolate);
        }
        if (i < 0) {
            Logging.debug("Correlated nothing, no photos match");
            return 0;
        }
        int ret = 0;
        Double speed = null;
        Double prevElevation = null;
        Double prevHPosErr = null;
        Double prevGpsDop = null;
        Double prevGpsTrack = null;
        String prevGpsFixMode = null;
        List<String> diffMode = Arrays.asList("dgps", "float rtk", "rtk");
        List<String> positioningModes = Arrays.asList("none", "manual", "estimated", "2d", "3d", "dgps", "float rtk", "rtk");
        if (prevWp != null && interpolate) {
            double distance = prevWp.greatCircleDistance(curWp);
            if (curWpTime > prevWpTime) {
                speed = 3600.0 * distance / (double)(curWpTime - prevWpTime);
            }
            prevElevation = GpxImageCorrelation.getElevation(prevWp);
            prevHPosErr = GpxImageCorrelation.getHPosErr(prevWp);
            prevGpsDop = GpxImageCorrelation.getGpsDop(prevWp);
            prevGpsTrack = GpxImageCorrelation.getGpsTrack(prevWp);
            prevGpsFixMode = prevWp.getString("fix");
        }
        Double curElevation = GpxImageCorrelation.getElevation(curWp);
        Double curHPosErr = GpxImageCorrelation.getHPosErr(curWp);
        Double curGpsDop = GpxImageCorrelation.getGpsDop(curWp);
        Double curGpsTrack = GpxImageCorrelation.getGpsTrack(curWp);
        String curGpsFixMode = curWp.getString("fix");
        if (!interpolate || isLast) {
            long half = Math.abs(curWpTime - prevWpTime) / 2L;
            while (i >= 0) {
                GpxImageEntry curImg = images.get(i);
                GpxImageEntry curTmp = curImg.getTmp();
                long time = curImg.getTimeSourceInstant(imgTimeSource).toEpochMilli();
                if ((isLast || time <= curWpTime) && time >= prevWpTime) {
                    long tagms = TimeUnit.MINUTES.toMillis(tagTime);
                    if (!(curTmp.hasNewGpsData() || Math.abs(time - curWpTime) > tagms && Math.abs(prevWpTime - time) > tagms)) {
                        if (prevWp != null && time < curWpTime - half) {
                            curTmp.setPos(prevWp.getCoor());
                        } else {
                            curTmp.setPos(curWp.getCoor());
                        }
                        if (nextWp != null && dirpos.isSetImageDirection()) {
                            double direction = curWp.bearing(nextWp);
                            curTmp.setExifImgDir(GpxImageCorrelation.computeDirection(direction, dirpos.getImageDirectionAngleOffset()));
                        }
                        curTmp.setGpsTime(curImg.getExifInstant().minusMillis(offset));
                        curTmp.flagNewGpsData();
                        curImg.tmpUpdated();
                        ++ret;
                    }
                    --i;
                    continue;
                }
                break;
            }
        } else if (prevWp != null) {
            GpxImageEntry curImg;
            long imgTime;
            LatLon nextCoorForDirection = nextWp.getCoor();
            while (i >= 0 && (imgTime = (curImg = images.get(i)).getTimeSourceInstant(imgTimeSource).toEpochMilli()) >= prevWpTime) {
                GpxImageEntry curTmp = curImg.getTmp();
                if (!curTmp.hasNewGpsData()) {
                    String gpsProcMethod;
                    Integer gps2d3dMode;
                    double timeDiff = (double)(imgTime - prevWpTime) / (double)Math.abs(curWpTime - prevWpTime);
                    boolean shiftXY = dirpos.getShiftImageX() != 0.0 || dirpos.getShiftImageY() != 0.0;
                    LatLon prevCoor = prevWp.getCoor();
                    LatLon curCoor = curWp.getCoor();
                    LatLon position = prevCoor.interpolate(curCoor, timeDiff);
                    if (nextCoorForDirection != null && (shiftXY || dirpos.isSetImageDirection())) {
                        double direction = position.bearing(nextCoorForDirection);
                        if (dirpos.isSetImageDirection()) {
                            curTmp.setExifImgDir(GpxImageCorrelation.computeDirection(direction, dirpos.getImageDirectionAngleOffset()));
                        }
                        if (shiftXY) {
                            Projection proj = ProjectionRegistry.getProjection();
                            double offsetX = dirpos.getShiftImageX();
                            double offsetY = dirpos.getShiftImageY();
                            double r = Math.sqrt(offsetX * offsetX + offsetY * offsetY);
                            double orientation = (direction + LatLon.ZERO.bearing(new LatLon(offsetX, offsetY))) % (Math.PI * 2);
                            position = proj.eastNorth2latlon(proj.latlon2eastNorth(position).add(r * Math.sin(orientation), r * Math.cos(orientation)));
                        }
                    }
                    curTmp.setPos(position);
                    curTmp.setSpeed(speed);
                    if (curElevation != null && prevElevation != null) {
                        curTmp.setElevation(prevElevation + (curElevation - prevElevation) * timeDiff + dirpos.getElevationShift());
                    }
                    if (curHPosErr != null && prevHPosErr != null) {
                        Double interpolatedValue = prevHPosErr + (curHPosErr - prevHPosErr) * timeDiff;
                        curTmp.setExifHPosErr((double)Math.round(interpolatedValue * 10000.0) / 10000.0);
                    }
                    if (prevGpsFixMode != null) {
                        if (diffMode.contains(prevGpsFixMode) && diffMode.contains(curGpsFixMode)) {
                            curTmp.setGpsDiffMode(1);
                        } else {
                            curTmp.setGpsDiffMode(0);
                        }
                    }
                    if (prevGpsFixMode != null && curGpsFixMode != null && (gps2d3dMode = GpxImageCorrelation.getGps2d3dMode(prevGpsFixMode, curGpsFixMode, positioningModes)) != null) {
                        curTmp.setGps2d3dMode(gps2d3dMode);
                    }
                    if (prevGpsFixMode != null && curGpsFixMode != null && (gpsProcMethod = GpxImageCorrelation.getGpsProcMethod(prevGpsFixMode, curGpsFixMode, positioningModes)) != null) {
                        curTmp.setExifGpsProcMethod(gpsProcMethod);
                    }
                    if (curGpsDop != null && prevGpsDop != null) {
                        Double interpolatedValue = prevGpsDop + (curGpsDop - prevGpsDop) * timeDiff;
                        curTmp.setExifGpsDop((double)Math.round(interpolatedValue * 100.0) / 100.0);
                    }
                    if (dirpos.isSetGpxTrackDirection() && curGpsTrack != null && prevGpsTrack != null) {
                        curTmp.setExifGpsTrack(prevGpsTrack + (curGpsTrack - prevGpsTrack) * timeDiff);
                    }
                    if (datumSettings.isSetImageGpsDatum()) {
                        if (diffMode.contains(prevGpsFixMode) && diffMode.contains(curGpsFixMode)) {
                            curTmp.setExifGpsDatum(datumSettings.getImageGpsDatum());
                        } else {
                            curTmp.setExifGpsDatum("WGS-84");
                        }
                    }
                    curTmp.setGpsTime(curImg.getTimeSourceInstant(imgTimeSource).minusMillis(offset));
                    curTmp.flagNewGpsData();
                    curImg.tmpUpdated();
                    nextCoorForDirection = curCoor;
                    ++ret;
                }
                --i;
            }
        }
        Logging.debug("Correlated {0} image(s)", ret);
        return ret;
    }

    private static double computeDirection(double direction, double angleOffset) {
        return (Utils.toDegrees(direction) + angleOffset) % 360.0;
    }

    private static int getLastIndexOfListBefore(List<? extends GpxImageEntry> images, long searchedTime, TimeSource imgTimeSource) {
        int lstSize = images.size();
        if (lstSize == 0 || searchedTime < images.get(0).getTimeSourceInstant(imgTimeSource).toEpochMilli()) {
            return -1;
        }
        if (searchedTime > images.get(lstSize - 1).getTimeSourceInstant(imgTimeSource).toEpochMilli()) {
            return lstSize - 1;
        }
        int startIndex = 0;
        int endIndex = lstSize - 1;
        while (endIndex - startIndex > 1) {
            int curIndex = (endIndex + startIndex) / 2;
            if (searchedTime > images.get(curIndex).getTimeSourceInstant(imgTimeSource).toEpochMilli()) {
                startIndex = curIndex;
                continue;
            }
            endIndex = curIndex;
        }
        if (searchedTime < images.get(endIndex).getTimeSourceInstant(imgTimeSource).toEpochMilli()) {
            return startIndex;
        }
        while (endIndex < lstSize - 1 && images.get(endIndex).getTimeSourceInstant(imgTimeSource).toEpochMilli() == images.get(endIndex + 1).getTimeSourceInstant(imgTimeSource).toEpochMilli()) {
            ++endIndex;
        }
        return endIndex;
    }
}

