#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 uuid-types
version:              1.0.6
visibility:           public
id:                   uuid-types-1.0.6-7gx1lcEyzTzHtsXguSIhiO
key:                  uuid-types-1.0.6-7gx1lcEyzTzHtsXguSIhiO
license:              BSD-3-Clause
copyright:
    (c) 2017-2018 Herbert Valerio Riedel
    (c) 2008-2014 Antoine Latter

maintainer:           Oleg Grenrus <oleg.grenrus@iki.fi>
author:               Antoine Latter
homepage:             https://github.com/haskell-hvr/uuid
synopsis:             Type definitions for Universally Unique Identifiers
description:
    This library contains type definitions for
    <https://en.wikipedia.org/wiki/UUID Universally Unique Identifiers (UUID)>
    (as specified in
    <http://tools.ietf.org/html/rfc4122 RFC 4122>)
    and basic conversion functions.

    See also the <https://hackage.haskell.org/package/uuid '\''uuid'\'' package>
    providing a high-level API for managing the different UUID versions.

category:             Data
abi:                  b66e780e3f585968f1af913e33e5f0a6
exposed:              True
exposed-modules:
    Data.UUID.Types Data.UUID.Types.Internal
    Data.UUID.Types.Internal.Builder

import-dirs:          /usr/lib/ghc-9.6.6/site-local/uuid-types-1.0.6
library-dirs:         /usr/lib/ghc-9.6.6/site-local/uuid-types-1.0.6
library-dirs-static:  /usr/lib/ghc-9.6.6/site-local/uuid-types-1.0.6
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-uuid-types
hs-libraries:         HSuuid-types-1.0.6-7gx1lcEyzTzHtsXguSIhiO
depends:
    base-4.18.2.1 binary-0.8.9.1 bytestring-0.11.5.3 deepseq-1.4.8.1
    hashable-1.4.7.0-2TMrYujL0SWBJEdw6jCOMM
    random-1.2.1.3-AWgDTzXDap9FswiKSbxZwj template-haskell-2.20.0.0
    text-2.0.2

haddock-interfaces:   /usr/share/doc/haskell-uuid-types/html/uuid-types.haddock
haddock-html:         /usr/share/doc/haskell-uuid-types/html
' | '/usr/bin/ghc-pkg-9.6.6' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

