/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.kotlin.com.intellij.codeInsight.ExceptionUtil;
import org.jetbrains.kotlin.com.intellij.core.JavaPsiBundle;
import org.jetbrains.kotlin.com.intellij.psi.LambdaUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiClassType;
import org.jetbrains.kotlin.com.intellij.psi.PsiConditionalExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLambdaExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethodReferenceExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiParameter;
import org.jetbrains.kotlin.com.intellij.psi.PsiParenthesizedExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiSubstitutor;
import org.jetbrains.kotlin.com.intellij.psi.PsiType;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.InferenceVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.InputOutputConstraintFormula;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.resolve.graphInference.constraints.StrictSubtypingConstraint;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiUtil;
import org.jetbrains.kotlin.com.intellij.psi.util.TypeConversionUtil;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class CheckedExceptionCompatibilityConstraint
extends InputOutputConstraintFormula {
    private final PsiExpression myExpression;

    public CheckedExceptionCompatibilityConstraint(PsiExpression expression2, PsiType t2) {
        super(t2);
        this.myExpression = expression2;
    }

    @Override
    public boolean reduce(InferenceSession session, List<? super ConstraintFormula> constraints) {
        block18: {
            PsiExpression body;
            PsiType type2;
            if (!PsiPolyExpressionUtil.isPolyExpression(this.myExpression)) {
                return true;
            }
            PsiType myT = this.getCurrentType();
            if (this.myExpression instanceof PsiParenthesizedExpression) {
                constraints.add(new CheckedExceptionCompatibilityConstraint(((PsiParenthesizedExpression)this.myExpression).getExpression(), myT));
                return true;
            }
            if (this.myExpression instanceof PsiConditionalExpression) {
                PsiExpression elseExpression;
                PsiExpression thenExpression = ((PsiConditionalExpression)this.myExpression).getThenExpression();
                if (thenExpression != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(thenExpression, myT));
                }
                if ((elseExpression = ((PsiConditionalExpression)this.myExpression).getElseExpression()) != null) {
                    constraints.add(new CheckedExceptionCompatibilityConstraint(elseExpression, myT));
                }
                return true;
            }
            if (!(this.myExpression instanceof PsiLambdaExpression) && !(this.myExpression instanceof PsiMethodReferenceExpression)) break block18;
            if (!LambdaUtil.isFunctionalType(myT)) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.not.a.functional.interface", session.getPresentableText(myT)));
                return false;
            }
            PsiType groundTargetType = this.myExpression instanceof PsiLambdaExpression ? FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT, (PsiLambdaExpression)this.myExpression, false) : FunctionalInterfaceParameterizationUtil.getGroundTargetType(myT);
            PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(groundTargetType);
            if (interfaceMethod == null) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.no.valid.function.type.found", session.getPresentableText(myT)));
                return false;
            }
            PsiSubstitutor substitutor2 = LambdaUtil.getSubstitutor(interfaceMethod, PsiUtil.resolveGenericsClassInType(groundTargetType));
            if (this.myExpression instanceof PsiLambdaExpression && !((PsiLambdaExpression)this.myExpression).hasFormalParameterTypes() || this.myExpression instanceof PsiMethodReferenceExpression && !((PsiMethodReferenceExpression)this.myExpression).isExact()) {
                for (PsiParameter parameter : interfaceMethod.getParameterList().getParameters()) {
                    PsiType type3 = substitutor2.substitute(parameter.getType());
                    if (session.isProperType(type3)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.parameter.type.is.not.yet.inferred", session.getPresentableText(type3)));
                    return false;
                }
            }
            PsiType returnType = interfaceMethod.getReturnType();
            if (!(!(this.myExpression instanceof PsiLambdaExpression) && ((PsiMethodReferenceExpression)this.myExpression).isExact() || session.isProperType(type2 = substitutor2.substitute(returnType)))) {
                session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.return.type.is.not.yet.inferred", session.getPresentableText(type2)));
                return false;
            }
            List<PsiType> expectedThrownTypes = ContainerUtil.map(interfaceMethod.getThrowsList().getReferencedTypes(), type -> session.substituteWithInferenceVariables(substitutor2.substitute((PsiType)type)));
            ArrayList<PsiType> expectedNonProperThrownTypes = new ArrayList<PsiType>();
            for (PsiType type3 : expectedThrownTypes) {
                if (session.isProperType(type3)) continue;
                expectedNonProperThrownTypes.add(type3);
            }
            ArrayList<PsiClassType> thrownTypes = new ArrayList<PsiClassType>();
            PsiElement psiElement = body = this.myExpression instanceof PsiLambdaExpression ? ((PsiLambdaExpression)this.myExpression).getBody() : this.myExpression;
            if (body != null) {
                List<PsiClassType> exceptions = ExceptionUtil.getUnhandledExceptions(new PsiElement[]{body});
                thrownTypes.addAll(ContainerUtil.filter(exceptions, type -> !ExceptionUtil.isUncheckedException(type)));
            }
            if (expectedNonProperThrownTypes.isEmpty()) {
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedThrownTypes, psiType)) continue;
                    session.registerIncompatibleErrorMessage(JavaPsiBundle.message("error.incompatible.type.unhandled.exception", session.getPresentableText(psiType)));
                    return false;
                }
            } else {
                ArrayList<PsiType> expectedProperTypes = new ArrayList<PsiType>(expectedThrownTypes);
                expectedProperTypes.removeAll(expectedNonProperThrownTypes);
                for (PsiType psiType : thrownTypes) {
                    if (CheckedExceptionCompatibilityConstraint.isAddressed(expectedProperTypes, psiType)) continue;
                    for (PsiType expectedNonProperThrownType : expectedNonProperThrownTypes) {
                        constraints.add(new StrictSubtypingConstraint(expectedNonProperThrownType, psiType));
                    }
                }
                for (PsiType psiType : expectedNonProperThrownTypes) {
                    InferenceVariable variable = session.getInferenceVariable(psiType);
                    if (variable == null) continue;
                    variable.setThrownBound();
                }
            }
        }
        return true;
    }

    private static boolean isAddressed(List<PsiType> expectedThrownTypes, PsiType thrownType) {
        for (PsiType expectedThrownType : expectedThrownTypes) {
            if (!TypeConversionUtil.isAssignable(expectedThrownType, thrownType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PsiExpression getExpression() {
        return this.myExpression;
    }

    @Override
    protected InputOutputConstraintFormula createSelfConstraint(PsiType type, PsiExpression expression2) {
        return new CheckedExceptionCompatibilityConstraint(expression2, type);
    }

    @Override
    protected void collectReturnTypeVariables(InferenceSession session, PsiExpression psiExpression, PsiType returnType, Set<? super InferenceVariable> result2) {
        session.collectDependencies(returnType, result2);
    }
}

