/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Interner;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.MutableVersionConstraint;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.api.attributes.Category;
import org.gradle.api.attributes.Usage;
import org.gradle.api.initialization.dsl.VersionCatalogBuilder;
import org.gradle.api.internal.artifacts.DependencyResolutionServices;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.configurations.RoleBasedConfigurationContainerInternal;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultMutableVersionConstraint;
import org.gradle.api.internal.catalog.AliasNormalizer;
import org.gradle.api.internal.catalog.BundleModel;
import org.gradle.api.internal.catalog.DefaultVersionCatalog;
import org.gradle.api.internal.catalog.DependencyModel;
import org.gradle.api.internal.catalog.PluginModel;
import org.gradle.api.internal.catalog.VersionModel;
import org.gradle.api.internal.catalog.parser.DependenciesModelHelper;
import org.gradle.api.internal.catalog.parser.StrictVersionParser;
import org.gradle.api.internal.catalog.parser.TomlCatalogFileParser;
import org.gradle.api.internal.catalog.problems.DefaultCatalogProblemBuilder;
import org.gradle.api.internal.catalog.problems.VersionCatalogProblemId;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.problems.DocLink;
import org.gradle.api.problems.Severity;
import org.gradle.api.problems.internal.GradleCoreProblemGroup;
import org.gradle.api.problems.internal.InternalProblem;
import org.gradle.api.problems.internal.InternalProblemSpec;
import org.gradle.api.problems.internal.InternalProblems;
import org.gradle.api.provider.Property;
import org.gradle.internal.FileUtils;
import org.gradle.internal.RenderingUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.classpath.Instrumented;
import org.gradle.internal.deprecation.Documentation;
import org.gradle.internal.lazy.Lazy;
import org.gradle.internal.management.VersionCatalogBuilderInternal;
import org.gradle.util.internal.TextUtil;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public abstract class DefaultVersionCatalogBuilder
implements VersionCatalogBuilderInternal {
    private static final Logger LOGGER = Logging.getLogger(DefaultVersionCatalogBuilder.class);
    public static final List<String> FORBIDDEN_LIBRARY_ALIAS_PREFIX = ImmutableList.of((Object)"bundles", (Object)"versions", (Object)"plugins");
    public static final Set<String> RESERVED_ALIAS_NAMES = ImmutableSet.of((Object)"extensions", (Object)"convention");
    public static final Set<String> RESERVED_JAVA_NAMES = ImmutableSet.of((Object)"class");
    private final Interner<String> strings;
    private final Interner<ImmutableVersionConstraint> versionConstraintInterner;
    private final ObjectFactory objects;
    private final String name;
    private final Map<String, VersionModel> versionConstraints = new LinkedHashMap<String, VersionModel>();
    private final Map<String, Supplier<DependencyModel>> libraries = new LinkedHashMap<String, Supplier<DependencyModel>>();
    private final Set<String> aliasesInProgress = new LinkedHashSet<String>();
    private final Map<String, Supplier<PluginModel>> plugins = new LinkedHashMap<String, Supplier<PluginModel>>();
    private final Map<String, BundleModel> bundles = new LinkedHashMap<String, BundleModel>();
    private final Lazy<DefaultVersionCatalog> model = Lazy.unsafe().of(this::doBuild);
    private final Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier;
    private Import importedCatalog = null;
    private final StrictVersionParser strictVersionParser;
    private final Property<String> description;
    private String currentContext;

    @Inject
    public DefaultVersionCatalogBuilder(String name, Interner<String> strings, Interner<ImmutableVersionConstraint> versionConstraintInterner, ObjectFactory objects, Supplier<DependencyResolutionServices> dependencyResolutionServicesSupplier) {
        this.name = name;
        this.strings = strings;
        this.versionConstraintInterner = versionConstraintInterner;
        this.objects = objects;
        this.dependencyResolutionServicesSupplier = dependencyResolutionServicesSupplier;
        this.strictVersionParser = new StrictVersionParser(strings);
        this.description = objects.property(String.class).convention((Object)("A catalog of dependencies accessible via the {@code " + name + "} extension."));
    }

    @Inject
    protected abstract InternalProblems getProblemsService();

    public String getLibrariesExtensionName() {
        return this.name;
    }

    public Property<String> getDescription() {
        return this.description;
    }

    @Override
    public DefaultVersionCatalog build() {
        return (DefaultVersionCatalog)this.model.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void withContext(String context, Runnable action) {
        String oldContext = this.currentContext;
        this.currentContext = this.intern(context);
        try {
            action.run();
        }
        finally {
            this.currentContext = oldContext;
        }
    }

    private DefaultVersionCatalog doBuild() {
        this.maybeImportCatalogs();
        if (!this.aliasesInProgress.isEmpty()) {
            String alias = this.aliasesInProgress.iterator().next();
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "dependency alias builder '" + alias + "' was not finished.", VersionCatalogProblemId.ALIAS_NOT_FINISHED).details("A version was not set or explicitly declared as not wanted").solution("Call `.version()` to give the alias a version").solution("Call `.withoutVersion()` to explicitly declare that the alias should not have a version")));
        }
        for (Map.Entry<String, BundleModel> entry : this.bundles.entrySet()) {
            String string = entry.getKey();
            List<String> aliases = entry.getValue().getComponents();
            for (String alias : aliases) {
                if (this.libraries.containsKey(alias)) continue;
                throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "a bundle with name '" + bundleName + "' declares a dependency on '" + alias + "' which doesn't exist.", VersionCatalogProblemId.UNDEFINED_ALIAS_REFERENCE).details("Bundles can only contain references to existing library aliases.").solution("Make sure that the library alias '" + alias + "' is declared").solution("Remove '" + alias + "' from bundle '" + bundleName + "'.")));
            }
        }
        ImmutableMap.Builder realizedLibs = ImmutableMap.builderWithExpectedSize((int)this.libraries.size());
        for (Map.Entry<String, Supplier<DependencyModel>> entry : this.libraries.entrySet()) {
            realizedLibs.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        ImmutableMap.Builder builder2 = ImmutableMap.builderWithExpectedSize((int)this.plugins.size());
        for (Map.Entry<String, Supplier<PluginModel>> entry : this.plugins.entrySet()) {
            builder2.put((Object)entry.getKey(), (Object)entry.getValue().get());
        }
        return new DefaultVersionCatalog(this.name, (String)this.description.getOrElse((Object)""), (Map<String, DependencyModel>)realizedLibs.build(), (Map<String, BundleModel>)ImmutableMap.copyOf(this.bundles), (Map<String, VersionModel>)ImmutableMap.copyOf(this.versionConstraints), (Map<String, PluginModel>)builder2.build());
    }

    private static InternalProblemSpec configureVersionCatalogError(InternalProblemSpec builder, String message, VersionCatalogProblemId catalogProblemId) {
        return builder.id(TextUtil.screamingSnakeToKebabCase((String)catalogProblemId.name()), "version catalog error", GradleCoreProblemGroup.versionCatalog()).contextualLabel(message).documentedAt((DocLink)Documentation.userManual((String)"version_catalog_problems", (String)catalogProblemId.name().toLowerCase(Locale.ROOT))).severity(Severity.ERROR);
    }

    private static RuntimeException throwVersionCatalogProblemException(InternalProblems problemsService, InternalProblem problem) {
        throw DefaultCatalogProblemBuilder.throwError((InternalProblems)problemsService, (String)"Invalid catalog definition", (Collection)ImmutableList.of((Object)problem));
    }

    private @NonNull String getProblemInVersionCatalog() {
        return DefaultCatalogProblemBuilder.getProblemInVersionCatalog((String)this.name) + ", ";
    }

    private void maybeImportCatalogs() {
        if (this.importedCatalog == null) {
            return;
        }
        DependencyResolutionServices drs = this.dependencyResolutionServicesSupplier.get();
        Configuration cnf = this.createResolvableConfiguration(drs);
        this.addImportsToResolvableConfiguration(drs, cnf, this.importedCatalog);
        Set artifacts = cnf.getIncoming().getArtifacts().getArtifacts();
        if (artifacts.size() > 1) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "importing multiple files are not supported.", VersionCatalogProblemId.TOO_MANY_IMPORT_FILES).details("The import consists of multiple files").solution("Only import a single file")));
        }
        Optional maybeResolvedArtifactResult = artifacts.stream().findFirst();
        if (!maybeResolvedArtifactResult.isPresent()) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "no files are resolved to be imported.", VersionCatalogProblemId.NO_IMPORT_FILES).details("The imported dependency doesn't resolve into any file").solution("Check the import statement, it should resolve into a single file")));
        }
        ResolvedArtifactResult resolvedArtifactResult = (ResolvedArtifactResult)maybeResolvedArtifactResult.get();
        File file = resolvedArtifactResult.getFile();
        this.withContext("catalog " + resolvedArtifactResult.getVariant().getOwner(), () -> this.importCatalogFromFile(file));
    }

    private void addImportsToResolvableConfiguration(DependencyResolutionServices drs, Configuration cnf, Import imported) {
        Object notation = imported.notation;
        Dependency dependency = drs.getDependencyHandler().create(notation);
        cnf.getDependencies().add((Object)dependency);
    }

    private Configuration createResolvableConfiguration(DependencyResolutionServices drs) {
        String confName = "incomingCatalogFor" + StringUtils.capitalize((String)this.name) + "0";
        return ((RoleBasedConfigurationContainerInternal)drs.getConfigurationContainer()).resolvableDependencyScopeLocked(confName, conf -> {
            conf.getResolutionStrategy().activateDependencyLocking();
            conf.attributes(attrs -> {
                attrs.attribute(Category.CATEGORY_ATTRIBUTE, (Object)((Category)this.objects.named(Category.class, "platform")));
                attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.objects.named(Usage.class, "version-catalog")));
            });
        });
    }

    public void from(Object dependencyNotation) {
        if (this.importedCatalog != null) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "you can only call the 'from' method a single time.", VersionCatalogProblemId.TOO_MANY_IMPORT_INVOCATION).details("The method was called more than once").solution("Remove further usages of the method call")));
        }
        this.importedCatalog = new Import(dependencyNotation);
    }

    private void importCatalogFromFile(File modelFile) {
        if (!FileUtils.hasExtensionIgnoresCase((String)modelFile.getName(), (String)"toml")) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "File " + modelFile.getName() + " isn't a supported", VersionCatalogProblemId.UNSUPPORTED_FILE_FORMAT).details("Only .toml files are allowed when importing catalogs").solution("Use a TOML file instead, with the .toml extension")));
        }
        if (!modelFile.exists()) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "import of external catalog file failed.", VersionCatalogProblemId.CATALOG_FILE_DOES_NOT_EXIST).details("File '" + modelFile + "' doesn't exist").solution("Make sure that the catalog file '" + modelFile.getName() + "' exists before importing it")));
        }
        Instrumented.fileOpened((File)modelFile, (String)this.getClass().getName());
        try {
            TomlCatalogFileParser.parse((Path)modelFile.toPath(), (VersionCatalogBuilder)this, this::getProblemsService);
        }
        catch (IOException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e);
        }
    }

    public String version(String alias, Action<? super MutableVersionConstraint> versionSpec) {
        this.validateAlias(AliasType.VERSION, alias);
        alias = this.intern(AliasNormalizer.normalize(alias));
        if (this.versionConstraints.containsKey(alias)) {
            return alias;
        }
        DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
        versionSpec.execute((Object)versionBuilder);
        ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
        this.versionConstraints.put(alias, new VersionModel(version, this.currentContext));
        return alias;
    }

    public String version(String alias, String version) {
        StrictVersionParser.RichVersion richVersion = this.strictVersionParser.parse(version);
        this.version(alias, (Action<? super MutableVersionConstraint>)((Action)vc -> {
            if (richVersion.require != null) {
                vc.require(richVersion.require);
            }
            if (richVersion.prefer != null) {
                vc.prefer(richVersion.prefer);
            }
            if (richVersion.strictly != null) {
                vc.strictly(richVersion.strictly);
            }
        }));
        return alias;
    }

    public VersionCatalogBuilder.LibraryAliasBuilder library(String alias, String group, String artifact) {
        String normalizedAlias = this.normalizeAndValidateAlias(AliasType.LIBRARY, alias);
        return (VersionCatalogBuilder.LibraryAliasBuilder)this.objects.newInstance(DefaultLibraryAliasBuilder.class, new Object[]{this, normalizedAlias, group, artifact});
    }

    public void library(String alias, String groupArtifactVersion) {
        String normalizedAlias = this.normalizeAndValidateAlias(AliasType.LIBRARY, alias);
        String[] coordinates = groupArtifactVersion.split(":");
        if (coordinates.length != 3) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "on alias '" + alias + "' notation '" + groupArtifactVersion + "' is not a valid dependency notation.", VersionCatalogProblemId.INVALID_DEPENDENCY_NOTATION).details("The 'to(String)' method only supports 'group:artifact:version' coordinates").solution("Make sure that the coordinates consist of 3 parts separated by colons, eg: my.group:artifact:1.2").solution("Use the to(group, name) method instead")));
        }
        ((DefaultLibraryAliasBuilder)this.objects.newInstance(DefaultLibraryAliasBuilder.class, new Object[]{this, normalizedAlias, coordinates[0], coordinates[1]})).version(coordinates[2]);
    }

    public VersionCatalogBuilder.PluginAliasBuilder plugin(String alias, String id) {
        String normalizedAlias = this.normalizeAndValidateAlias(AliasType.PLUGIN, alias);
        return (VersionCatalogBuilder.PluginAliasBuilder)this.objects.newInstance(DefaultPluginAliasBuilder.class, new Object[]{this, normalizedAlias, id});
    }

    private String normalizeAndValidateAlias(AliasType type, String alias) {
        this.validateAlias(type, alias);
        String normalizedAlias = AliasNormalizer.normalize(alias);
        this.validateNormalizedAlias(type, alias, normalizedAlias);
        return normalizedAlias;
    }

    private void validateNormalizedAlias(AliasType type, String alias, String normalizedAlias) {
        if (!this.aliasesInProgress.add(normalizedAlias)) {
            LOGGER.warn("Duplicate alias builder registered for {}", (Object)normalizedAlias);
        }
        if (type == AliasType.LIBRARY) {
            for (String prefix : FORBIDDEN_LIBRARY_ALIAS_PREFIX) {
                if (!normalizedAlias.equals(prefix) && !normalizedAlias.startsWith(prefix + ".")) continue;
                throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "alias '" + alias + "' is not a valid alias.", VersionCatalogProblemId.RESERVED_ALIAS_NAME).details("Prefix for dependency shouldn't be equal to '" + prefix + "'").solution("Use a different alias which prefix is not equal to " + RenderingUtils.quotedOxfordListOf(FORBIDDEN_LIBRARY_ALIAS_PREFIX, (String)"or"))));
            }
        }
        if (RESERVED_ALIAS_NAMES.contains(normalizedAlias)) {
            throw this.throwAliasCatalogException(alias, RESERVED_ALIAS_NAMES);
        }
        for (String name : normalizedAlias.split("\\.")) {
            if (!RESERVED_JAVA_NAMES.contains(name)) continue;
            throw this.throwAliasCatalogException(alias, RESERVED_JAVA_NAMES);
        }
    }

    private @NonNull RuntimeException throwAliasCatalogException(String alias, Collection<String> reservedNames) {
        throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "alias '" + alias + "' is not a valid alias.", VersionCatalogProblemId.RESERVED_ALIAS_NAME).details("Alias '" + alias + "' is a reserved name in Gradle which prevents generation of accessors.").solution("Use a different alias which doesn't contain " + DefaultVersionCatalogBuilder.getExcludedNames(reservedNames) + ".")));
    }

    public static @NonNull String getExcludedNames(Collection<String> reservedNames) {
        String namesOrName = RenderingUtils.quotedOxfordListOf(reservedNames, (String)"or");
        if (reservedNames.size() == 1) {
            return namesOrName;
        }
        return "any of " + namesOrName;
    }

    private void validateAlias(AliasType type, String value) {
        if (!DependenciesModelHelper.ALIAS_PATTERN.matcher(value).matches()) {
            throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(this.getProblemsService(), this.getProblemsService().getInternalReporter().internalCreate(builder -> DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, this.getProblemInVersionCatalog() + "invalid " + (Object)((Object)type) + " alias '" + value + "'.", VersionCatalogProblemId.INVALID_ALIAS_NOTATION).details((Object)((Object)type) + " aliases must match the following regular expression: " + "[a-z]([a-zA-Z0-9_.\\-])+").solution("Make sure the alias matches the [a-z]([a-zA-Z0-9_.\\-])+ regular expression")));
        }
    }

    public void bundle(String alias, List<String> aliases) {
        this.validateAlias(AliasType.BUNDLE, alias);
        ImmutableList components = ImmutableList.copyOf((Collection)aliases.stream().map(AliasNormalizer::normalize).map(this::intern).collect(Collectors.toList()));
        BundleModel previous = this.bundles.put(AliasNormalizer.normalize(this.intern(alias)), new BundleModel((List<String>)components, this.currentContext));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for bundle '{}': {} is replaced with {}", new Object[]{alias, previous.getComponents(), components});
        }
    }

    private @Nullable String intern(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return (String)this.strings.intern((Object)value);
    }

    public boolean containsLibraryAlias(String name) {
        return this.libraries.containsKey(name);
    }

    public String getName() {
        return this.name;
    }

    private void createAliasWithVersionRef(String alias, String group, String name, String versionRef) {
        Supplier<DependencyModel> previous = this.libraries.put(this.intern(AliasNormalizer.normalize(alias)), new VersionReferencingDependencyModel(group, name, AliasNormalizer.normalize(versionRef)));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{alias, previous.get(), this.model});
        }
    }

    private void createPluginAliasWithVersionRef(String alias, String id, String versionRef) {
        Supplier<PluginModel> previous = this.plugins.put(this.intern(AliasNormalizer.normalize(alias)), new VersionReferencingPluginModel(id, AliasNormalizer.normalize(versionRef)));
        if (previous != null) {
            LOGGER.warn("Duplicate entry for plugin '{}': {} is replaced with {}", new Object[]{alias, previous.get(), this.model});
        }
    }

    private static class Import {
        private final Object notation;

        private Import(Object notation) {
            this.notation = notation;
        }
    }

    private static enum AliasType {
        LIBRARY,
        PLUGIN,
        BUNDLE,
        VERSION,
        ALIAS;


        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    public static class DefaultLibraryAliasBuilder
    implements VersionCatalogBuilder.LibraryAliasBuilder {
        private final DefaultVersionCatalogBuilder owner;
        private final String alias;
        private final String group;
        private final String name;

        @Inject
        public DefaultLibraryAliasBuilder(DefaultVersionCatalogBuilder owner, String alias, String group, String name) {
            this.owner = owner;
            this.alias = alias;
            this.group = group;
            this.name = name;
        }

        public void version(Action<? super MutableVersionConstraint> versionSpec) {
            DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
            versionSpec.execute((Object)versionBuilder);
            this.owner.aliasesInProgress.remove(this.alias);
            ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.owner.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
            DependencyModel model = new DependencyModel(this.owner.intern(this.group), this.owner.intern(this.name), null, version, this.owner.currentContext);
            Supplier<DependencyModel> previous = this.owner.libraries.put(this.owner.intern(this.alias), () -> model);
            if (previous != null) {
                LOGGER.warn("Duplicate entry for alias '{}': {} is replaced with {}", new Object[]{this.alias, previous.get(), model});
            }
        }

        public void version(String version) {
            StrictVersionParser.RichVersion richVersion = this.owner.strictVersionParser.parse(version);
            this.version((Action<? super MutableVersionConstraint>)((Action)vc -> {
                if (richVersion.require != null) {
                    vc.require(richVersion.require);
                }
                if (richVersion.prefer != null) {
                    vc.prefer(richVersion.prefer);
                }
                if (richVersion.strictly != null) {
                    vc.strictly(richVersion.strictly);
                }
            }));
        }

        public void versionRef(String versionRef) {
            this.owner.aliasesInProgress.remove(this.alias);
            this.owner.createAliasWithVersionRef(this.alias, this.group, this.name, versionRef);
        }

        public void withoutVersion() {
            this.version("");
        }
    }

    public static class DefaultPluginAliasBuilder
    implements VersionCatalogBuilder.PluginAliasBuilder {
        private final DefaultVersionCatalogBuilder owner;
        private final String alias;
        private final String id;

        @Inject
        public DefaultPluginAliasBuilder(DefaultVersionCatalogBuilder owner, String alias, String id) {
            this.owner = owner;
            this.alias = alias;
            this.id = id;
        }

        public void version(Action<? super MutableVersionConstraint> versionSpec) {
            DefaultMutableVersionConstraint versionBuilder = new DefaultMutableVersionConstraint("");
            versionSpec.execute((Object)versionBuilder);
            this.owner.aliasesInProgress.remove(this.alias);
            ImmutableVersionConstraint version = (ImmutableVersionConstraint)this.owner.versionConstraintInterner.intern((Object)DefaultImmutableVersionConstraint.of(versionBuilder));
            PluginModel model = new PluginModel(this.owner.intern(this.id), null, version, this.owner.currentContext);
            Supplier<PluginModel> previous = this.owner.plugins.put(this.owner.intern(this.alias), () -> model);
            if (previous != null) {
                LOGGER.warn("Duplicate entry for plugin '{}': {} is replaced with {}", new Object[]{this.alias, previous.get(), model});
            }
        }

        public void version(String version) {
            StrictVersionParser.RichVersion richVersion = this.owner.strictVersionParser.parse(version);
            this.version((Action<? super MutableVersionConstraint>)((Action)vc -> {
                if (richVersion.require != null) {
                    vc.require(richVersion.require);
                }
                if (richVersion.prefer != null) {
                    vc.prefer(richVersion.prefer);
                }
                if (richVersion.strictly != null) {
                    vc.strictly(richVersion.strictly);
                }
            }));
        }

        public void versionRef(String versionRef) {
            this.owner.aliasesInProgress.remove(this.alias);
            this.owner.createPluginAliasWithVersionRef(this.alias, this.id, versionRef);
        }
    }

    private class VersionReferencingDependencyModel
    implements Supplier<DependencyModel> {
        private final String group;
        private final String name;
        private final String versionRef;
        private final String context;

        private VersionReferencingDependencyModel(String group, String name, String versionRef) {
            this.group = group;
            this.name = name;
            this.versionRef = versionRef;
            this.context = DefaultVersionCatalogBuilder.this.currentContext;
        }

        @Override
        public DependencyModel get() {
            VersionModel model = (VersionModel)DefaultVersionCatalogBuilder.this.versionConstraints.get(this.versionRef);
            if (model == null) {
                throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(DefaultVersionCatalogBuilder.this.getProblemsService(), DefaultVersionCatalogBuilder.this.getProblemsService().getInternalReporter().internalCreate(builder -> {
                    InternalProblemSpec configurator = DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, DefaultVersionCatalogBuilder.this.getProblemInVersionCatalog() + "version reference '" + this.versionRef + "' doesn't exist.", VersionCatalogProblemId.UNDEFINED_VERSION_REFERENCE).details("Dependency '" + this.group + ":" + this.name + "' references version '" + this.versionRef + "' which doesn't exist").solution("Declare '" + this.versionRef + "' in the catalog");
                    if (!DefaultVersionCatalogBuilder.this.versionConstraints.keySet().isEmpty()) {
                        configurator.solution("Use one of the following existing versions: " + RenderingUtils.quotedOxfordListOf(DefaultVersionCatalogBuilder.this.versionConstraints.keySet(), (String)"or"));
                    }
                }));
            }
            return new DependencyModel(this.group, this.name, this.versionRef, model.getVersion(), this.context);
        }
    }

    private class VersionReferencingPluginModel
    implements Supplier<PluginModel> {
        private final String id;
        private final String versionRef;
        private final String context;

        private VersionReferencingPluginModel(String id, String versionRef) {
            this.id = id;
            this.versionRef = versionRef;
            this.context = DefaultVersionCatalogBuilder.this.currentContext;
        }

        @Override
        public PluginModel get() {
            VersionModel model = (VersionModel)DefaultVersionCatalogBuilder.this.versionConstraints.get(this.versionRef);
            if (model == null) {
                throw DefaultVersionCatalogBuilder.throwVersionCatalogProblemException(DefaultVersionCatalogBuilder.this.getProblemsService(), DefaultVersionCatalogBuilder.this.getProblemsService().getInternalReporter().internalCreate(builder -> {
                    InternalProblemSpec configurator = DefaultVersionCatalogBuilder.configureVersionCatalogError(builder, DefaultVersionCatalogBuilder.this.getProblemInVersionCatalog() + "version reference '" + this.versionRef + "' doesn't exist.", VersionCatalogProblemId.UNDEFINED_VERSION_REFERENCE).details("Plugin '" + this.id + "' references version '" + this.versionRef + "' which doesn't exist").solution("Declare '" + this.versionRef + "' in the catalog");
                    if (!DefaultVersionCatalogBuilder.this.versionConstraints.keySet().isEmpty()) {
                        configurator.solution("Use one of the following existing versions: " + RenderingUtils.quotedOxfordListOf(DefaultVersionCatalogBuilder.this.versionConstraints.keySet(), (String)"or"));
                    }
                }));
            }
            return new PluginModel(this.id, this.versionRef, model.getVersion(), this.context);
        }
    }
}

