/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Insets;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import tim.prune.App;
import tim.prune.FunctionLibrary;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.UpdateMessageBroker;
import tim.prune.config.Config;
import tim.prune.config.TimezoneHelper;
import tim.prune.data.AltitudeRange;
import tim.prune.data.AudioClip;
import tim.prune.data.Coordinate;
import tim.prune.data.DataPoint;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.RangeStats;
import tim.prune.data.Selection;
import tim.prune.data.SourceInfo;
import tim.prune.data.SpeedCalculator;
import tim.prune.data.SpeedValue;
import tim.prune.data.Unit;
import tim.prune.data.UnitSet;
import tim.prune.data.UnitSetLibrary;
import tim.prune.gui.AudioListener;
import tim.prune.gui.BoxPanel;
import tim.prune.gui.CoordDisplay;
import tim.prune.gui.DisplayUtils;
import tim.prune.gui.FunctionLauncher;
import tim.prune.gui.GenericDisplay;
import tim.prune.gui.IconManager;
import tim.prune.gui.PhotoThumbnail;

public class DetailsDisplay
extends GenericDisplay {
    private final Config _config;
    private JLabel _indexLabel = null;
    private JLabel _latLabel = null;
    private JLabel _longLabel = null;
    private JLabel _altLabel = null;
    private JLabel _ptDateLabel = null;
    private JLabel _ptTimeLabel = null;
    private JLabel _descLabel = null;
    private JLabel _commentLabel = null;
    private JLabel _speedLabel = null;
    private JLabel _vSpeedLabel = null;
    private JLabel _nameLabel = null;
    private JLabel _typeLabel = null;
    private JLabel _filenameLabel = null;
    private static final int NUM_EXTENSION_LABELS = 5;
    private final JLabel[] _ptExtensionLabels = new JLabel[5];
    private JLabel _rangeLabel = null;
    private JLabel _distanceLabel = null;
    private JLabel _durationLabel = null;
    private JLabel _altRangeLabel = null;
    private JLabel _updownLabel = null;
    private JLabel _aveSpeedLabel = null;
    private JPanel _photoDetailsPanel = null;
    private JLabel _photoLabel = null;
    private JLabel _photoPathLabel = null;
    private PhotoThumbnail _photoThumbnail = null;
    private JLabel _photoTimestampLabel = null;
    private JLabel _photoConnectedLabel = null;
    private JLabel _photoBearingLabel = null;
    private JPanel _rotationButtons = null;
    private JPanel _audioDetailsPanel = null;
    private JLabel _audioLabel = null;
    private JLabel _audioPathLabel = null;
    private JLabel _audioConnectedLabel = null;
    private JLabel _audioTimestampLabel = null;
    private JLabel _audioLengthLabel = null;
    private JPanel _playAudioPanel = null;
    private JComboBox<String> _coordFormatDropdown = null;
    private JComboBox<String> _distUnitsDropdown = null;
    private TimeZone _timezone = null;
    private static final String LABEL_POINT_SELECTED = String.valueOf(I18nManager.getText("details.index.selected")) + ": ";
    private static final String LABEL_POINT_LATITUDE = String.valueOf(I18nManager.getText("fieldname.latitude")) + ": ";
    private static final String LABEL_POINT_LONGITUDE = String.valueOf(I18nManager.getText("fieldname.longitude")) + ": ";
    private static final String LABEL_POINT_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_POINT_DATE = String.valueOf(I18nManager.getText("fieldname.date")) + ": ";
    private static final String LABEL_POINT_TIME = String.valueOf(I18nManager.getText("fieldname.timestamp")) + ": ";
    private static final String LABEL_POINT_WAYPOINTNAME = String.valueOf(I18nManager.getText("fieldname.waypointname")) + ": ";
    private static final String LABEL_POINT_WAYPOINTTYPE = String.valueOf(I18nManager.getText("fieldname.waypointtype")) + ": ";
    private static final String LABEL_POINT_DESCRIPTION = String.valueOf(I18nManager.getText("fieldname.description")) + ": ";
    private static final String LABEL_POINT_COMMENT = String.valueOf(I18nManager.getText("fieldname.comment")) + ": ";
    private static final String LABEL_POINT_SPEED = String.valueOf(I18nManager.getText("fieldname.speed")) + ": ";
    private static final String LABEL_POINT_VERTSPEED = String.valueOf(I18nManager.getText("fieldname.verticalspeed")) + ": ";
    private static final String LABEL_POINT_FILENAME = String.valueOf(I18nManager.getText("details.track.file")) + ": ";
    private static final String LABEL_RANGE_SELECTED = String.valueOf(I18nManager.getText("details.range.selected")) + ": ";
    private static final String LABEL_RANGE_DURATION = String.valueOf(I18nManager.getText("fieldname.duration")) + ": ";
    private static final String LABEL_RANGE_DISTANCE = String.valueOf(I18nManager.getText("fieldname.distance")) + ": ";
    private static final String LABEL_RANGE_ALTITUDE = String.valueOf(I18nManager.getText("fieldname.altitude")) + ": ";
    private static final String LABEL_RANGE_CLIMB = String.valueOf(I18nManager.getText("details.range.climb")) + ": ";
    private static final String LABEL_RANGE_DESCENT = ", " + I18nManager.getText("details.range.descent") + ": ";
    private static final String LABEL_AUDIO_FILE = String.valueOf(I18nManager.getText("details.audio.file")) + ": ";
    private static final String LABEL_FULL_PATH = String.valueOf(I18nManager.getText("details.media.fullpath")) + ": ";

    public DetailsDisplay(App app) {
        super(app.getTrackInfo());
        this._config = app.getConfig();
        this.setLayout(new BorderLayout());
        BoxPanel boxPanel = BoxPanel.create();
        boxPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        Font font = new JLabel().getFont();
        font = font.deriveFont(1, font.getSize2D() + 2.0f);
        JPanel jPanel = DetailsDisplay.makeDetailsPanel("details.pointdetails", font);
        this._indexLabel = new JLabel(I18nManager.getText("details.nopointselection"));
        jPanel.add(this._indexLabel);
        this._latLabel = new JLabel("");
        jPanel.add(this._latLabel);
        this._longLabel = new JLabel("");
        jPanel.add(this._longLabel);
        this._altLabel = new JLabel("");
        jPanel.add(this._altLabel);
        this._ptDateLabel = new JLabel("");
        this._ptDateLabel.setMinimumSize(new Dimension(120, 10));
        jPanel.add(this._ptDateLabel);
        this._ptTimeLabel = new JLabel("");
        this._ptTimeLabel.setMinimumSize(new Dimension(120, 10));
        jPanel.add(this._ptTimeLabel);
        this._descLabel = new JLabel("");
        jPanel.add(this._descLabel);
        this._commentLabel = new JLabel("");
        jPanel.add(this._commentLabel);
        this._speedLabel = new JLabel("");
        jPanel.add(this._speedLabel);
        this._vSpeedLabel = new JLabel("");
        jPanel.add(this._vSpeedLabel);
        this._nameLabel = new JLabel("");
        jPanel.add(this._nameLabel);
        this._typeLabel = new JLabel("");
        jPanel.add(this._typeLabel);
        this._filenameLabel = new JLabel("");
        jPanel.add(this._filenameLabel);
        int n = 0;
        while (n < 5) {
            this._ptExtensionLabels[n] = new JLabel("example");
            jPanel.add(this._ptExtensionLabels[n]);
            ++n;
        }
        JPanel jPanel2 = DetailsDisplay.makeDetailsPanel("details.rangedetails", font);
        this._rangeLabel = new JLabel(I18nManager.getText("details.norangeselection"));
        jPanel2.add(this._rangeLabel);
        this._distanceLabel = new JLabel("");
        jPanel2.add(this._distanceLabel);
        this._durationLabel = new JLabel("");
        jPanel2.add(this._durationLabel);
        this._aveSpeedLabel = new JLabel("");
        jPanel2.add(this._aveSpeedLabel);
        this._altRangeLabel = new JLabel("");
        jPanel2.add(this._altRangeLabel);
        this._updownLabel = new JLabel("");
        jPanel2.add(this._updownLabel);
        this._photoDetailsPanel = DetailsDisplay.makeDetailsPanel("details.photodetails", font);
        this._photoLabel = new JLabel(I18nManager.getText("details.nophoto"));
        this._photoDetailsPanel.add(this._photoLabel);
        this._photoPathLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoPathLabel);
        this._photoTimestampLabel = new JLabel("");
        this._photoTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._photoDetailsPanel.add(this._photoTimestampLabel);
        this._photoConnectedLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoConnectedLabel);
        this._photoBearingLabel = new JLabel("");
        this._photoDetailsPanel.add(this._photoBearingLabel);
        this._photoThumbnail = new PhotoThumbnail();
        this._photoThumbnail.setVisible(false);
        this._photoThumbnail.setPreferredSize(new Dimension(100, 100));
        this._photoDetailsPanel.add(this._photoThumbnail);
        IconManager iconManager = app.getIconManager();
        JButton jButton = DetailsDisplay.makeRotateButton(iconManager, "controls/rotate-left", FunctionLibrary.FUNCTION_ROTATE_PHOTO_LEFT);
        JButton jButton2 = DetailsDisplay.makeRotateButton(iconManager, "controls/rotate-right", FunctionLibrary.FUNCTION_ROTATE_PHOTO_RIGHT);
        JButton jButton3 = DetailsDisplay.makeRotateButton(iconManager, "controls/show-image", FunctionLibrary.FUNCTION_PHOTO_POPUP);
        this._rotationButtons = new JPanel();
        this._rotationButtons.add(jButton);
        this._rotationButtons.add(jButton2);
        this._rotationButtons.add(Box.createHorizontalStrut(10));
        this._rotationButtons.add(jButton3);
        this._rotationButtons.setAlignmentX(0.0f);
        this._rotationButtons.setVisible(false);
        this._photoDetailsPanel.add(this._rotationButtons);
        this._photoDetailsPanel.setVisible(false);
        this._audioDetailsPanel = DetailsDisplay.makeDetailsPanel("details.audiodetails", font);
        this._audioLabel = new JLabel(I18nManager.getText("details.noaudio"));
        this._audioDetailsPanel.add(this._audioLabel);
        this._audioPathLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioPathLabel);
        this._audioTimestampLabel = new JLabel("");
        this._audioTimestampLabel.setMinimumSize(new Dimension(120, 10));
        this._audioDetailsPanel.add(this._audioTimestampLabel);
        this._audioLengthLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioLengthLabel);
        this._audioConnectedLabel = new JLabel("");
        this._audioDetailsPanel.add(this._audioConnectedLabel);
        JProgressBar jProgressBar = new JProgressBar(0, 100);
        jProgressBar.setString(I18nManager.getText("details.audio.playing"));
        jProgressBar.setStringPainted(true);
        jProgressBar.setVisible(false);
        this._audioDetailsPanel.add(jProgressBar);
        this._playAudioPanel = new JPanel();
        this._playAudioPanel.setLayout(new FlowLayout(2));
        JButton jButton4 = DetailsDisplay.makeRotateButton(iconManager, "controls/play", FunctionLibrary.FUNCTION_PLAY_AUDIO);
        jButton4.addActionListener(new AudioListener(jProgressBar));
        this._playAudioPanel.add(jButton4);
        JButton jButton5 = DetailsDisplay.makeRotateButton(iconManager, "controls/stop", FunctionLibrary.FUNCTION_STOP_AUDIO);
        this._playAudioPanel.add(jButton5);
        this._playAudioPanel.setVisible(false);
        this._audioDetailsPanel.add(this._playAudioPanel);
        this._audioDetailsPanel.setVisible(false);
        boxPanel.add(jPanel);
        boxPanel.add(Box.createVerticalStrut(5));
        boxPanel.add(jPanel2);
        boxPanel.add(Box.createVerticalStrut(5));
        boxPanel.add(this._photoDetailsPanel);
        boxPanel.add(Box.createVerticalStrut(5));
        boxPanel.add(this._audioDetailsPanel);
        boxPanel.add(Box.createVerticalStrut(5));
        this.add((Component)boxPanel, "North");
        BoxPanel boxPanel2 = BoxPanel.create();
        JLabel jLabel = new JLabel(String.valueOf(I18nManager.getText("details.coordformat")) + ": ");
        boxPanel2.add(jLabel);
        String[] stringArray = new String[]{I18nManager.getText("units.original"), I18nManager.getText("units.degminsec"), I18nManager.getText("units.degmin"), I18nManager.getText("units.deg")};
        this._coordFormatDropdown = new JComboBox<String>(stringArray);
        this._coordFormatDropdown.addActionListener(actionEvent -> this.dataUpdated(32));
        boxPanel2.add(this._coordFormatDropdown);
        JLabel jLabel2 = new JLabel(String.valueOf(I18nManager.getText("details.distanceunits")) + ": ");
        boxPanel2.add(jLabel2);
        this._distUnitsDropdown = new JComboBox();
        UnitSet unitSet = this._config.getUnitSet();
        int n2 = 0;
        while (n2 < UnitSetLibrary.getNumUnitSets()) {
            this._distUnitsDropdown.addItem(I18nManager.getText(UnitSetLibrary.getUnitSet(n2).getDistanceUnit().getNameKey()));
            if (UnitSetLibrary.getUnitSet(n2) == unitSet) {
                this._distUnitsDropdown.setSelectedIndex(n2);
            }
            ++n2;
        }
        this._distUnitsDropdown.addActionListener(actionEvent -> {
            this._config.selectUnitSet(this._distUnitsDropdown.getSelectedIndex());
            UpdateMessageBroker.informSubscribers(32);
        });
        boxPanel2.add(this._distUnitsDropdown);
        this.add((Component)boxPanel2, "South");
    }

    @Override
    public void dataUpdated(int n) {
        String string;
        int n2;
        Object object;
        String string2;
        Object object2;
        Object object3;
        DataPoint dataPoint = this._trackInfo.getCurrentPoint();
        Selection selection = this._trackInfo.getSelection();
        int n3 = selection.getCurrentPointIndex();
        this._speedLabel.setText("");
        UnitSet unitSet = UnitSetLibrary.getUnitSet(this._distUnitsDropdown.getSelectedIndex());
        Unit unit = unitSet.getDistanceUnit();
        String string3 = I18nManager.getText(unit.getShortnameKey());
        String string4 = I18nManager.getText(unitSet.getSpeedUnit().getShortnameKey());
        if (this._timezone == null || (n | 0x20) > 0) {
            this._timezone = TimezoneHelper.getSelectedTimezone(this._config);
        }
        if ((n | 0x20) > 0) {
            this._config.setConfigString("prune.coorddisplay", this.getSelectedCoordFormat().toString());
        }
        if (this._track == null || dataPoint == null) {
            this._indexLabel.setText(I18nManager.getText("details.nopointselection"));
            this._latLabel.setText("");
            this._longLabel.setText("");
            this._altLabel.setText("");
            this._ptDateLabel.setText("");
            this._ptTimeLabel.setText("");
            this._descLabel.setText("");
            this._commentLabel.setText("");
            this._nameLabel.setText("");
            this._typeLabel.setText("");
            this._speedLabel.setText("");
            this._vSpeedLabel.setText("");
            this._filenameLabel.setText("");
            this.clearPointExtensionLabels();
        } else {
            SourceInfo sourceInfo;
            this._indexLabel.setText(String.valueOf(LABEL_POINT_SELECTED) + (n3 + 1) + " " + I18nManager.getText("details.index.of") + " " + this._track.getNumPoints());
            this._latLabel.setText(String.valueOf(LABEL_POINT_LATITUDE) + CoordDisplay.makeCoordinateLabel(dataPoint.getLatitude(), this.getSelectedCoordFormat()));
            this._longLabel.setText(String.valueOf(LABEL_POINT_LONGITUDE) + CoordDisplay.makeCoordinateLabel(dataPoint.getLongitude(), this.getSelectedCoordFormat()));
            object3 = this._config.getUnitSet().getAltitudeUnit();
            this._altLabel.setText(dataPoint.hasAltitude() ? String.valueOf(LABEL_POINT_ALTITUDE) + dataPoint.getAltitude().getIntValue((Unit)object3) + " " + I18nManager.getText(((Unit)object3).getShortnameKey()) : "");
            if (dataPoint.hasTimestamp()) {
                this._ptDateLabel.setText(String.valueOf(LABEL_POINT_DATE) + dataPoint.getTimestamp().getDateText(this._timezone));
                this._ptTimeLabel.setText(String.valueOf(LABEL_POINT_TIME) + dataPoint.getTimestamp().getTimeText(this._timezone));
            } else {
                this._ptDateLabel.setText("");
                this._ptTimeLabel.setText("");
            }
            this.showDescriptionOrComment(dataPoint);
            object2 = new SpeedValue();
            SpeedCalculator.calculateSpeed(this._track, n3, this._config.getUnitSet(), (SpeedValue)object2);
            if (((SpeedValue)object2).isValid()) {
                string2 = String.valueOf(DisplayUtils.roundedNumber(((SpeedValue)object2).getValue())) + " " + string4;
                this._speedLabel.setText(String.valueOf(LABEL_POINT_SPEED) + string2);
            } else {
                this._speedLabel.setText("");
            }
            SpeedCalculator.calculateVerticalSpeed(this._track, n3, this._config.getUnitSet(), (SpeedValue)object2);
            if (((SpeedValue)object2).isValid()) {
                string2 = I18nManager.getText(unitSet.getVerticalSpeedUnit().getShortnameKey());
                object = String.valueOf(DisplayUtils.roundedNumber(((SpeedValue)object2).getValue())) + " " + string2;
                this._vSpeedLabel.setText(String.valueOf(LABEL_POINT_VERTSPEED) + (String)object);
            } else {
                this._vSpeedLabel.setText("");
            }
            string2 = dataPoint.getWaypointName();
            if (string2 != null && !string2.equals("")) {
                this._nameLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTNAME) + string2);
            } else {
                this._nameLabel.setText("");
            }
            object = dataPoint.getFieldValue(Field.WAYPT_TYPE);
            if (object != null && !((String)object).equals("")) {
                this._typeLabel.setText(String.valueOf(LABEL_POINT_WAYPOINTTYPE) + (String)object);
            } else {
                this._typeLabel.setText("");
            }
            n2 = this._trackInfo.getFileInfo().getNumFiles();
            string = null;
            if (n2 > 1 && (sourceInfo = dataPoint.getSourceInfo()) != null) {
                string = sourceInfo.getName();
            }
            if (string != null) {
                this._filenameLabel.setText(String.valueOf(LABEL_POINT_FILENAME) + string);
                this._filenameLabel.setToolTipText(string);
            } else {
                this._filenameLabel.setText("");
                this._filenameLabel.setToolTipText("");
            }
            this.setPointExtensionLabels(dataPoint);
        }
        if (this._track == null || !selection.hasRangeSelected()) {
            this._rangeLabel.setText(I18nManager.getText("details.norangeselection"));
            this._distanceLabel.setText("");
            this._durationLabel.setText("");
            this._altRangeLabel.setText("");
            this._updownLabel.setText("");
            this._aveSpeedLabel.setText("");
        } else {
            object3 = selection.getRangeStats(this._config);
            this._rangeLabel.setText(String.valueOf(LABEL_RANGE_SELECTED) + (selection.getStart() + 1) + " " + I18nManager.getText("details.range.to") + " " + (selection.getEnd() + 1));
            this._distanceLabel.setText(String.valueOf(LABEL_RANGE_DISTANCE) + DisplayUtils.roundedNumber(((RangeStats)object3).getMovingDistance(unit)) + " " + string3);
            long l = ((RangeStats)object3).getMovingDurationInSeconds();
            if (l > 0L) {
                this._durationLabel.setText(String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(l));
                this._aveSpeedLabel.setText(String.valueOf(I18nManager.getText("details.range.avespeed")) + ": " + DisplayUtils.roundedNumber(((RangeStats)object3).getMovingDistance(unit) / (double)l * 3600.0) + " " + string4);
            } else {
                this._durationLabel.setText("");
                this._aveSpeedLabel.setText("");
            }
            object = ((RangeStats)object3).getMovingAltitudeRange();
            Unit unit2 = this._config.getUnitSet().getAltitudeUnit();
            string = I18nManager.getText(unit2.getShortnameKey());
            if (((AltitudeRange)object).hasRange()) {
                this._altRangeLabel.setText(String.valueOf(LABEL_RANGE_ALTITUDE) + ((AltitudeRange)object).getMinimum(unit2) + string + " " + I18nManager.getText("details.altitude.to") + " " + ((AltitudeRange)object).getMaximum(unit2) + string);
                this._updownLabel.setText(String.valueOf(LABEL_RANGE_CLIMB) + ((AltitudeRange)object).getClimb(unit2) + string + LABEL_RANGE_DESCENT + ((AltitudeRange)object).getDescent(unit2) + string);
            } else {
                this._altRangeLabel.setText("");
                this._updownLabel.setText("");
            }
        }
        this._photoDetailsPanel.setVisible(this._trackInfo.getPhotoList().hasAny());
        object3 = this._trackInfo.getPhotoList().get(this._trackInfo.getSelection().getCurrentPhotoIndex());
        if ((dataPoint == null || dataPoint.getPhoto() == null) && object3 == null) {
            this._photoLabel.setText(I18nManager.getText("details.nophoto"));
            this._photoLabel.setToolTipText("");
            this._photoPathLabel.setText("");
            this._photoPathLabel.setToolTipText("");
            this._photoTimestampLabel.setText("");
            this._photoConnectedLabel.setText("");
            this._photoBearingLabel.setText("");
            this._photoThumbnail.setVisible(false);
            this._rotationButtons.setVisible(false);
        } else {
            if (object3 == null) {
                object3 = dataPoint.getPhoto();
            }
            this._photoLabel.setText(String.valueOf(I18nManager.getText("details.photofile")) + ": " + DetailsDisplay.shortenString(((MediaObject)object3).getName()));
            this._photoLabel.setToolTipText(((MediaObject)object3).getName());
            object2 = ((MediaObject)object3).getFullPath();
            string2 = DetailsDisplay.shortenPath((String)object2);
            this._photoPathLabel.setText(object2 == null ? "" : String.valueOf(LABEL_FULL_PATH) + string2);
            this._photoPathLabel.setToolTipText(((MediaObject)object3).getFullPath());
            this._photoTimestampLabel.setText(((MediaObject)object3).hasTimestamp() ? String.valueOf(LABEL_POINT_TIME) + ((MediaObject)object3).getTimestamp().getText(this._timezone) : "");
            this._photoConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object3).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
            if (((Photo)object3).getBearing() >= 0.0 && ((Photo)object3).getBearing() <= 360.0) {
                this._photoBearingLabel.setText(String.valueOf(I18nManager.getText("details.photo.bearing")) + ": " + (int)((Photo)object3).getBearing() + " \u00b0");
            } else {
                this._photoBearingLabel.setText("");
            }
            this._photoThumbnail.setVisible(true);
            this._photoThumbnail.setPhoto((Photo)object3);
            this._rotationButtons.setVisible(true);
            if ((n & 0x10) > 0) {
                this._photoThumbnail.refresh();
            }
        }
        this._photoThumbnail.repaint();
        this._audioDetailsPanel.setVisible(this._trackInfo.getAudioList().hasAny());
        object2 = this._trackInfo.getAudioList().get(this._trackInfo.getSelection().getCurrentAudioIndex());
        if (object2 == null) {
            this._audioLabel.setText(I18nManager.getText("details.noaudio"));
            this._audioPathLabel.setText("");
            this._audioPathLabel.setToolTipText("");
            this._audioTimestampLabel.setText("");
            this._audioLengthLabel.setText("");
            this._audioConnectedLabel.setText("");
        } else {
            this._audioLabel.setText(String.valueOf(LABEL_AUDIO_FILE) + ((MediaObject)object2).getName());
            string2 = ((MediaObject)object2).getFullPath();
            object = DetailsDisplay.shortenPath(string2);
            this._audioPathLabel.setText(string2 == null ? "" : String.valueOf(LABEL_FULL_PATH) + (String)object);
            this._audioPathLabel.setToolTipText(string2 == null ? "" : string2);
            this._audioTimestampLabel.setText(((MediaObject)object2).hasTimestamp() ? String.valueOf(LABEL_POINT_TIME) + ((MediaObject)object2).getTimestamp().getText(this._timezone) : "");
            n2 = ((AudioClip)object2).getLengthInSeconds();
            this._audioLengthLabel.setText(n2 < 0 ? "" : String.valueOf(LABEL_RANGE_DURATION) + DisplayUtils.buildDurationString(n2));
            this._audioConnectedLabel.setText(String.valueOf(I18nManager.getText("details.media.connected")) + ": " + (((MediaObject)object2).getCurrentStatus() == MediaObject.Status.NOT_CONNECTED ? I18nManager.getText("dialog.about.no") : I18nManager.getText("dialog.about.yes")));
        }
        this._playAudioPanel.setVisible(object2 != null);
    }

    private void clearPointExtensionLabels() {
        JLabel[] jLabelArray = this._ptExtensionLabels;
        int n = this._ptExtensionLabels.length;
        int n2 = 0;
        while (n2 < n) {
            JLabel jLabel = jLabelArray[n2];
            jLabel.setText("");
            ++n2;
        }
    }

    private void setPointExtensionLabels(DataPoint dataPoint) {
        int n = 0;
        FieldList fieldList = dataPoint.getFieldList();
        int n2 = 0;
        while (n2 < fieldList.getNumFields()) {
            String string;
            Field field = fieldList.getField(n2);
            if (!(field.isBuiltIn() || n >= 5 || (string = dataPoint.getFieldValue(field)) == null || string.isEmpty() || field.isBuiltIn())) {
                this._ptExtensionLabels[n].setText(String.valueOf(field.getName()) + ": " + string);
                ++n;
            }
            ++n2;
        }
        while (n < 5) {
            this._ptExtensionLabels[n].setText("");
            ++n;
        }
    }

    private void showDescriptionOrComment(DataPoint dataPoint) {
        String string = dataPoint.getFieldValue(Field.DESCRIPTION);
        this.showDescriptionOrComment(this._descLabel, LABEL_POINT_DESCRIPTION, string);
        String string2 = dataPoint.getFieldValue(Field.COMMENT);
        if (string2 == null || string2.isEmpty() || string2.equals(string)) {
            string2 = "";
        }
        this.showDescriptionOrComment(this._commentLabel, LABEL_POINT_COMMENT, string2);
    }

    private void showDescriptionOrComment(JLabel jLabel, String string, String string2) {
        if (string.isEmpty() || string2 == null || string2.isEmpty()) {
            jLabel.setText("");
            jLabel.setToolTipText("");
        } else {
            if (string2.length() < 10) {
                jLabel.setText(String.valueOf(string) + string2);
            } else {
                jLabel.setText(DetailsDisplay.shortenString(string2));
            }
            jLabel.setToolTipText(String.valueOf(string) + string2);
        }
    }

    private static JPanel makeDetailsPanel(String string, Font font) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(1), BorderFactory.createEmptyBorder(3, 3, 3, 3)));
        JLabel jLabel = new JLabel(I18nManager.getText(string));
        jLabel.setFont(font);
        jPanel.add(jLabel);
        return jPanel;
    }

    private static JButton makeRotateButton(IconManager iconManager, String string, GenericFunction genericFunction) {
        JButton jButton = new JButton(iconManager.getImageIcon(string));
        jButton.setToolTipText(genericFunction.getName());
        jButton.setMargin(new Insets(0, 2, 0, 2));
        jButton.addActionListener(new FunctionLauncher(genericFunction));
        return jButton;
    }

    private static String shortenPath(String string) {
        String string2 = string;
        String string3 = System.getProperty("user.home").toLowerCase();
        if (string != null && string.toLowerCase().startsWith(string3)) {
            string2 = string.substring(string3.length() + 1);
        }
        return DetailsDisplay.shortenString(string2);
    }

    private static String shortenString(String string) {
        if (string == null || string.length() < 26) {
            return string;
        }
        return String.valueOf(string.substring(0, 25)) + "...";
    }

    private Coordinate.Format getSelectedCoordFormat() {
        switch (this._coordFormatDropdown.getSelectedIndex()) {
            case 1: {
                return Coordinate.Format.DEG_MIN_SEC;
            }
            case 2: {
                return Coordinate.Format.DEG_MIN;
            }
            case 3: {
                return Coordinate.Format.DEG;
            }
        }
        return Coordinate.Format.NONE;
    }
}

