/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;

public class LatLonRectangle {
    private final DoubleRange _latRange;
    private final DoubleRange _lonRange;

    public LatLonRectangle(DoubleRange doubleRange, DoubleRange doubleRange2) {
        this._latRange = doubleRange;
        this._lonRange = doubleRange2;
    }

    public boolean isEmpty() {
        return this._latRange == null || this._lonRange == null || !this._latRange.hasData() || !this._lonRange.hasData();
    }

    public boolean containsPoint(DataPoint dataPoint) {
        if (dataPoint != null && !this.isEmpty()) {
            double d = dataPoint.getLatitude().getDouble();
            double d2 = dataPoint.getLongitude().getDouble();
            return d >= this._latRange.getMinimum() && d <= this._latRange.getMaximum() && d2 >= this._lonRange.getMinimum() && d2 <= this._lonRange.getMaximum();
        }
        return false;
    }
}

